<?php
/****
* Titre........... : Classe Prolawyer
* Description..... : Ensemble de fonctions pour la mise en place d'outils de gestion dans un site web
* version......... : 4.0
* date............ : 1.3.2010
* fichier......... : prolawyer.class.php
* Auteur.......... : Olivier Subilia (etudeav@users.sourceforge.net)
*
* remarques ...... : Cette classe s'appuie sur la classe functions.class.php, qui doit avoir t requise avant l'ouverture de la prsente
* licence......... : The GNU General Public License (GPL) 
*					 http://www.opensource.org/licenses/gpl-license.html
*
****/
		
/*******************************************************************
*
*    class 
*
********************************************************************/

class prolawyer extends functions
{
	function __construct($connection = TRUE)
	{
		
		#GPC ne me va pas dans $_REQUEST...
		unset($_REQUEST);
		$_REQUEST = array();
		foreach(array($_POST, $_GET) as $tableau) foreach($tableau as $n => $v) $_REQUEST[$n] = $v;
		#Il faut imprativement tester l'existence de MySQL, sans quoi le programme plantera, et le fera silencieusement sur de trop nombreuses distributions
		if(!function_exists("mysql_query"))
		{
			error_reporting(7);
			$this->noLangRequire=True;
			$this->catchError("040-101:111", 4);
			echo $this->echoError(); //C'est une erreur fatale, donc si la fonction manque, le fichier die() dans echoError();
		}
		
 		if(isset($_GET["get"]) && $_GET["get"] == "true") foreach($_GET as $nom => $val) $_POST["$nom"] = $val;
//  		$this->tab_affiche();
 		$this->debugNow("Dbut de Prolawyer($connection)");
//  		$this->setDebugNow = true;
 		error_reporting(E_ALL & ~E_NOTICE);
 		ini_set("display_errors", 1);
// 		echo "Le niveau d'erreur est ".error_reporting();
		if(function_exists(mysql_query))
		{
			$this->getRelPath();
			$this->getVersion($connection); // A demander  chaque page. Cela prend un tout petit peu plus de temps mais assure qu'il n'y a jamais de problme de mise  jour. On peut ensuite retravailler le menu configuration, en distinguant la page de mise  jour des autres pages de configuration.
			$this->getOptions($connection); //options passes en session. En principe appeles une seule fois, sinon la fonction ressort sans relire
			$this->getOptionsPerso($connection); //options passes en session relatives  l'utilisateur. En principe appeles une seule fois, sinon la fonction ressort sans relire
			$this->getPagesOptions(); //options de la page, qui doivent tre recharges  chaque page
			$this->getActLang($connection);
			$this->getLangFile();
			$this->perm_list();
			$this->getNextValues();
			$this->registerPda();
			$this->registerOptionsPerso();
			if($connection && $connection !== "firstCheck")
			{
				$this->connection();
				$this->registerDb();
			}
			$this->getTemplates();
		}
	}
	
	
	/*Fonctions de gestion des options et des chemins*/
	
	function getRelPath()
	{
		$this->anchor = basename($_SERVER["PHP_SELF"], ".php");
		$this->rel_file_name=$this->anchor;
		$this->settings["root"] = "./";
		while (!is_file("root.php"))
		{
			if($this->settings["root"] == "./")
			{
				$this->cur_dir=getcwd();
				$this->settings["root"] = "";
			}
			chdir("..");
			$this->settings["root"] .= "../";
		}
		$this->settings["path"] = getcwd();
		if($this->settings["root"] != "./")
		{
			chdir ($this->cur_dir);
			$this->rel_dir = trim(substr(preg_replace("#(\\|/)#", "_", getcwd()), strlen($this->settings["path"]) + 1));
			$this->anchor = $this->rel_dir."_".$this->anchor;
			$this->rel_file_name=$this->rel_dir."/".$this->rel_file_name;
		}
  		$this->rel_file_name .= ".php";
	}
	
	function getNextValues()
	{
	//pour le changement de base 
		if(($this->anchor == "operations" && $_POST["secteur"] == "tva") || $this->anchor == "liste_soldes" || $this->anchor == "ra")
		{ 
			$this->next_select=$this->anchor;
			$this->next_values="on";
		}else{  
			$this->next_select="recherche_dossier";
			$this->next_values="";
		}
	}
	
	function registerDb()
	{
		if(isset($_POST["new_av"]))  
		{ 
			$_SESSION["db"]=$_POST["new_av"];
			$this->setOptionsPerso("db", $_POST["new_av"]);
			$newOpt = $this->getUtilisateurOptions($_POST["new_av"]);
			foreach($newOpt as $n => $v) if($n != "user" && $n != "nou") $_SESSION["optionGen"]["$n"] = $v;
// 			$this->setCookie("base", $_POST["new_av"]);
		
		}
		$this->dbIsRegistring = true;
		if (!$_SESSION["db"] && $this->getSinglePersoOption("db")) $_SESSION["db"] = $this->getSinglePersoOption("db");
		if(!$_SESSION["db"])
		{
			$test=$this->liste_droits("_{$_SESSION["user"]}", true);
			foreach($test as $init => $arr) if(isset($test["$init"]["{$_SESSION["user"]}"]) && $test["$init"]["{$_SESSION["user"]}"]["lire"])
			{
// 				echo "<br>Bon pour la base '$init'";
				$_SESSION["db"] = $init;
				break;
			}
// 			echo "toto".$this->liste_des_droits;
// 			$this->tab_affiche($this->liste_des_droits);
		}
		if($_SESSION["db"]) $this->setOptionsPerso("db", $_SESSION["db"]);
		unset($this->dbIsRegistring);
// 		if (!$_SESSION["db"] && $this->getCookie("base")) $_SESSION["db"] = $this->getCookie("base");
			
		$_SESSION["session_avdb"] = $_SESSION["db"]."clients";
		$_SESSION["session_opdb"] = $_SESSION["db"]."op";
		$this->avocat = $this->init_to_name();
//  		$this->tab_affiche(2);
	}
	
	function registerPda()
	{
		if(isset($_REQUEST["pda"]))  
		{ 
			$_SESSION["db"]=$_POST["new_av"];
			$this->setCookie("pda", $_REQUEST["pda"]);
		}
	}
	
	function registerLocale($force=false)
	{
		if($_SESSION["locale"] && !$force && !$_GET["langue_choisie"])
		{
			$locale = setlocale(LC_ALL, $_SESSION["locale"]);
		}
		$tests = $this->open_and_prepare("{$this->settings["root"]}lang/langs.php");
		$lang = $_SESSION["lang"];
		foreach($tests as $test)
		{
			list(, $l, , $cCodes) = preg_split("#,#", $test);
			if($l == $lang)
			{
				$locales = array();
				$suffixes = array("", ".utf8", ".UTF8", "@euro", "@EURO", ".ISO-8859-15", ".ISO-8859-1");
				$codes = explode(";", $cCodes);
				foreach($codes as $code) foreach($suffixes as $suffixe) $locales[] = "{$lang}_{$code}{$suffixe}";
			}
		}
		$locale = setlocale(LC_ALL, $locales);
		$_SESSION["locale"] = $locale;
	}
	
        function init_to_name($init="")
        {
                $name="";
                if($init=="") if(isset($_SESSION["db"])) $init=$_SESSION["db"];
                $query = "select nom from utilisateurs where initiales like '$init'";
                @$ex=mysql_query($query);
                if($ex)
                {
                        while($row=mysql_fetch_array($ex)) return $row["nom"];
                }
        }
	
	
	function setOptionsPerso($option, $value, $user ="")
	{
		if(!$user) $user = $_SESSION["user"];
		$q1 = "insert into acces set user = '$user', $option = '$value'";
		$e1 = @mysql_query($q1); //ne marchera pas si l'utilisateur est dj existant
		$q = "update acces set $option = '$value' where user like '$user'";
		$e = @mysql_query($q);
		if($user == $_SESSION["user"]) $_SESSION["$option"] = $value;
		
		/*codes de retour: 
		0 = rat, 
		1 = insertion russie d'une nouvelle donne mais mise  jour rate (ne devrait jamais se produire), 
		2 = modification russie d'une donne existante, 
		3 = insertion russie d'une nouvelle donne*/
		return $e1 + 2* $e;
	}

	function setUtilisateurOption($option, $value, $init ="")
	{
		if(!$init) $init = $_SESSION["db"];
		$qi = "select * from utilisateurs where initiales like '$init'";
		$ei = mysql_query($qi);
		$n  = mysql_num_rows($ei);
		if($n)	$q = "update utilisateurs set $option = '$value' where initiales like '$init'";
		else	$q = "insert into utilisateurs set initiales = '$init', $option = '$value'";
		#echo "<br>Excut. '$q'";
		$e = mysql_query($q);
		
		/*codes de retour: 
		0 = rat, 
		1 = insertion russie d'une nouvelle donne
		2 = modification russie d'une donne existante*/
		return ($n + 1)* $e;
	}

	function registerOptionsPerso()
	{
		foreach(array("nb_affiche") as $nom)
		{
			if(isset($_POST["$nom"]))
			{
				$this->setOptionsPerso("$nom", $_POST["$nom"]);
				unset($_POST["$nom"]);
			}
		}
	}
	
	function unsetOptionsPerso($option, $user ="")
	{
		if(!$user) $user = $_SESSION["user"];
		$q = "update acces set $option = '' where user like '$user'";
		$e = mysql_query($q);
		if($user == $_SESSION["user"]) unset($_SESSION["$option"]);
		
		return $e;
	}
	
	function getUtilisateurOptions($utilisateur)
	{
		$arr=array();
		//default user options
		$q = "select * from utilisateurs where nom like 'tableDefaultValue'";
		$e = mysql_query($q);
		while($r = mysql_fetch_array($e, MYSQL_ASSOC)) foreach($r as $n => $v) if($n != "user" && $n != "nou")
		{
			$arr["$n"] = $v;
		}
				
		
		//user options
		$q = "select * from utilisateurs where initiales like '$utilisateur'";
		$e = mysql_query($q);
		if(!$e) return array();
		while($r = mysql_fetch_array($e, MYSQL_ASSOC)) foreach($r as $n => $v) if($n != "user" && $n != "nou")
		{
			if($v)
			{
				$arr["$n"] = $v;
			}
		}
		return $arr;
	}
	
	function getSinglePersoOption($option, $acces = "default")
	{
		$acces = ($acces == "default") ? $_SESSION["user"]:$acces;
		$q = "select db from acces where user like '$acces'";
		$e = mysql_query($q);
		while ($r = mysql_fetch_array($e))
		{
			$_SESSION["$option"] = $r["$option"];
		}
		return $r["$option"];
	}
	
	function getOptionsPerso($arg = "", $user ="")
	{
		if(!$user AND !$_SESSION["user"])
		{
			return;
		}
		elseif(!$user AND $_SESSION["user"])
		{
			if(!$arg || $arg == "firstCheck") return; //si on n'a pas forc la relecture des options, on sort, parce que cela veut dire que c'est dj dfini.
			$user = $_SESSION["user"];
		}
		else $arr = array();
		if(!$this->doConnectDb($_SESSION["dbAdmin"], $_SESSION["dbPwd"])) return array();
		
		//default user options
		$q = "select * from utilisateurs where nom like 'tableDefaultValue'";
		$e = mysql_query($q);
		while($r = mysql_fetch_array($e, MYSQL_ASSOC)) foreach($r as $n => $v) if($n != "user" && $n != "nou")
		{
			if($user == $_SESSION["user"]) $_SESSION["optionGen"]["$n"] = $v;
			else $arr["$n"] = $v;
		}
				
		
		//user options
		$q = "select * from utilisateurs where initiales like '{$_SESSION["db"]}'";
		$e = mysql_query($q);
		if(!$e) return array();
		while($r = mysql_fetch_array($e, MYSQL_ASSOC)) foreach($r as $n => $v) if($n != "user" && $n != "nou")
		{
			if($v)
			{
				if($user == $_SESSION["user"]) $_SESSION["optionGen"]["$n"] = $v;
				else $arr["$n"] = $v;
			}
		}
		
		//default acces options
		$q = "select * from acces where user like 'tableDefaultValue'";
		$e = mysql_query($q);
		if(!$e) return array();
		while($r = mysql_fetch_array($e, MYSQL_ASSOC)) foreach($r as $n => $v) if($n != "user")
		{
			if($user == $_SESSION["user"]) $_SESSION["$n"] = $v;
			else $arr["$n"] = $v;
		}
		
		//acces options
		$q = "select * from acces where user like '$user'";
		$e = mysql_query($q);
		if(!$e) return array();
		while($r = mysql_fetch_array($e, MYSQL_ASSOC)) foreach($r as $n => $v) if($n != "user")
		{
			if($v)
			{
				if($user == $_SESSION["user"]) $_SESSION["$n"] = $v;
				else $arr["$n"] = $v;
			}
		}
		
		if(!$this->dbIsRegistring) $this->registerDb(); //sans quoi on a une boucle infinie avec registerDb();
		$this->right = $_SESSION["type"]; // rtrocompatibilit avec l'appel  $this->right qui figure partout.
		return $arr;
	}
	
	function getPagesOptions()
	{
		//rglages personnels (utilisateurs) qui dpendent de $this->settings[root] ou qui sont susceptibles de changer. Ces rglages doivent tre appels obligatoirement  chaque page, mme si getOptions() n'est pas appele
		if(isset($_SESSION["session_utilisateur"])) $this->styles_user="{$this->settings["confpath"]}styles_".$_SESSION["session_utilisateur"].".css";
		else $this->styles_user="no_file";
		$this->styles_template=$this->settings["root"]."templates/styles_default.css";
		if(is_file("{$this->styles_user}")) $_SESSION["stylesfile"]=$this->styles_user;
		else $_SESSION["stylesfile"] = $this->styles_template;
	}

	function setOption($option, $value, $needle = "=")
	{
		$arr = $this->open_and_prepare($_SESSION["optionsFile"]);
		$arr = $this->wipe_array($arr, $option, $needle);
		if(is_array($value))
		{
			while($arr != $arr2)
			{
				$arr2 = $arr;
// 				echo "tata $arr2 $arr titi";
				$arr = $this->wipe_array($arr2, $option, $needle);
			}
			foreach($value as $val) array_push($arr, $option.$needle.$val);
		}
		else array_push($arr, $option.$needle.$value);
		$this->close_and_write($arr, $_SESSION["optionsFile"]);
	}
	
	function unsetOption($option, $needle = "=")
	{
		$arr = $this->open_and_prepare($_SESSION["optionsFile"]);
		$arr = $this->wipe_array($arr, $option, $needle);
		$this->close_and_write($arr, $_SESSION["optionsFile"]);
		if(isset($_SESSION["$option"])) unset ($_SESSION["$option"]);
	}
	
	function defaultBases($personne = "", $force = false)
	{
		foreach(array("lire", "lire_agenda") as $module)
		{
			if(isset($_SESSION["{$module}DefaultBase"]) && !$force) return;
			
		}
	}
	
	function getVersion($exit=true)
	{
		//version du programme
		$version = is_file("{$this->settings["root"]}version.txt") ? trim(file_get_contents("{$this->settings["root"]}version.txt")):"no_version";
// 		echo "Version: '$version'\n<br>VERSION: {$_SESSION["version"]}";
		if($exit && $exit != "noExit" && (($_SESSION["version"] && $_SESSION["version"] != $version) || ($_SESSION["tablesUpdated"] && $_SESSION["tablesUpdated"] != $version) || ($_SESSION["fonctionsDispo"] && $_SESSION["fonctionsDispo"] != $version)))
		{
				$location = "{$this->settings["root"]}config/index.php?checkState=on";
				header("Location: $location");
				die("Version pas  jour. Veuillez cliquer sur <a href=\"$location\">$location</a>");
		}
		$_SESSION["version"] = $version;
// 		echo "Version: '$version'\n<br>VERSION: {$_SESSION["version"]}";
		
	}
	
	function getTemplates($force = False)
	{
		if(! $force && isset($_SESSION["templates"])) return;
		##Gestion des modles
		$tplPathPerso = $_SESSION["tplPath"] .$_SESSION["slash"].substr($_SESSION["db"], 0, 2);
		$tplPath = $_SESSION["tplPath"];
		$pMatch = "(^.*)\.([^.]+$)";
		
		$this->knownExts = array(
		"ott",
		"odt",
		"stw",
		"sxw",
		"rtf",
		"txt"
		);
		$files = array();
				
		$lPriority = count($this->knownExts);
		foreach(array($tplPath, $tplPathPerso) as $path)
		{
			if(!is_dir($path)) @mkdir($path);
			if(is_dir($path))
			{

				$dir = opendir($path);
				while($file = readdir($dir))
				{
					if(preg_match("#$pMatch#", $file, $reg))
					{
						$ext = $reg[2];
						$files[$file] = array_search($ext, $this->knownExts);
					}
				}

				asort ($files);
			}
		}
		$_SESSION["facture"] = "";
		$_SESSION["factures"] = "";
		$_SESSION["templates"] = "";
		$_SESSION["globalTemplates"] = "";
		foreach($files as $file =>$priority)
		{
			preg_match("#$pMatch#", $file, $reg);
			$ext = $reg[2];
			$priority = array_search($ext, $this->knownExts);			
			if($reg[1] == "facture" && $priority < $lPriority)
			{
				$_SESSION["facture"] = $file;
				$lPriority = $priority;
			}
			if($reg[1] == "facture") $_SESSION["factures"] .= "$file;";
			else $_SESSION["templates"] .= "$file;";
			$_SESSION["globalTemplates"] .= "$file;";
		}
	}
	
	function getOptions($arg = "")
	{
			
		if(!isset($_SESSION["optionsFile"]) || $arg === "force" ||$arg === "firstCheck" ||$arg === "forceNoer")
		{
			//Il faut dtruire toute la session, sauf les informations de connection et de version (qui ne doivent tre dtruites que si on le demande expressment: ce n'est pas une option mais une donne permanente)
			$user    = $_SESSION["user"];
			$pwd     = $_SESSION["pwd"];
			$db      = $_SESSION["db"];
			$version = $_SESSION["version"];
			$_SESSION = array();
			$_SESSION["user"]    = $user;
			$_SESSION["pwd"]     = $pwd;
			$_SESSION["db"]      = $db;
			$_SESSION["version"] = $version;

			//commenons par vrifier quel est le rpertoire de base du programme prolawyer
			$this->cur_dir=getcwd();
			while(!is_file("./root.php"))
			{
				chdir("..");
			}
			$this->prolawyerPath = getcwd();
			$_SESSION["softName"] = trim(file_get_contents("root.php"));
			chdir($this->cur_dir);
			
			$_SESSION["prolawyerPath"] = $this->prolawyerPath;

			/*options du programme*/
			
			//Variables particulires
			
			//D'abord vrifier si l'on est sous windows ou sous un *nix (linux, BSD, MacOS X) mais en simplifiant un peu
			if(is_dir(getenv("programfiles"))) // on semble tre sous windows
			{
				$slash = "\\";
				$optionsPath = getenv("programfiles")."\prolawyer";
				$autoOptionsPath = getenv("programfiles")."\prolawyer";
				if(!is_dir("$optionsPath") && !@mkdir("$optionsPath"))
				{
					$this->catchError("100-009#-#$optionsPath", 4);
				}
				else
				{
					//$this->catchError("100-011#-#$optionsPath", 0);
					$tempOptionsPath = "$optionsPath";
				}
			}
			
//			if(is_dir("/etc")) // on semble tre sous un *nix //Supprim au profit d'un "else", cf ligne suivante
			else // on semble tre sous un *nix. Ne pas traiter /etc permet d'utiliser la directive open_basedir place  /etc/prolawyer
			{
				$slash = "/";
				$optionsPath = "/etc/prolawyer";
				$autoOptionsPath = "/etc/prolawyer";
				require_once($this->settings["root"]."lang/fr.php");
				if(!is_dir("$optionsPath") && !@mkdir("$optionsPath"))
				{
					$this->catchError("100-009#-#$optionsPath", 4);
				}
				else
				{
					//$this->catchError("100-011#-#$optionsPath", 0);
					$tempOptionsPath = "$optionsPath";
				}
			}
			
			$_SESSION["slash"] = $slash;
			
			//A ce stade, on devrait avoir un rpertoire automatique. Si tel n'est pas le cas
			
			if(!isset($tempOptionsPath))
			{
				$testFile = "{$this->prolawyerPath}{$slash}system";
				if (is_file("{$this->prolawyerPath}{$slash}system") && file_get_contents("{$this->prolawyerPath}{$slash}system")) //en dsespoir de cause, on cherche  savoir si le nom du rpertoire a t insr manuellement
				{
					$optionsPath = file_get_contents("{$this->prolawyerPath}{$slash}system");
					if(!is_dir("$optionsPath") && !@mkdir("$optionsPath"))
					{
						$this->catchError("100-012#-#{$this->prolawyerPath}{$slash}system#$optionsPath", 4);
					}
					else
					{
						//$this->catchError("100-011#-#$optionsPath", 0);
						$tempOptionsPath = "$optionsPath";
					}
				}
				elseif (is_file("{$this->prolawyerPath}{$slash}system")) 
				{
					$sysUser = getenv("APACHE_RUN_USER");
					$sysUser = $sysUser ? " $sysUser":"";
					$this->catchError("100-013#-#$sysUser#{$this->prolawyerPath}{$slash}system#$autoOptionsPath", 4);
				}
				else
				{
					$sysUser = getenv("APACHE_RUN_USER");
					$sysUser = $sysUser ? " $sysUser":"";
					$this->catchError("100-014#-#{$this->prolawyerPath}{$slash}system#$sysUser#$autoOptionsPath", 4);
				}
			}
			
			
			if(isset($tempOptionsPath))
			{
				foreach($this->open_and_prepare("$tempOptionsPath{$slash}liste") as $liste)
				{
					list($aPath, $install) = preg_split("#,#", $liste);
					if($aPath == $this->prolawyerPath)
					{
						$_SESSION["optionsPath"] = $install;
						$_SESSION["optionsFile"] = "$install{$slash}settings";
					}
					//echo "<br>'$aPath' == '{$this->prolawyerPath}'";
				}
				if(!isset($_SESSION["optionsPath"]))
				{
					$tListe = $this->open_and_prepare("$tempOptionsPath{$slash}liste");
					$tListe = $this->wipe_array($tListe, $this->prolawyerPath);
					for($x=1;;$x++)
					{
						if(!is_dir("$tempOptionsPath{$slash}install$x") && !is_file("$tempOptionsPath{$slash}install$x"))
						{
							//echo "On tente de crer  $tempOptionsPath{$slash}install$x";
							if(@mkdir("$tempOptionsPath{$slash}install$x"))
							{
								if($this->close_and_write(array(), "$tempOptionsPath{$slash}install$x{$slash}settings"))
								{
									$_SESSION["optionsPath"] = "$tempOptionsPath{$slash}install$x";
									$_SESSION["optionsFile"] = "{$_SESSION["optionsPath"]}{$slash}settings";
									//echo "File: {$_SESSION["optionsFile"]}";
								}
								else
								{
									$sysUser = getenv("APACHE_RUN_USER");
									$sysUser = $sysUser ? " par $sysUser":"";
									$this->catchError("100-022#-#$tempOptionsPath{$slash}install$x{$slash}settings#$sysUser", 4);
								}
							}
							else
							{
								$sysUser = getenv("APACHE_RUN_USER");
								$sysUser = $sysUser ? " par $sysUser":"";
								$this->catchError("100-022#-#$tempOptionsPath{$slash}install$x#$tempOptionsPath#$sysUser", 4);
							}
							break;
						}
					}
					$tListe[] = "{$this->prolawyerPath},$tempOptionsPath{$slash}install$x";
					$this->close_and_write($tListe, "$tempOptionsPath{$slash}liste");
					if(!$_SESSION["optionsFile"]) $this->catchError("100-015#-#$tempOptionsPath{$slash}liste", 4);
				}
			}
			
			if(is_file($_SESSION["optionsFile"]))
			{
				#Rpertoire d'images
// 				$autoImagesPath = "{$_SESSION["optionsPath"]}{$slash}autoimages";
				$autoImagesPath = "{$_SESSION["prolawyerPath"]}{$slash}images{$slash}auto";
				if (! is_dir($autoImagesPath)) @mkdir($autoImagesPath);
				$_SESSION["autoImagesPath"] = $autoImagesPath;
				
				#Rpertoire de modles
				$tplPath = "{$_SESSION["optionsPath"]}{$slash}templates";
				if (! is_dir($tplPath)) @mkdir($tplPath);
				$_SESSION["tplPath"] = $tplPath;
				
				foreach($this->open_and_prepare($_SESSION["optionsFile"]) as $opt)
				{
					list($k, $v) = preg_split("#=#", $opt);
					if(preg_match("#\[\]$#", $k))
					{
						$k = preg_replace("#(.*)\[\]$#", "\\1", $k);
// 						echo "<br>voici $k";
						$_SESSION["$k"][] = $v;
					}
					else $_SESSION["$k"] = $v;
				}
			}
			
			
// 			echo "'$arg'" .$this->errSet;
			if($this->isError() && $arg == "firstCheck")
			{
				$location = "{$this->settings["root"]}config/index.php?checkState=on";
				header("Location: $location");
				die("mort (devrait renvoyer  $location");
			}
			if($arg != "forceNoer") echo $this->echoError();

		}
	}
	
	
	/*Fonction de gestion du document*/
	
	function unsetCookie($nom, $domain = "thisSoft")
	{
		$expire = time() - 3600;
		$this->setCookie($nom, "", $domain, $expire);
	}
	
	function setCookie($nom, $val, $domain="thisSoft", $expire="1year")
	{
		if($domain == "thisSoft")
		{
			if(!$this->settings["root"]) $this->getRelPath();
			if(!$_SESSION["softName"]) $_SESSION["softName"] = trim(file_get_contents("{$this->settings["root"]}root.php"));
			if (! $_SESSION["softName"]) $_SESSION["softName"] = "noName";
			$nom = "{$_SESSION["softName"]}_$nom";
		}
		if($expire == "1year") $expire = time() +31536000;
		setcookie($nom, $val, $expire);
		$_COOKIE["$nom"] = $val; //positionner le cookie ne sera autrement valable qu'au prochain chargement de la page
	}
	
	function getCookie($nom, $domain="thisSoft")
	{
		if($domain == "thisSoft")
		{
			if(!$this->settings["root"]) $this->getRelPath();
			if(!$_SESSION["softName"]) $_SESSION["softName"] = trim(file_get_contents("{$this->settings["root"]}root.php"));
			if (! $_SESSION["softName"]) $_SESSION["softName"] = "noName";
			$nom = "{$_SESSION["softName"]}_$nom";
		}
		if(isset($_COOKIE["$nom"])) return $_COOKIE["$nom"];
		else return false;
	}
	
	function getActLang($connection=true)
	{
		//Trane-t-on une ancienne option pas encore enregistre ?
		if($_SESSION["langue_choisie"]) $_GET["langue_choisie"] = $_SESSION["langue_choisie"];
		
		//1er cas: on vient de changer de langue, respectivement on a chang de langue  la page d'avant mais on n'a pas encore eu l'occasion de le noter
		if($_GET["langue_choisie"])
		{
			if($_SESSION["user"])
			{
				$this->setOptionPerso("lang", $_GET["langue_choisie"]);
				unset($_SESSION["langue_choisie"]);
				$_SESSION["lang"] = $_GET["langue_choisie"];
			}
			else
			{
				$_SESSION["langue_choisie"] = $_GET["langue_choisie"];
				$_SESSION["lang"] = $_GET["langue_choisie"];
			}
		}
		
		//2me cas: la langue de la session n'existe pas. Cela peut provenir de plusieurs raisons
		if(!$_SESSION["lang"])
		{
			if($_SESSION["user"] && $connection && $connection !== "firstCheck")
			{
				//2.1: on essaye d'aller rechercher la langue dans les options utilisateur
				if($this->getOptionsPerso("lang")) $_SESSION["lang"] = $this->getOptionsPerso("lang");
			}
			if(!$_SESSION["lang"] && $this->getCookie("lang"))
			{
				//2.2: on essaye de voir s'il existe un cookie qui pourrait tre utile
				$_SESSION["lang"] = $this->getCookie("lang");
			}
			if(!$_SESSION["lang"])
			{
				//2.3: en dsespoir de cause, il faut que la langue soit le franais
				$_SESSION["lang"] = "fr";
			}
		
		}
		if($_SESSION["lang"])
		{
			$this->setCookie("lang", $_SESSION["lang"]);
			$this->setOptionsPerso("lang", $_SESSION["lang"]);
		}
	
	}
	function getLangFile($rad = "", $force = false)
	{
		#Variables  dfinir dans les fichiers de langue
		$temp_nodossier=$_REQUEST["nodossier"];
		$temp_id=$_REQUEST["id"];
		$temp_utilisateur=$_SESSION["user"];
		$temp_avocat=$this->init_to_name($_SESSION["db"]);
		
		if(!isset($this->langFiles["{$rad}"]) && !$force)
		{
			require("{$this->settings["root"]}lang/{$rad}fr.php");
                        if($this->anchor == "modules_modules")
                        {
                                foreach(array($_SESSION["optionsPath"].$_SESSION["slash"], $this->settings["root"]) as $tDir)
                                {
                                        $file = "{$tDir}modules/auto/{$_POST["moduleName"]}.dat.php";
                                        if(is_file($file)) require_once($file);
                                }
                                if(is_array($lM["fr"])) foreach($lM["fr"]as $nom=>$val) $langchoisie["$nom"]=$val;
                        }

			foreach($langchoisie as $n => $l)
			{
				$this->lang["$n"] = $this->smart_html("*$l*");
				if(preg_match("#modifier_donnees_societe#", $n))
				{
					$x2 = preg_replace("#modifier_donnees_societe_#", "", $n);
					$this->societes["$x2"] = $this->lang["$n"];
				}
			}
			$this->langFiles["{$rad}"] = True;
			unset ($langchoisie);
		}
		if(($_SESSION["lang"]) && is_file($this->settings["root"]."lang/{$rad}{$_SESSION["lang"]}.php")) $aLng = $_SESSION["lang"]; //soit que la langue ne soit pas choisie, soit qu'elle soit dfinie comme vide, soit qu'elle soit dfinie de manire errone
		else $aLng = "fr";

		if(!isset($this->langFiles["{$rad}_$aLng"]) && !$force)
		{
			require($this->settings["root"]."lang/{$rad}$aLng.php");
                        if($this->anchor == "modules_modules") if(is_array($lM["{$_SESSION["lang"]}"])) foreach($lM["fr"]as $nom=>$val) $langchoisie["$nom"]=$val;

			foreach($langchoisie as $n => $l)
			{
				$this->lang["$n"] = $this->smart_html("$l");
				if(preg_match("#modifier_donnees_societe#", $n))
				{
					$x2 = preg_replace("#modifier_donnees_societe_#", "", $n);
					$this->societes["$x2"] = $this->lang["$n"];
				}
			}
			$this->langFiles["{$rad}_$aLng"] = True;
			unset ($langchoisie);
		}
	}
	
	function title($param=FALSE)
	{
		$this->title_variable=$this->anchor."_title";
		$this->html=TRUE;
		if(isset($this->title_variable)) $var=$this->title_variable;
		else $var="";
		if(isset($this->lang["$var"])) $this->title_name=$this->lang["$var"] . " - ";
		else $this->title_name="";
		echo "<html>";
		echo "\n	<head>";
		echo "\n		<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-15\">";
		echo "\n		<title>{$this->title_name} Prolawyer {$_SESSION["version"]}</title>";
		echo "\n		<div class=\"popup\" id=\"popbox\"></div>";
		echo "\n		<div class=\"popup\" id=\"neant\"></div>";
		echo "\n		<script language=\"javascript\">npA='{$this->lang["general_np"]}';mpA='{$this->lang["general_mp"]}';</script>";
		echo "\n		<script type=\"text/javascript\" src=\"{$this->settings["root"]}js/javascript.js\"></script>";
		if(is_array($this->titleAddons)) foreach($this->titleAddons as $addon) echo "\n		$addon";
		if($param) echo "\n		$param";
		echo "\n		<link rel=\"stylesheet\" href=\"{$_SESSION["stylesfile"]}\" type=\"text/css\">";
		echo "\n		<link rel=\"icon\" href=\"{$this->settings["root"]}images/prolawyer.png\" type=\"image/x-png\">";
		echo "\n	</head>\n";
	}

	function body($table=0, $onload="if(document.forms[0] && document.forms[0].name != 'Sereconnecter') document.forms[0].elements[0].focus()", $onclick="hidecondi()", $bgcolor="#ffffff", $text="#000000", $link="#0000ff", $vlink="#800080", $alink="#ff0000", $onunload="", $onclose="")
	{
		$this->wait_entete=FALSE;
		if($onunload) $onunload = "onunload=\"$onunload\"";
		if($onclose) $onclose = "onclose=\"$onclose\"";
		echo "\n<body onload=\"$onload\" onclick=\"$onclick\" bgcolor=\"$bgcolor\" text=\"$text\" link=\"$link\" vlink=\"$vlink\" alink=\"$alink\" $onunload $onclose>\n";
		if($this->anchor == "agenda") echo $this->self_reload();
		if($table) 
		{
			if($table == 1)
			{
				$this->table=TRUE;
				echo "\n\n<table align=\"center\" width=\"95%\"><tr><td>\n<//begining of centered text//>\n\n";
			}
			else $this->wait_entete=TRUE;
		}
	}
	
	function entete($echo=TRUE)
	{
		$this->debugNow("Debut de l'en-tte");
		$this->forward_test=true;
// 		return;
		$op_date_limit="";

		if($_POST["timestamp_debut"] AND $_POST["timestamp_fin"] AND ($_POST["secteur"]=="tva"))
		{
			$_POST["jour_debut"]=date("d", "{$_POST["timestamp_debut"]}");
			$_POST["mois_debut"]=date("m", "{$_POST["timestamp_debut"]}");
			$_POST["annee_debut"]=date("Y", "{$_POST["timestamp_debut"]}");
			$_POST["jour_fin"]=date("d", "{$_POST["timestamp_fin"]}");
			$_POST["mois_fin"]=date("m", "{$_POST["timestamp_fin"]}");
			$_POST["annee_fin"]=date("Y", "{$_POST["timestamp_fin"]}");
		}
		
		#PHP s'obstine dsormais  interdire d'obtenir le fuseau horaire du systme sans hurler que c'est dangereux. Alors on contourne...
		@$defaultTZ = date_default_timezone_get();
		date_default_timezone_set($defaultTZ);
		//dfinition des dates de recherche
		if(!isset($_POST["jour_debut"]) AND $this->anchor != "modifier_donnees" AND $this->anchor != "creer_dossier") $_POST["jour_debut"]=1;
		if(!isset($_POST["mois_debut"]) AND $this->anchor != "modifier_donnees" AND $this->anchor != "creer_dossier") $_POST["mois_debut"]=1;
		if(!isset($_POST["annee_debut"]) AND $this->anchor != "modifier_donnees" AND $this->anchor != "creer_dossier") $_POST["annee_debut"]=date("Y",time());
		if(!isset($_POST["jour_fin"]) AND $this->anchor != "modifier_donnees" AND $this->anchor != "creer_dossier") $_POST["jour_fin"]=date("d",time());
		if(!isset($_POST["mois_fin"]) AND $this->anchor != "modifier_donnees" AND $this->anchor != "creer_dossier") $_POST["mois_fin"]=date("m",time());
		if(!isset($_POST["annee_fin"]) AND $this->anchor != "modifier_donnees" AND $this->anchor != "creer_dossier") $_POST["annee_fin"]=date("Y",time());
//		$this->base_selecteur=$this->selecteur($_SESSION["session_utilisateur"], TRUE, FALSE, FALSE, $this->liste_personne, TRUE, $groups);
		$this->debugNow("Appel  selecteur");
		$toPost = array("jour_debut", "mois_debut", "annee_debut", "jour_fin", "mois_fin", "annee_fin", "date_cours", "type", "template", "secteur");
		foreach($toPost as $nVar) if($_POST["$nVar"])
		{
			$oPost .= $this->input_hidden($nVar, false, $_POST[$nVar]);
		}
 		$this->base_selecteur=$this->selecteur("liste_bases", "lire").$oPost;
 		$this->arch_selecteur=$this->selecteur("liste_archives", "lire").$oPost;
		$this->debugNow("Fin de l'appel  selecteur");
		$this->url="manuel/".$this->getCookie("lang")."/manuel.php#{$this->anchor}";
		$val_selecteur=(preg_match("#config#", $this->anchor))? $this->lang["entete_choisir_base"]: $this->lang["entete_base_en_cours"];
				
		if($_POST["print"]!="on"){ //c'est l'essentiel de la fonction, soit la barre d'outil ou d'en-tte,  choix
		
			$this->debugNow("Debut des menus");
			//on triche avec la langue pour avoir momentanment une valeur avec espaces protgs
			$this->temp_lang=$this->lang;
			foreach($this->lang as $nom => $val) $this->lang["$nom"] = preg_replace("# #", "&nbsp;", $val);
		
			$this->menuitem=array();
			$this->menusubitem=array();
			$this->menusubsubitem=array();
			$this->listitem=array();

			$this->menuitem[1]="<table width=100% border=0 cellspacing=0 cellpadding=0  class=\"menu\" id=\"specidfirst\"><tr><td width=26><img src=\"{$this->settings["root"]}images/prolawyer.png\" height=\"24\" width=\"24\"></td><td>{$this->lang["entete_general"]}</td></tr></table>";
			$this->menuitem[2]=$this->lang["entete_dossier"];
			$this->menuitem[3]=$this->lang["entete_affichage"];
			$this->menuitem[4]=$this->lang["entete_adresses"];
			$this->menuitem[5]=$this->lang["entete_agenda"];
			$this->menuitem[6]=$this->lang["entete_biblio"];
			$this->menuitem[7]=$this->lang["modifier_donnees_mail"];
			$this->menuitem[8]="Comptabilit&eacute;";
			$this->menuitem[99]=$this->lang["entete_modules"];
			$this->menuitem[100]=$this->lang["entete_help"]."&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
			
			$this->menusubitem[1][]="<pda>".$this->form("index.php<td>", $this->lang["entete_reconnect"], $this->lang["entete_reconnect_accesskey"], "menu", "");
			$this->menusubitem[1][]="<form action=\"".$this->settings["root"]."{$this->next_select}.php\" method=\"post\" name=\"selecteur\"><td><input type=hidden name=next_values value=\"{$this->next_values}\"><table align=left cellspacing=0 cellpadding=0 class=menu><tr><td>".$this->button("$val_selecteur", "", "menu")."</td><td class=menu><select name=new_av onChange=\"document.selecteur.submit()\" class=menu>{$this->base_selecteur}</select>&nbsp;</td></tr></table></td></form>";
			$this->menusubitem[1][]="<form action=\"".$this->settings["root"]."{$this->next_select}.php\" method=\"post\" name=\"selecteurArchive\"><td><input type=hidden name=next_values value=\"{$this->next_values}\"><table align=left cellspacing=0 cellpadding=0 class=menu><tr><td>".$this->button($this->lang["config_modify_archives"], "", "menu")."</td><td class=menu><select name=new_av onChange=\"document.selecteurArchive.submit()\" class=menu>{$this->arch_selecteur}</select>&nbsp;</td></tr></table></td></form>";
			$this->menusubitem[1][]="<hr>";
			$this->menusubitem[1][]=($this->testval("admin"))? $this->form("config/config.php", $this->lang["entete_settings_gen"], $this->lang["entete_settings_accesskey"], "administration", "", "check_config", "on"):NULL;
// 			$this->menusubitem[1][]=$this->form("config/config.php<td>", $this->lang["entete_settings"], , "administration");
			$this->menusubitem[1][]=$this->testval("ecrire") ?$this->form("config/modify_perso.php<td>", $this->lang["config_modify_options_base"], "", "administration"):"";
			$this->menusubitem[1][]=$this->form("config/modify_options_perso.php<td>", $this->lang["config_modify_options_perso"], "", "administration");
			$this->menusubitem[1][]=($this->right=='admin')? $this->form("config/manage_config.php<td>", $this->lang["config_modify_sauve_config"], "", "administration"): NULL;
			$this->menusubitem[1][]=($this->right=='admin')? $this->form("config/manage_base.php<td>", $this->lang["config_modify_sauve_base"], "", "administration"): NULL;
			$this->menusubitem[1][]=$this->form("config/styles.php<td>", $this->lang["config_modify_styles"], "", "administration");
			$this->menusubitem[1][]=$this->form("config/templates.php<td>", $this->lang["config_templates_title"], "", "administration");
			$this->menusubitem[1][]="<hr>";
			$this->menusubitem[1][]=$this->form("developpement/index.php<td>", $this->lang["entete_developpement"], "", "menu");
			
			$this->menusubitem[2][]=(($_POST["secteur"]=="operations" OR $_POST["secteur"]=="encaissements") AND !$this->testval("ecrire") AND $this->testval("lire")) ? $this->form("./modifier_donnees.php<td>", $this->lang["entete_consulter"], $this->lang["entete_modifier_accesskey"], "menu", "Modifierledossier<td>", "nodossier", "{$_POST["nodossier"]}"): NULL;
			$this->menusubitem[2][]=(($_POST["secteur"]=="operations" OR $_POST["secteur"]=="encaissements") AND $this->testval("ecrire")) ? $this->form("./modifier_donnees.php<td>", $this->lang["entete_modifier"], $this->lang["entete_modifier_accesskey"], "menu", "", "nodossier", "{$_POST["nodossier"]}"): NULL;
			$this->menusubitem[2][]=(($_POST["secteur"]=="encaissements" OR $this->anchor=="modifier_donnees") AND $this->testval("lire"))? "<pda>".$this->form("operations.php<td>", $this->lang["operations_operations"], $this->lang["operations_operations_accesskey"], "menu", "", "nodossier", $_POST["nodossier"], "secteur", "operations"): NULL;
			$this->menusubitem[2][]=(($_POST["secteur"]=="operations" OR $this->anchor=="modifier_donnees") AND $this->testval("lire"))? "<pda>".$this->form("operations.php<td>", $this->lang["operations_encaissements"], $this->lang["operations_encaissements_accesskey"], "menu", "", "nodossier", $_POST["nodossier"], "secteur", "encaissements"): NULL;
			$this->menusubitem[2][]=(($_POST["secteur"]=="operations" OR $_POST["secteur"]=="encaissements" OR $this->anchor=="modifier_donnees") AND $this->testval("ecrire"))? $this->form("maj_op.php<td>", $this->lang["entete_trash"], $this->lang["entete_trash_accesskey"], "attentionmenu", "", "nodossier", $_REQUEST["nodossier"], "retour", $this->lang["anchor"], "action", "delete_file"): NULL;
			$this->menusubitem[2][]=(($_POST["secteur"]=="operations" OR $_POST["secteur"]=="encaissements" OR $this->anchor=="modifier_donnees") AND $this->testval("ecrire"))? $this->form("facture.php<td>", $this->lang["operations_facture"], "", "menu", "", "nodossier", $_POST["nodossier"], "session_utilisateur", "{$_SESSION["session_utilisateur"]}", "db", "{$_SESSION["db"]}", "fichier", $_SESSION["facture"]): NULL;
			$this->menusubitem[2][]=(($_POST["secteur"]=="operations" OR $_POST["secteur"]=="encaissements" OR $this->anchor=="modifier_donnees") AND $this->testval("ecrire") AND $_SESSION["templates"])? "<button class=\"menu\">{$this->lang["operations_autres_documents"]}</a>": NULL;
			$temps = preg_split("';'", $_SESSION["templates"]);
			foreach($temps as $temp) if($temp) $this->addSub($this->form("facture.php<td>", $temp, "", "menu", "aaa", "nodossier", $_POST["nodossier"], "session_utilisateur", "{$_SESSION["session_utilisateur"]}", "db", "{$_SESSION["db"]}", "fichier", $temp));
			
			$this->menusubitem[2][]=(($_POST["secteur"]=="operations" OR $_POST["secteur"]=="encaissements" OR $this->anchor=="modifier_donnees") AND $this->testval("lire"))? "<button class=\"menu\" onclick=\"window.open('{$this->settings["root"]}liste_soldes.php?clientReq={$_POST["nodossier"]}','modifier','width=600,height=600,toolbar=no,directories=no,menubar=no,location=no,status=no')\">{$this->lang["multi_clients_title"]}</button>": NULL;
			$this->menusubitem[2][]=($this->testval("lire") && $_POST["secteur"])?"<hr>":"";
			$this->menusubitem[2][]=($this->testval("lire"))? "<pda>".$this->form("recherche_dossier.php<td>__liste__", $this->lang["entete_search"], $this->lang["entete_search_accesskey"], "menu"):NULL;
			$this->menusubitem[2][]=($this->testval("ecrire") AND !preg_match("#config#", $this->anchor))? $this->form("creer_dossier.php<td>", $this->lang["entete_new"], $this->lang["entete_new_accesskey"], "menu"): NULL;
			$this->menusubitem[2][]=($this->testval("ecrire") AND !preg_match("#config#", $this->anchor))? $this->form("creer_dossier.php<td>", $this->lang["creer_client_conflits"], "", "menu", "", "cherche_conflits", "on"): NULL;
			//$this->menusubitem[2][]=($_POST["secteur"]=="operations" OR $_POST["secteur"]=="encaissements") ? $this->form("operations.php<td>", $this->lang["operations_group_modif", $this->lang["operations_group_modif_accesskey", "menu", "", "nodossier", $_POST["nodossier"], "secteur", $_POST["secteur"], "group_modif", "on"): NULL;
			$this->menusubitem[2][]=(($_POST["secteur"]=="operations" OR $_POST["secteur"]=="encaissements" OR $this->anchor=="modifier_donnees") AND $this->testval("ecrire"))? $this->form("nouvelle_affaire.php<td>", $this->lang["entete_new_file"], "", "menu", "", "nodossier", $_POST["nodossier"], "session_utilisateur", "{$_SESSION["session_utilisateur"]}", "db", "{$_SESSION["db"]}"): NULL;
			
			$this->menusubitem[3][]=(!preg_match("#config#", $this->anchor) AND $this->testval("journal"))? "<pda>".$this->form($root."operations.php<td>", $this->lang["entete_journal"], $this->lang["entete_journal_accesskey"], "menu", "", "secteur", "journal"): NULL;
			$this->menusubitem[3][]=(!preg_match("#config#", $this->anchor) AND $this->testval("journal"))? "<pda>".$this->form($root."operations.php<td>", $this->lang["entete_journal_op"], $this->lang["entete_journal_op_accesskey"], "menu", "", "secteur", "journal_op"): NULL;
// 			$this->menusubitem[3][]=(!preg_match("#config#", $this->anchor) AND $this->testval("tva"))? "<pda>".$this->form($root."operations.php<td>", $this->lang["entete_journal_op_st"], "", "menu", "", "secteur", "journal_op", "ts", "on"): NULL;
			$this->menusubitem[3][]=($this->testval("lire"))? "<pda>".$this->form("liste_soldes.php<td>", $this->lang["entete_liste_soldes"], $this->lang["entete_liste_soldes_accesskey"], "menu"): NULL;
			$this->menusubitem[3][]=(!preg_match("#config#", $this->anchor) AND $this->testval("tva"))? "<hr>": NULL;
			$this->menusubitem[3][]=($this->testval("tva"))? $this->form("ra.php<td>", $this->lang["ra_link"], $this->lang["ra_link_accesskey"], "menu", "", "soustraitance", "on"): NULL;
			$this->menusubitem[3][]=($this->testval("tva"))? $this->form("ra_new.php<td>", $this->lang["ra_stats"], "", "menu"): NULL;
			$this->menusubitem[3][]=($this->testval("tva"))? "<pda>".$this->form("operations.php<td>", $this->lang["entete_ca"], $this->lang["entete_ca_accesskey"], "menu", "", "secteur", "tva"): NULL;
			$this->menusubitem[3][]=($this->testval("lire"))? "<pda>".$this->form("ra.php<td>", $this->lang["entete_activite_sstraitant"], "", "menu", "", "remuneration", "on"): NULL;
			$this->menusubitem[3][]="<hr>";
			$this->menusubitem[3][]="<button onclick=\"pleinEcran()\" class=\"menu\">{$this->lang["entete_plein_ecran"]}</button>";
			
			$this->menusubitem[4][]=($this->testval("lire"))? "<pda>".$this->form("adresses/index.php<td>__liste__", $this->lang["entete_adresses"], $this->lang["entete_adresses_accesskey"], "menu"): NULL;
			$this->menusubitem[4][]=($this->testval("ecrire"))? $this->form("adresses/modifier.php<td>", $this->lang["adresses_resultat_nouvelle_fiche"], "", "menu", "", "nouveau", "on"): NULL;
			$this->menusubitem[4][]=($this->testval("ecrire") && $this->anchor == "adresses_modifier")? $this->form("adresses/resultat.php<td>", "{$this->lang["adresses_resultat_supprimer"]}", "", "attentionmenu", "", "id", $_POST["id"], "action", "delete", "nom", $_POST["nom"]):NULL;
/*			$maj_agenda = ($_POST["template"] == "agenda" && $_POST["type"] != "vacances") ? "true":"false";
			$maj_dl = ($_POST["template"] == "delais") ? "true":"false";*/
			$this->menusubitem[5][]=($this->testval("lire"))? "<pda>".$this->form("agenda.php#today<td>__liste__", $this->lang["entete_agenda"], $this->lang["entete_agenda_accesskey"], "menu", "", "template", "agenda"): NULL;
			$this->menusubitem[5][]=($this->testval("lire"))? "<pda>".$this->form("agendanew.php#today<td>__liste__", $this->lang["entete_agendanew"], $this->lang["entete_agendanew_accesskey"], "menu", "", "template", "agenda"): NULL;
			$this->menusubitem[5][]=($this->testval("lire"))? "<pda>".$this->form("agenda.php<td>__liste__", $this->lang["agenda_vacances_planning"], "", "menu", "", "template", "agenda", "type", "vacances"): NULL;
			$this->menusubitem[5][]=($this->testval("lire"))? $this->form("agenda.php<td>", $this->lang["entete_delais"], "", "menu", "", "template", "delais"): NULL;
			$this->menusubitem[5][]=($this->testval("ecrire"))? "<button class=\"menu\" onclick=\"window.open('{$this->settings["root"]}modifier_rdv.php?alea={$this->alea}&get=TRUE&nouveau=on&date_cours=$nouvelle_date_cours&personne=$personne&maj=$maj_agenda','modifier','width=400,height=400,toolbar=no,directories=no,menubar=no,location=no,status=no')\">{$this->lang["agenda_nouveau_rdv"]}</button>": NULL;
			$this->menusubitem[5][]=($this->testval("ecrire"))? "<button class=\"menu\" onclick=\"window.open('{$this->settings["root"]}modifier_delai.php?alea={$this->alea}&get=TRUE&nouveau=on&date_cours=$nouvelle_date_cours&personne=$personne&maj=$maj_dl','modifier','width=400,height=400,toolbar=no,directories=no,menubar=no=no,location=no,status=no')\">{$this->lang["agenda_nouveau_dl"]}</button>": NULL;
			$this->menusubitem[5][]=($this->testval("ecrire"))?$this->form("synchronisation/synchro.php", "synch", "", "attentionmenu", ""):"";
			$this->menusubitem[5][]=($this->testval("lire"))? "<pda>".$this->form("agendanew.php#today<td>__liste__", "test", "", "menu", "", "template", "agenda"): NULL;
// 			$this->menusubitem[5][]=($this->testval("ecrire"))? $this->form("modifier_delai.php<td>", $this->lang["agenda_nouveau_dl"], "", "menu", "", "nouveau", "on", "rdv_pour", "$next_rdv_pour"): NULL;
// 			$this->menusubitem[5][]=($this->testval("ecrire"))? $this->form("modifier_rdv.php<td>", $this->lang["agenda_nouveau_rdv"], "", "menu", "", "nouveau", "on"): NULL;
// 			$this->menusubitem[5][]=($this->testval("ecrire"))? $this->form("modifier_delai.php<td>", $this->lang["agenda_nouveau_dl"], "", "menu", "", "nouveau", "on", "rdv_pour", "$next_rdv_pour"): NULL;


			$this->biblios = explode("\n", $_SESSION["optionGen"]["bibliotheques"]);
			foreach($this->biblios as $biblio) if(trim($biblio) != "")
			{
				list($nom, $type) = preg_split("/,/", $biblio);
				$this->menusubitem[6][]=($this->testval("lire"))? $this->form("biblio/liste_ouvrages.php<td>", $nom, "", "menu", "", "settype", $type, "setnom", $nom): NULL;
			}
			$this->menusubitem[6][] = "<hr>";
// 			$this->tab_affiche(2);
			if(isset($_SESSION["biblioType"]) && isset($_SESSION["biblioNom"]))
			{
				$this->menusubitem[6][]=($this->testval("lire"))? $this->form("biblio/recherche_livre.php<td>", $this->lang["recherche_dossier_recherche"], "", "menu", ""):"";
				$this->menusubitem[6][]=($this->testval("lire"))? $this->form("biblio/liste_ouvrages.php<td>", $this->lang["biblio_prets"], "", "menu", "", "prete", "on"):"";
				$this->menusubitem[6][]=($this->testval("lire"))? $this->form("biblio/liste_ouvrages.php<td>", $this->lang["biblio_liste_status1"], "", "menu", "", "status", "1"):"";
				$this->menusubitem[6][]=($this->testval("lire"))? $this->form("biblio/liste_ouvrages.php<td>", $this->lang["biblio_liste_status2"], "", "menu", "", "status", "2"):"";
				$this->menusubitem[6][]=($this->testval("lire"))? $this->form("biblio/liste_ouvrages.php<td>", $this->lang["biblio_liste_status3"], "", "menu", "", "status", "3"):"";
				$this->menusubitem[6][]=($this->testval("lire"))? $this->form("biblio/creer_livre.php<td>", $this->lang["biblio_nouveau"], "", "menu", "", "action", "create"):"";
				$this->menusubitem[6][]=($this->testval("lire") && $_SESSION["biblioType"] == "1")? $this->form("biblio/nouveautes.php<td>", $this->lang["biblio_nouveautes"], "", "menu", ""):"";
			}
			
			
			$this->menusubitem[7][]=($this->testval("lire"))? "<pda>".$this->form("imap/courriel.php<td>", $this->lang["modifier_donnees_mail"], "", "menu"): NULL;
			$this->menusubitem[7][]=($this->testval("lire"))? "<button class=menu onclick=\"javascript:window.open('{$this->settings["root"]}imap/compose.php', 'compose', 'toolbar=no,directories=no,menubar=no=no,statusbar=no,toolbar=no,titlebar=no,scrollbars=yes')\">{$this->lang["imap_courriel_nouveau_message"]}</button>": NULL;


			$this->menusubitem[8][]=(1)? $this->form("comptes.php<td>", "comptes", "", "menu"): NULL;
			$this->menusubitem[8][]=(1)? $this->form("compta.php<td>", "compta", "", "menu"): NULL;

			$this->menusubitem[99][]=$this->form("modules/delais.php<td>", $this->lang["modules_calcul_delais"], "", "menu", "", "delaisName", "ch_generique");
			//inclusion des modules automatiques
			$actDir=getcwd();
			foreach(array($_SESSION["optionsPath"].$_SESSION["slash"],$this->settings["root"]) as $path) 
			{
				$tDir = "{$path}modules{$_SESSION["slash"]}auto";
                                if(is_dir($tDir))
				{
                                        $dir=opendir($tDir);
					
					$aL=$_SESSION["lang"];
					while($file=readdir($dir))
					{
						if(substr($file, -8) == ".dat.php")
						{
							$level=false;
							require("$tDir/$file");
							$radical=basename($file, ".dat.php");
							if(isset($modules["$radical"]["$aL"])) $var=$modules["$radical"]["$aL"];
							else $var="*{$modules["$radical"]["fr"]}*";
		
							$this->menusubitem[99][]=($this->level == false || $this->testval("$level"))?$this->form("modules/modules.php<td>", $var, "", "menu", "", "moduleName", "$radical"):NULL;
						}
					}
				}
			}
			
			$this->menusubitem[100][]= $this->form("{$this->url}<td>", $this->lang["entete_help"], $this->lang["entete_help_accesskey"], "menu", "help");
			$this->menusubitem[100][]= $this->form("http://bugs.prolawyer.ch<td>", $this->lang["apropos_bug"], "", "menu", "bug");
			$this->menusubitem[100][]= $this->form("http://suggestions.prolawyer.ch<td>", $this->lang["apropos_fonctionnalite"], "", "menu", "fonction");
			$this->menusubitem[100][]= "<button class=menu onclick=\"javascript:window.open('{$this->settings["root"]}todo.php', 'todo', 'toolbar=no,directories=no,menubar=no=no,statusbar=no,toolbar=no,titlebar=no,scrollbars=yes')\">TODO</button>";
			$this->menusubitem[100][]= "<hr>";
			$this->menusubitem[100][]= $this->form("update.php<td>", $this->lang["entete_maj"],"", "menu", "");
			$this->menusubitem[100][]= "<hr>";
			$this->menusubitem[100][]= "<button class=menu onclick=\"javascript:window.open('{$this->settings["root"]}apropos.php', 'apropos', 'toolbar=no,directories=no,menubar=no=no,statusbar=no,toolbar=no,titlebar=no,scrollbars=yes')\">{$this->lang["entete_apropos"]}</button>";
			
			$this->lang = $this->temp_lang;
			$this->debugNow("Fin des menus - dbut de la crationdu menu");
			if($echo) $this->create_menu($echo);
			else $return = $this->create_menu($echo);
			$this->debugNow("Fin de la cration");
			if($this->wait_entete == TRUE)
			{
				$this->table=TRUE;
				if($echo) echo "\n\n<table align=\"center\" width=\"95%\"><tr><td>\n<//begining of centered text//>\n\n";
				else $return .= "\n\n<table align=\"center\" width=\"95%\"><tr><td>\n<//begining of centered text//>\n\n";
			}
			$this->debugNow("Fin de l'en-tte");
			return $return;
		}
		
// 		echo "<p id=plagetest>hello</p>";
		unset($this->forward_test);
	}

	function addSub($action, $condition = True)
	{
		if($condition)
		{
			$a = count($this->menusubitem);
			$b = count($this->menusubitem[$a]) -1;
			if($this->menusubitem[$a][$b]) $this->menusubsubitem[$a][$b][] = $action;
		}
	}

	function create_menu($echo)
	{
		if(isset($_SESSION["module"]))
		{
			if($_SESSION["module"] == "agenda") $this->module_number=5;
// 			echo "this->module_number vaut ", $this->module_number, " et session_module vaut '{$_SESSION["module"]}'";
			
			$this->toparse = $this->menusubitem[$this->module_number];
		}
		
		//suppression des valeurs nulles et gestion de la version pda
		$this->pda_array=array();
		foreach($this->menusubitem as $a =>$b) foreach($this->menusubitem[$a] as $c => $d)
		{
	/*			if(preg_match("#__liste__#", $d))
			{
				list($val, $nom) = preg_split("#__liste__#", $d);
// 				echo "<br> val vaut '$val'";
				if(substr($val, 0, 5) == "<pda>") $val = substr($val, 5);
				$this->listitem[$nom]=rawurlencode($val);
				$this->menusubitem[$a][$c] = preg_replace("#__liste__#", "", $d);
			}*/
			$idok=FALSE;
			$butid="button".$a."_".$c;
			$provisoire=preg_replace("#  #", " ", $this->menusubitem[$a][$c]);
/*			$provisoire=preg_replace("# \"#", "\"", $provisoire);
			$provisoire=preg_replace("#class =\"#", "class=\"", $provisoire);*/
			if(preg_match("#class=#", $provisoire))
			{
				$offset=strpos($provisoire, "class=") + 6;
				$substring=substr($provisoire, $offset);
				$newoffset=strpos($substring, " ");
				if(!$newoffset) $newoffset = strlen($substring);
				$tempclass=substr($substring, 0, $newoffset);
				$lastoffset=strpos($tempclass, ">");
				if(preg_match("#>#", $tempclass)) $tempclass=substr($tempclass, 0, $lastoffset);
				$tempclass=preg_replace("#\"#", "", $tempclass); 
				$tempclass=preg_replace("#=#", "", $tempclass); 
				$menuclasses[$a][$c] = $tempclass;
			}
			if(preg_match("#<button#", $this->menusubitem[$a][$c]))
			{
				$this->menusubitem[$a][$c] = preg_replace("#<button#", "<button id=\"$butid\"", $this->menusubitem[$a][$c]);
				$idok = TRUE;
			}
			if(preg_match("#<a href#", $this->menusubitem[$a][$c]) && $idok == FALSE)
			{
				$this->menusubitem[$a][$c] = preg_replace("#<a href#", "<a id=\"$butid\" href", $this->menusubitem[$a][$c]);
				$butid = TRUE;
			}
			if(substr($this->menusubitem[$a][$c], 0, 2) == "<p" && substr($this->menusubitem[$a][$c], 0, 5) != "<pda>" && $idok == FALSE) $this->menusubitem[$a][$c] = preg_replace("#<p#", "<p id=\"$butid\"", $this->menusubitem[$a][$c]);
			
			
			if(substr($this->menusubitem[$a][$c], 0, 5) == "<pda>")
			{
				$this->menusubitem[$a][$c] = substr($this->menusubitem[$a][$c], 5);
				$this->pda_array[]=$this->menusubitem[$a][$c];
			}
			if($this->menusubitem[$a][$c]==NULL) unset ($this->menusubitem[$a][$c]);
		}
		foreach($this->menusubitem as $a => $b) if($this->menusubitem[$a] == NULL) unset ($this->menusubitem[$a]);
		
		//tri des valeurs
		foreach($this->menuitem as $a => $b) if(is_array($this->menusubitem[$a])) ksort ($this->menusubitem[$a]);
		ksort ($this->menusubsubitem);
		
		//cration de la barre principale
		if(!$this->menu) $return = "\n<//begining of taskbar//>\n";
		if($this->menu)
		{
			$return .= "\n<select name=\"next\" id=\"next\">";
			if($_GET["erreur"] == "rate2")
			{
				$return .= "\n<option value=\"main_form\" selected>{$this->lang["index_restaure"]}</option>";
				$return .= "\n<option value=\"\">------------</option>";
			}
			if(is_array($this->arr_forms)) foreach ($this->arr_forms as $num=>$val)
			{
				
				$return .= "\n<option value=\"formulaire_$num\">{$this->arr_forms[$num][nom]}</option>";
			}
		}
		elseif($_SESSION["module"])
		{
			$compteur=0;
			$return .= "\n<table width=100% border=0 cellspacing=0 cellpadding=0>\n\t<tr class=menu>";
			array_unshift($this->menusubitem[$this->module_number], $this->menusubitem[1][0]);
			foreach ($this->menusubitem[$this->module_number] as $num=>$val)
			{	
				if($val != "<hr>")
				{
					$compteur ++;
					if($compteur == 4)
					{
						$compteur = 1;
						$return .= "</tr>\n\t<tr class=menu>";
					}
					if(!preg_match("#<td#", $val)) $val="<td>$val</td>";
					$return .= $val;
				}
			}
			for($x=0;$x<(3-$compteur);$x ++) $return .= "\n\t\t<td>&nbsp;</td>";
			$return .= "\n</tr></table>";
		}
		elseif($this->getCookie("pda") == "on")
		{
			$compteur=0;
			$return .= "\n<table width=100% border=0 cellspacing=0 cellpadding=0>\n\t<tr class=menu>";
			foreach ($this->pda_array as $val)
			{
				$compteur ++;
				if($compteur == 5)
				{
					$compteur = 1;
					$return .= "</tr>\n\t<tr class=menu>";
				}
				$return .= $val;
			}
			for($x=0;$x<(4-$compteur);$x ++) $return .= "\n\t\t<td>&nbsp;</td>";
			$return .= "\n</tr></table>";
		}else{
			$return .= "<table width=100% border=0 cellspacing=0 cellpadding=0>\n\t<tr class=menu>";
			foreach ($this->menuitem as $a => $b)
			{
// 				$return .= "<br> actuellement, je m'ocupe du menuitem[$a] qui vaut '$b'";
				if(is_array($this->menusubitem[$a]))
				{
					$complin = (preg_match("#specidfirst#", $b))? ";getElementById('specidfirst').className='bordurefirst'":"";
					$complout = (preg_match("#specidfirst#", $b))? ";getElementById('specidfirst').className='menu'":"";
					$menuid="menu".$a;
					$return .= "\n\t\t<td class=\"menu\" id=\"$menuid\" onclick=\"javascript:showmenu('submenu.$a')$complin\" onmouseover=\"javascript:showcondi('submenu.$a');getElementById('$menuid').className='bordurefirst'$complin;hidesubitem()\" onmouseout=\"getElementById('$menuid').className='menu'$complout\">$b</td>";
				}
			}
			$return .= "\n\t</tr>
			\n\t<tr class=bg>";
			
			//cration des menus droulants dans la deuxime ligne de la table principale
//			$first="colspan=\"2\"";
			foreach ($this->menuitem as $a => $b) 
			{
				if(is_array($this->menusubitem[$a])) 
				{
					$return .= "\n\t\t<td $first><span class=\"popupitem\" id=\"submenu.$a\"><table class=special_border border=1 cellspacing=0 cellpadding=0><tr><td><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">";
					$first="";
					
					//s'ils existent, cration des sous-menus
					foreach($this->menusubitem[$a] as $c=>$d)
					{
						$click	= "";
						$subsub	= "";
						$subid	= "";
						
						//s'ils existent, cration des sous-sous-menus (latraux)
						if(is_array($this->menusubsubitem["$a"]["$c"]))
						{
							$subid = "sub{$a}_{$c}";
							foreach($this->menusubsubitem["$a"]["$c"] as $n=> $lastitem)
							{
								$subidL = $subid."_$n";
								$subidB = "button".$subid."_$n";
								if(preg_match("#<form#i", $lastitem))
								{
									$lastitem = preg_replace("#<button#i", "\\0 id=\"$subidL\"", $lastitem);
									$specId	= "";
								}
								else
								{
									$on = "";
									$specId	= "id=\"$subidL\"";
								}
								if(!$subsub) $subsub = "<table id=\"$subid\" class=\"submenu\" style=\"border-top:1px;border-left:1px;border-color:a0a0a0;border-style:solid\">";
								$subsub .= "<tr $specId onmouseover=\"getElementById('$subidL').className='bordurefirst'\" onmouseout=\"getElementById('$subidL').className='menu'\"><td>$lastitem</td></tr>";
							}
							if($subid)
							{
								$subsub .= "</table>";
								$click = "getElementById('$subid').style.visibility='visible';subitem='$subid'";
							}
						}
							/*$return .= "</td>\n\t</tr>";*/
						if(isset($access_letter)) unset($access_letter);
						if(isset($access_schema)) unset($access_schema);
						if(preg_match("#accesskey#", $d)) 
						{
							$access_string=preg_replace("#accesskey=\"#", "accesskey=", $d);
							$access_string=strstr("$access_string", "accesskey=");
							$access_string=preg_replace("#accesskey=#", "", $access_string);
							$access_letter=substr($access_string, 0, 1);
							$access_letter=strtoupper($access_letter);
							if(preg_match("#konqueror#", strtolower("{$_SERVER["HTTP_USER_AGENT"]}"))) $access_schema="&nbsp;Ctrl,&nbsp;";
							elseif(preg_match("#opera#", strtolower("{$_SERVER["HTTP_USER_AGENT"]}"))) $access_schema="&nbsp;Esc,&nbsp;Shift&nbsp;+&nbsp;";
							else $access_schema="&nbsp;Alt&nbsp;+&nbsp;";
							if($access_letter) $access_schema .= $access_letter;
							if(preg_match("#msie#", strtolower("{$_SERVER["HTTP_USER_AGENT"]}"))) $access_schema.=",&nbsp;[Enter]";
						}
						$tdStyle = "";
						if(is_array($this->menusubsubitem["$a"]["$c"]))
						{
							$access_schema = " ->";
							$tdStyle = "align=right";
						}
						$butid="button{$a}_{$c}";
						$linid="line{$a}_{$c}";
						if(preg_match("#id=\"#", $this->menusubitem["$a"]["$c"])) $actions="onmouseover=\"getElementById('$butid').className='bordure';getElementById('$linid').className='bordurefirst';hidesubitem();$click\" onmouseout=\"getElementById('$butid').className='{$menuclasses["$a"]["$c"]}';getElementById('$linid').className='{$menuclasses["$a"]["$c"]}'\"";
						else $actions = "onmouseover=\"hidesubitem();$click\""; 
						if(! preg_match("#</td></form>#", $d) && ! preg_match("#</form></td>#", $d)) $this->menusubitem["$a"]["$c"] = "<td>{$this->menusubitem["$a"]["$c"]}</td>";
						$return .= "\n<tr id=\"$linid\" class=\"menu\" $actions>{$this->menusubitem["$a"]["$c"]}<td $tdStyle>$access_schema</td><td>&nbsp;</td><td style=\"vertical-align:top\"><span class=\"substyle\" style=\"\">$subsub</span></td></tr>";
					}
					$return .= "</table></td></tr></table></span>&nbsp;</td>";
				}
			}
			
			$return .= "</tr></table>";
		}
		if(!$this->menu) $return .= "\n<//end of taskbar//>\n";
		if ($echo) echo $return;
		return $return;
// 		echo "<button onclick=javascript:alert(ouvert)>test</button>";
	}
	
	function self_reload()
	{
		$return = "<form method=\"post\" action=\"{$_SERVER["PHP_SELF"]}\" name=\"self_reload\" id=\"self_reload\">";
		foreach($_POST as $nom => $val) $return .= $this->input_hidden($nom, 1);
		$return .= "</form>";
		return $return;
	}
	
	function footer($forceDebut="notSet", $forceStop="notSet")
	{
		$this->form_global_var = $_REQUEST;
		global $debut_mysql;
		global $stop_mysql;
		if($forceDebut != "notSet") $debut_mysql = $forceDebut;
		if($forceStop  != "notSet") $stop_mysql  = $forceStop;
		
		$sous_traitant_limite = $_POST["sous_traitant_limite"];
		echo "\n<//gestion des enregistrements sur plusieurs pages//>";
		echo "\n<table width=\"100%\" align=center border=\"0\">"; 
		
		if($_POST["group_modif"] != "on" AND $_POST["print"] != "on" AND $this->anchor != "adresses_resultat" AND $this->anchor != "resultat_recherche")
		{
			//impression
			echo "\n<tr><td colspan=5>";
// 			echo $this->form("operations", "{$this->lang["pied_impression"]}", "", "", "", "secteur", $_POST["secteur"], "nodossier", $_POST["nodossier"], "timestamp_debut", "{$_POST["timestamp_debut"]}", "timestamp_fin", "{$_POST["timestamp_fin"]}", "print", "on", "recherche_limite", $recherche_limite, "texte_recherche", $texte_recherche, "sous_traitant_limite", $sous_traitant_limite);
			echo $this->form($this->rel_file_name, $this->lang["pied_impression"], "", "", "", "print", "on");
			echo "</td></tr>";
// 			print $this->rel_file_name;
		}
		
		// dbut
		echo "\n<tr><td align=left width=30>";
		if ($debut_mysql>0) echo $this->form("{$this->rel_file_name}", "<<-", "", "", "", "debut", "0", "nodossier", "{$_POST["nodossier"]}", "timestamp_debut", "{$_POST["timestamp_debut"]}", "timestamp_fin", "{$_POST["timestamp_fin"]}", "secteur", "{$_POST["secteur"]}", "recherche_limite", $recherche_limite, "texte_recherche", $texte_recherche, "sous_traitant_limite", $sous_traitant_limite);
		else echo "<<-";
		echo "</td>&nbsp;";
		
		//prcdent
		echo "\n<td align=left width=30>";
		if ($debut_mysql>$_SESSION["nb_affiche"])
		{
			$init=$debut_mysql - $_SESSION["nb_affiche"];
			echo $this->form("{$this->rel_file_name}", "<-", "", "", "", "debut", $init, "nodossier", "{$_POST["nodossier"]}", "timestamp_debut", "{$_POST["timestamp_debut"]}", "timestamp_fin", "{$_POST["timestamp_fin"]}", "secteur", "{$_POST["secteur"]}", "recherche_limite", $recherche_limite, "texte_recherche", $texte_recherche, "sous_traitant_limite", $sous_traitant_limite);
		}
		elseif ($debut_mysql>0)
		{
			echo $this->form("{$this->rel_file_name}", "<-", "", "", "", "debut", "0", "nodossier", "{$_POST["nodossier"]}", "timestamp_debut", "{$_POST["timestamp_debut"]}", "timestamp_fin", "{$_POST["timestamp_fin"]}", "secteur", "{$_POST["secteur"]}", "recherche_limite", $recherche_limite, "texte_recherche", $texte_recherche, "sous_traitant_limite", $sous_traitant_limite);
		}
		else echo "<-";
		echo "</td>";
		
		// liste des enregistrements //>
		echo "\n<form action=\"{$_SERVER["PHP_SELF"]}\" method=\"Post\"><td align=center>";
		echo $this->input_hidden("debut", $init), "\n";
		echo $this->input_hidden("nodossier", "{$_POST["nodossier"]}"), "\n";
		echo $this->input_hidden("timestamp_debut", "{$_POST["timestamp_debut"]}"), "\n";
		echo $this->input_hidden("timestamp_fin", "{$_POST["timestamp_fin"]}"), "\n";
		echo $this->input_hidden("secteur", "{$_POST["secteur"]}"), "\n";
		echo $this->input_hidden("recherche_limite", "$recherche_limite"), "\n";
		echo $this->input_hidden("texte_recherche", "$texte_recherche"), "\n";
		echo $this->input_hidden("sous_traitant_limite", "$sous_traitant_limite"), "\n";
		echo "{$this->lang["general_records"]} ", $debut_mysql + 1, "&nbsp;{$this->lang["general_to"]}&nbsp;";
		if ($debut_mysql<($stop_mysql-$_SESSION["nb_affiche"])) echo $debut_mysql + $_SESSION["nb_affiche"];
		else echo $stop_mysql;
		echo "&nbsp;({$this->lang["pied_vague"]} <input size=3 type=text name=\"nb_affiche\" value=\"{$_SESSION["nb_affiche"]}\">)";
		echo $this->button($config_modify_maj_others);
		echo "</td></form>";
		
		// suivant
		echo "\n<td align=right width=30>";
		if ($debut_mysql<($stop_mysql-$_SESSION["nb_affiche"]))
		{
			$init=$debut_mysql + $_SESSION["nb_affiche"];
			echo $this->form("{$this->rel_file_name}", "->", "", "", "", "debut", $init, "nodossier", "{$_POST["nodossier"]}", "timestamp_debut", "{$_POST["timestamp_debut"]}", "timestamp_fin", "{$_POST["timestamp_fin"]}", "secteur", "{$_POST["secteur"]}", "recherche_limite", $recherche_limite, "texte_recherche", $texte_recherche, "sous_traitant_limite", $sous_traitant_limite);
		}
		else echo "->";
		echo "</td>&nbsp;";
		
		// fin
		echo "\n<td align=right width=30>";
		if ($debut_mysql<($stop_mysql-$_SESSION["nb_affiche"]))
		{
		$init=$stop_mysql - $_SESSION["nb_affiche"];
		echo $this->form("{$this->rel_file_name}", "->>", "", "", "", "debut", $init, "nodossier", "{$_POST["nodossier"]}", "timestamp_debut", "{$_POST["timestamp_debut"]}", "timestamp_fin", "{$_POST["timestamp_fin"]}", "secteur", "{$_POST["secteur"]}", "recherche_limite", $recherche_limite, "texte_recherche", $texte_recherche, "sous_traitant_limite", $sous_traitant_limite);
		}
		else echo "->>";
		echo "</td></tr></table>
		
		<//accs direct aux pages//>";
		echo "<table align=center border=0><tr><td>{$this->lang["general_acces"]} </td></tr></table>";
		echo "<table align=center border=0><tr>";
		$noenreg=0;
		$noligne=0;
		while($noenreg<$stop_mysql)
		{
			$nopage=$noenreg/$_SESSION["nb_affiche"]+1;
			if($noligne==20)
			{
				$noligne=0;
				echo "</tr></table><table align=center border=0><tr>";
			}
			echo "<td>";
			if($noenreg<>$_POST["debut"])
			{
				$class = "";
				$racc=$nopage;
			}else {
				$class = "selected_bg";
				$racc="";
			}
			echo $this->form("{$this->rel_file_name}", $nopage, $racc, "$class", "", "nodossier", "{$_POST["nodossier"]}", "debut", "$noenreg", "timestamp_debut", "{$_POST["timestamp_debut"]}", "timestamp_fin", "{$_POST["timestamp_fin"]}", "secteur", "{$_POST["secteur"]}", "recherche_limite", $recherche_limite, "texte_recherche", $texte_recherche, "sous_traitant_limite", $sous_traitant_limite);
			/*echo "<a  timestamp_debut=$timestamp_debut&timestamp_fin=$timestamp_fin\">";
			
			if($noenreg<>$_POST["debut"]) echo "</a>";*/
			echo "</td>";
			$noenreg=$noenreg+$_SESSION["nb_affiche"];
			$noligne++;
		}
		echo "</tr></table>";
	unset($this->form_global_var);
	}
	
	function selecteur($nom="", $test=FALSE, $all=FALSE, $session=TRUE, $post="", $seul_autorise=FALSE,$groups=FALSE, $groups_only=FALSE)
	{
		//****************************************
		//Paramtres:
		//$nom = nom de l'accs, utilis pour l'ventuelle gestion des droits
		//$test indique si l'on doit tester ou pas les droits
		//$all = inutilis (servait  grer une base commune
		//$session = test sur la concordance entre la liste et la session en cours
		//$post = test sur la concordance entre la liste et la valeur passe  post
		//$groups = affiche les groupes
		//$groups_only = n'affiche pas les utilisateurs
		
		
//		$this->liste_des_logins = $this->liste_logins();
		$this->debugNow("Appel  liste_des_utilisateursgroupes");
		$this->liste_des_utilisateursgroupes = $this->liste_utilisateursgroupes();
		$this->debugNow("Fin. Appel  liste_des_utilisateurs");
		$this->liste_des_utilisateurs = $this->liste_utilisateurs();
		$this->debugNow("Fin de l'appel  liste_des_utilisateurs");
		$selecteur="";
		$temp["liste1"] = "";
		$temp["liste2"] = "";
		$userlist=explode(",", $post);
		if($groups) 
		{
			foreach($this->liste_des_utilisateursgroupes as $groupname)
			{
// 				$val=$groupname."***group***";
				$val = "_".$groupname;
				$selected = in_array($val, $userlist) ? "selected":"";
				$selecteur.="<option value=\"$val\" class=\"attention\" $selected>$groupname</option>";
			}
			if(!$groups_only) $selecteur.="<option value=\"\">----------</option>";
		}
		$exist_selected=0;
		foreach($userlist as $rang => $val) $userlist["$rang"] = trim($val);
		if(!$groups_only)
		{
			$this->debugNow("Parcours de liste_des_utilisateurs");
			$toCheck = ($nom == "liste_archives")? $this->liste_utilisateurs_archives():$this->liste_des_utilisateurs;
			$archMod = ($nom == "liste_archives")? True:false;
			foreach($toCheck as $init =>$array)
			{
// 				$this->debugNow("Dbut de $init");
				$init=substr($init, 0, 2);
				$seul=$array["seul"];
				$nom=$array["nom"];
				$total=$init."clients";
				if(($_SESSION["db"]==$init OR $_SESSION["db"]==$total) AND $session==TRUE) 
				{
					$selected="selected"; 
					$exist_selected=1;
				}
				elseif($post == $init OR $post==$total)
				{
					$selected="selected"; 
					$exist_selected=1;
				}
				elseif(in_array($init, $userlist) OR in_array($total, $userlist))
				{
					$selected="selected"; 
					$exist_selected=1;
				}
				else $selected="";
				if($this->cal_mode) $valtotest="lire_agenda";
				else $valtotest="lire";
				if($test && $test !== true)
				{
					$valtotest=$test;
// 					$test=true;
				}
				$listeChoisie = $selected ? "liste1":"liste2";
// 				echo "<br>On teste $init avec $valtotest";
// 				echo "cal_mode = '{$this->cal_mode}'";
// 				print "<br>$this->testval($valtotest, $init): ". $this->/*testval*/("$valtotest", $init);
				if(($test==FALSE || (/*$this->debugNow("Appel  testval ($valtotest, $init)") AND */$this->testval("$valtotest", $init)/* AND $this->debugNow("Appel  testval fini")*/)) AND (trim($seul) != "1" OR $seul_autorise)) $temp["$listeChoisie"].="<option value=\"$init\" $selected>$nom</option>";
// 				$this->debugNow("Fin de $init");
			}
			$this->debugNow("Fin du parcours de liste_des_utilisateurs");
			if(!$temp["liste1"]) $temp["liste1"] = "<option value=\"\"></option>";
			$selecteur = $temp["liste1"].$temp["liste2"];
		}
// 		if($exist_selected==0 && !$groups_only) $selecteur.="<option value=\"\" selected></option>"; //TODO: pas certain que ce soit encore utile
		return $selecteur;
	}
	
	function simple_selecteur($file="", $post="", $mode=0, $array=false)
	{
		//modes:
		//0 = slection sur la valeur, affichage de la valeur
		//1 = slection sur la valeur, affichage de l'indice - non implment
		//2 = slection sur l'indice, affichage de la valeur
		//3 = slection sur l'indice, affichage de l'indice
		$file=($file) ? $file : explode("\n", $_SESSION["optionGen"]["soustraitants"]);
		$userlist=(is_array($post))?$post:explode(",", $post);
		$selecteur="";
		$exist_selected=0;
		foreach($file as $indice => $ligne) if(trim($ligne) != "")
		{
			list($ligne) = preg_split("/,/", $ligne);
			$val=trim($ligne);
			if($mode < 2)
			{
				if(in_array($val, $userlist))
				{
					$selected="selected";
					$exist_selected=1;
				}
				else $selected="";
			}
			else
			{
				if(in_array($indice, $userlist))
				{
					$selected="selected";
					$exist_selected=1;
				}
				else $selected="";
			}
			$affiche=$val;
			if($mode == 2) $val = $indice;
			if($array) $selecteur[]=$val;
			else $selecteur.="<option value=\"$val\" $selected>$affiche</option>";
		}
		if($exist_selected==0) $selecteur.="<option value=\"\" selected></option>";
		return $selecteur;
	}
	
	function close($clean=FALSE, $ereg="", $dir="temp")
	{
		if($clean == "now"|$this->setDebugNow)
		{
			$this->debugNow("Fin de la page");
			$clean = false;
			list($s1, $m1) = preg_split("/ /", microtime()); 
			list($s2, $m2) = preg_split("/ /", $this->now[0]);
			$s = number_format($s1 + $m1 - $s2 - $m2, 2);
			echo $this->table_open();
			echo "\n<tr><th>Point</th><th>Secondes coules</th></tr>";
			foreach($this->now as $line)
			{
				$nLine = preg_replace("#^[0-9.]+ [0-9.]+ #", "", $line);
				preg_match("/(.*)(-)([^-]*$)/", $nLine , $regs);
				if($regs[3]) echo "\n</tr><td>{$regs[1]}</td><td>{$regs[3]}</td></tr>";
				else echo "\n</tr><td>$nLine</td><td></td></tr>";
// 			echo "\n<tr><td>".preg_replace("/-[^-]*$/", "", preg_replace("#^[0-9.]+ [0-9.]+ #", "", $line))."</td><td>".preg_replace("/.*(-[^-]*$)/", "\0", preg_replace("#^[0-9.]+ [0-9.]+ #", "", $line))."</td></tr>";
			}
			echo "\n<tr><td><b>Total: </b></td><td><b>$s secondes</b></td></tr>";
			echo $this->table_close();
		}
		if($this->table) echo "\n\n<//end of centered text//>\n</td></tr></table>\n\n";
		if($this->html) echo "\n\n</body>\n</html>";
		if($clean AND $ereg) $this->clean_temp($ereg);
	}
	
	
	/*Fonctions de gestion des droits*/
	
	function perm_list()
	{
		require("{$this->settings["root"]}modules/perm_list.php");
	}
	
	
	
	function gerenew($utilisateur, $baseinit, $mode="normal", $vertical=false, $notable=false)
	{
		//notable :
		//1 => ni table, ni tr
		//2 => pas table, mais tr
		//false => table et tr
		
// 		echo "<br>test de '$baseinit'";
		$echoUtilisateur = $utilisateur;
		if(preg_match("#autoprolawyergroupe__#", $utilisateur))
		{
			$echoUtilisateur = preg_replace("#autoprolawyergroupe__#", "", $utilisateur);
			$aGroupe = true;
		}
		if(preg_match("#autoUsergroupe__#", $baseinit))
		{
			$echoBase = preg_replace("#autoUsergroupe__#", "", $baseinit);
// 			echo "<br>bon pour $baseinit";
			$uGroupe = true;
		}
		if(!isset($this->p_inits) || !isset($this->p_names) || !isset($this->p_values)) $this->perm_list();
		$inits=$this->p_inits;
		$names=$this->p_names;
		$values=$this->p_values;
		$gestion["level"]=0;
		if(!$uGroupe && $baseinit != "ALLPROLAWYERUSER") $baseinit=substr($baseinit, 0, 2);
		$emptyset=false;
// 		$base=$baseinit."droits";
		
		if($mode == "mefplus")
		{
			$mode = "mef_inits_only";
			$emptyset=true;
		}
		
		if(preg_match("#mef#", $mode))
		{
			if($notable == "1") $mef="";
			elseif($notable == "2") $mef="<tr>";
			else $mef="<table border=1><tr>";
			if($mode=="mef" || $mode=="mef_inits_only")
			{
				$max=0;
				foreach($names as $key => $val)
				{
					if($vertical)
					{
						$fName = $this->getImageName($val, TRUE);
						if(is_file($fName)) $source = $fName;

						else $source = "../image.php?type=ver&nom=$val&valeurdevert";
						$mef .= "<td style=\"vertical-align:bottom\"><img src=\"$source\"></td>";
					}
					else $mef .="<td>{$inits[$key]}</td>";
					$len=strlen($val) * 5;
// 					echo "<br>len de $val est $len";
					if($len > $max) $max = $len;
				}
				$mef = preg_replace("#valeurdevert#", "vert=$max", $mef);
			}
		}
		
		$this->liste_des_admins = $this->liste_admins();
		
		if(in_array($echoUtilisateur, $this->liste_des_admins)|| ($_SESSION["user"] == $echoUtilisateur && $_SESSION["type"] == "admin"))
		{
			foreach($values as $x => $value)
			{
				$name=$baseinit."__".$echoUtilisateur."__".$values[$x];
				if($mode == "array") $array["$x"]=1;
				if($mode == "mef" || $mode == "mef_rights_only") $mef .= "<td><input type=\"checkbox\" name=\"$name\" checked></td>";
				if($mode == "mef_rights_only_noadmin")
				{
					$mef .= "<td align=\"center\" class=\"attention\">x</td>";
// 					$mode = "mef_rights_only";
				}
			}
			if(preg_match("#mef#", $mode))
			{
				if($notable == "2") $mef .= "</tr>";
				elseif($notable == "1") $mef .= "";
				else $mef .= "</tr></table>";
				return $mef;
			}
			if($mode == "array") return $array;
		}
		
		$limit = "";
		if($emptyset)
		{
			$luser=$echoUtilisateur;
			$linit=$baseinit;
			$utilisateur="%";
			$baseinit="%";
			$limit = "LIMIT 1";
		}
		$gTest = ($aGroupe)? "1":"0";
		if($uGroupe) $test = "select * from droits where personne like '$echoUtilisateur' AND groupname like '$echoBase' AND accesgroupe like '$gTest' $limit";
		else $test = "select * from droits where personne like '$echoUtilisateur' AND init like '$baseinit' AND accesgroupe like '$gTest' $limit";
//    		echo "<br>$test";
		@$ex=mysql_query($test);
		while($row=mysql_fetch_array($ex, MYSQL_ASSOC))
		{
/*			echo "<br>";
			foreach($row as $a => $b) echo "$a a pour valeur $b, ";*/
			
			if($emptyset) $utilisateur = $luser;
			if($emptyset) $baseinit = $linit;
			if($mode == "array" || $mode == "mef" || $mode == "mef_rights_only" || $mode == "mef_rights_only_noadmin" || $emptyset)
			{
				if(($mode == "mef" || $mode == "mef_rights_only" || $mode == "mef_rights_only_noadmin" || $emptyset) && $notable != "1") $mef .= "<tr>";
				foreach($values as $x => $value)
				{
// 					$name = $aGroupe ? "autoprolawyergroupe__$name":$name;
					if($row["admin"] == "1") $row["$value"] = "1";
					$name=$baseinit."__".$utilisateur."__".$values[$x];
					$checked = ($row["$value"] == "1")? "checked":"";
					$checked = ($emptyset)? "":$checked;
					if($mode == "array") $array["$x"]=$row["$value"];
					if($mode == "mef" || $mode == "mef_rights_only" || $mode == "mef_rights_only_noadmin" || $emptyset) $mef .= "<td><input type=\"checkbox\" name=\"$name\" $checked></td>";
				}
				if($mode == "mef" || $mode == "mef_rights_only" || $mode == "mef_rights_only_noadmin")
				{
					if($notable == "2") $mef .= "</tr>";
					elseif($notable == "1") $mef .= "";
					else $mef .= "</tr></table>";
					return $mef;
				}
				if($mode == "array") return $array;
			}
		}
		
		
		//Si on n'est pas sorti  ce stade, c'est que la personne n'est pas administrateur et n'a pas de droits.
		foreach($inits as $x => $val)
		{
			$name=$baseinit."__".$utilisateur."__".$values[$x];
			if($mode == "array") $array["$x"]=0;
			if($mode == "mef" || $mode == "mef_rights_only" || $mode == "mef_rights_only_noadmin") $mef .= "<td><input type=\"checkbox\" name=\"$name\"></td>";
		}
		if(preg_match("#mef#", $mode))
		{
			if($notable == "2") $mef .= "</tr>";
			elseif($notable == "1") $mef .= "";
			else $mef .= "</tr></table>";
			return $mef;
		}
		if($mode == "array") return $array;
	}
	
	function liste_utilisateurs($force=false, $all = false)
	{
		if(($this->liste_des_utilisateurs) && $force == false) return $this->liste_des_utilisateurs;
// 		elseif(!isset($this->right)) return array(); //TODO: pourquoi cela n'est-il plus ncessaire ? Peut-tre parce que les droits sont grs dans les options globales appeles avant toute chose.
		else
		{
			$this->liste_des_utilisateurs = array();
			$query = "select * from utilisateurs where nom not like 'tableDefaultValue' and archive not like '1' order by nom";
			@$ex = mysql_query($query);
			if(!$ex)
			{
				$error = mysql_error();
// 				$this->catchError("010-005#-#$error#\$this->list_utilisateurs($force)", 4);
				return array();
			}
			while($row=mysql_fetch_array($ex, MYSQL_ASSOC))
			{
				$tempar=array();
				foreach($row as $nom => $val) /*if($nom != initiales)*/ $tempar[$nom]=$val;
				$initiales=$row["initiales"];
				$this->liste_des_utilisateurs[$initiales]=$tempar;
			}
			if($all) $this->liste_des_utilisateurs = array_merge($this->liste_des_utilisateurs, $this->liste_utilisateurs_archives($force));
			return $this->liste_des_utilisateurs;
		}
	}
	
	function liste_utilisateurs_archives($force=false)
	{
		if(($this->liste_des_utilisateurs_archives) && $force == false) return $this->liste_des_utilisateurs_archives;
// 		elseif(!isset($this->right)) return array(); //TODO: pourquoi cela n'est-il plus ncessaire ? Peut-tre parce que les droits sont grs dans les options globales appeles avant toute chose.
		else
		{
			$this->liste_des_utilisateurs_archives = array();
			$query = "select * from utilisateurs where nom not like 'tableDefaultValue' and archive like '1' order by nom";
			@$ex = mysql_query($query);
			if(!$ex)
			{
				$error = mysql_error();
// 				$this->catchError("010-005#-#$error#\$this->list_utilisateurs($force)", 4);
				return array();
			}
			while($row=mysql_fetch_array($ex, MYSQL_ASSOC))
			{
				$tempar=array();
				foreach($row as $nom => $val) /*if($nom != initiales)*/ $tempar[$nom]=$val;
				$initiales=$row["initiales"];
				$this->liste_des_utilisateurs_archives[$initiales]=$tempar;
			}
			return $this->liste_des_utilisateurs_archives;
		}
	}
	
	function liste_utilisateursgroupes($force=false)
	{
		if(isset($this->liste_des_utilisateursgroupes) && $force == false) return $this->liste_des_utilisateursgroupes;
		else
		{
			$this->liste_des_utilisateursgroupes = array();
			$query = "select * from utilisateursgroupes group by nomgroupe";
			@$ex = mysql_query($query);
			if(!$ex) return array();
			while($row=mysql_fetch_array($ex, MYSQL_ASSOC))
			{
				$this->liste_des_utilisateursgroupes[]=$row["nomgroupe"];
			}
			return $this->liste_des_utilisateursgroupes;
		}
	}

	function liste_utilisateursgroupes_ex($force=false)
	{
		/*fonction qui retourne la liste des membres des groupes sous la forme
		groupe 1 => (0 => membre 1)
		groupe 2 => (0 => membre 3, 1 => membre 4)
		La liste ne donne que les membres des groupes, non les non-membres
		*/
		
		if(isset($this->liste_des_utilisateursgroupes_ex) && $force == false) return $this->liste_des_utilisateursgroupes_ex;
		else
		{
			$this->liste_des_utilisateursgroupes_ex = array();
			$query = "select * from utilisateursgroupesmembres order by groupe, membre";
			@$ex = mysql_query($query);
			if(!$ex) return array();
			while($row=mysql_fetch_array($ex, MYSQL_ASSOC))
			{
				$ngr= $row["groupe"];
				$this->liste_des_utilisateursgroupes_ex["$ngr"][]=$row["membre"];
			}
			
			$this->debugNow("liste_utilisateursgroupes - debut");
			$this->getLdapGroups();
			$this->debugNow("liste_utilisateursgroupes - fin");
			return $this->liste_des_utilisateursgroupes_ex;
		}
	}
	
	function liste_utilisateursgroupes_revert($force=false)
	{
		/*fonction qui retourne la liste des membres des groupes sous la forme
		membre 1 => (0 => groupe 1)
		membre 2 => (0 => groupe 3, 1 => groupe 4)
		La liste ne donne que les membres des groupes, non les non-membres
		*/
		
		if(isset($this->liste_des_utilisateursgroupes_revert) && $force == false) return $this->liste_des_utilisateursgroupes_revert;
		else
		{
			$this->liste_des_utilisateursgroupes_revert = array();
			$templist = $this->liste_utilisateursgroupes_ex();
			foreach($templist as $grpName => $listeUsers)
			{
				foreach($templist[$grpName] as $singleUser)
				{
					if(!is_array($this->liste_des_utilisateursgroupes_revert[$singleUser])) $this->liste_des_utilisateursgroupes_revert[$singleUser] = array();
					if(!in_array($grpName, $this->liste_des_utilisateursgroupes_revert[$singleUser])) $this->liste_des_utilisateursgroupes_revert[$singleUser][] = $grpName;
				}
			}
			return $this->liste_des_utilisateursgroupes_revert;
		}
	}
	
	function getMyRights($user = "", $force = false)
	{
		if(!$user) $user = $_SESSION["user"];
		if(isset($this->myRights["$user"]) && ! $force) return $this->myRights["$user"];
		if(!isset($this->myRights)) $this->myRights = array();
		if(!isset($this->myRights["$user"])) $this->myRights["$user"] = array();
		$utilisateursgroupesMembres = $this->liste_utilisateursgroupes_ex();
		$accesgroupesMembres = $this->liste_accesgroupes_ex();
	}

/*	function AccesGroups($user = "", $force = false) // TODO: voir si cela ne fait pas double emploi avec liste_accesgroupes_ex
	{
		if(!isset($this->accesGroupsMembership)) $this->accesGroupsMembership = array();
		if(!$user) $user = $_SESSION["user"];
		if(isset($this->accesGroupsMembership["$user"]) && ! $force) return $this->accesGroupsMembership["$user"];
		$q = "select ugroupe from accesgroupesmembres where umembre like '$user'";
		$e = mysql_query($q);
		while($r = mysql_fetch_array($e)) $this->accesGroupsMembership["$user"][] = $r["ugroupe"];
		return $this->accesGroupsMembership["$user"];
	}*/
	
	function liste_acces($force=false)
	{
		if(($this->liste_des_acces) && $force == false) return $this->liste_des_acces;
		else
		{
			$this->liste_des_acces = array();
			$query = "select user, type from acces where user not like 'tableDefaultValue' order by user";
			$ex = @mysql_query($query);
			if(!$ex)
			{
				$error = mysql_error();
// 				$this->catchError("010-005#-#$error#\$this->list_acces($force)", 4);
				return array();
			}
			while($row=mysql_fetch_array($ex, MYSQL_ASSOC))
			{
				$this->liste_des_acces[] = array("user" => $row["user"],"type" => $row["type"]);
				if($_SESSION["user"] == $row["user"]) $curUser = true;
			}
			if(!$curUser)$this->liste_des_acces[] = array("user" => $_SESSION["user"],"type" => $_SESSION["type"]);
			return $this->liste_des_acces;
		}
	}
	
	function liste_accesgroupes($force=false, $gpradd=false)
	{
		if(isset($this->liste_des_accesgroupes) && $force == false) return $this->liste_des_accesgroupes;
		else
		{
			$this->liste_des_accesgroupes = array();
			$query = "select * from accesgroupes group by nomugroupe";
			@$ex = mysql_query($query);
			if(!$ex) return array();
			while($row=mysql_fetch_array($ex, MYSQL_ASSOC))
			{
				if($gpradd) $row["nomugroupe"] .= "__groupe";
				$this->liste_des_accesgroupes[]=$row["nomugroupe"];
			}
			return $this->liste_des_accesgroupes;
		}
	}
	
	function liste_accesgroupes_ex($force=false)
	{
		/*fonction qui retourne la liste des membres des groupes sous la forme
		groupe 1 => (membre 1)
		groupe 2 => (membre 3, membre 4)
		La liste ne donne que les membres des groupes, non les non-membres
		*/
		if(isset($this->liste_des_accesgroupes_ex) && $force == false) return $this->liste_des_accesgroupes_ex;
		else
		{
			$this->liste_des_accesgroupes_ex = array();
			$query = "select * from accesgroupesmembres order by ugroupe, umembre";
			@$ex = mysql_query($query);
			if(!$ex) return array();
			while($row=mysql_fetch_array($ex, MYSQL_ASSOC))
			{
				$ngr= $row["ugroupe"];
// 				echo "<br>Pour $ngr, membre = {$row["umembre"]}";
				$this->liste_des_accesgroupes_ex["$ngr"][]=$row["umembre"];
			}
			$this->debugNow("liste_accesgroupes - debut");
			$this->getLdapGroups();
			$this->debugNow("liste_accesgroupes - fin");
			return $this->liste_des_accesgroupes_ex;
		}
	}
	
	function getLdapGroups()
	{
		if(in_array("ldap", $_SESSION["connectionMethods"]) && $_SESSION["ldapServer"] && !$this->ldapGroupsGiven)
		{
			$this->doConnectLdap($_SESSION["user"], $_SESSION["pwd"]); //essai de connection authentifie, sinon on essaie une connection simple
			$dn2 = "ou=group,dc={$_SESSION["ldapServer"]}";
			$params = array("*");
// 			$trouve  = ($func == "liste_acces") ? $ar["user"]:$ar["initiales"];
// echo "{$this->ldapConnected}, $dn2, \"(&(memberuid=*))\", $params";
			$search = ldap_search($this->ldapConnected, $dn2, "(&(memberuid=*))", $params);
			$infos = ldap_get_entries($this->ldapConnected, $search);
			$personnes = $this->liste_utilisateurs();
			$cListe = array();
			foreach($personnes as $init => $array)
			{
				$nom = strtolower($personnes["$init"]["nom"]);
				$cListe["$nom"] = $init;
			}
// 			$this->tab_affiche($cListe);
			if(is_array($infos))
			{
				foreach($infos as $info)
				{
					$groupe = $info["cn"][0];
					if($groupe)
					{
						foreach($info["memberuid"] as $init => $member) if($init !== "count")
						{
							if(!isset($this->liste_des_accesgroupes_ex["$groupe"]) || !in_array($member, $this->liste_des_accesgroupes_ex["$groupe"])) $this->liste_des_accesgroupes_ex["$groupe"][] = $member;
							if(isset($cListe["$member"]) && (!isset($this->liste_des_utilisateursgroupes_ex["$groupe"]) || !in_array($cListe["$member"], $this->liste_des_utilisateursgroupes_ex["$groupe"]))) $this->liste_des_utilisateursgroupes_ex["$groupe"][] = $cListe["$member"];
						}
					}
				}
			}
			$this->ldapGroupsGiven = true;
// 			$this->tab_affiche($this->liste_des_accesgroupes_ex);
// 			$this->tab_affiche($this->liste_des_utilisateursgroupes_ex);
		}
		
	}
	
	function keepTODOold(&$toComplete, $func)
	{
		if(in_array("ldap", $_SESSION["connectionMethods"]) && $_SESSION["ldapServer"])
		{
			$this->doConnectLdap($_SESSION["user"], $_SESSION["pwd"]); //essai de connection authentifie, sinon on essaie une connection simple
			$dn2 = "dc={$_SESSION["ldapServer"]}";
			$params = array("cn");
			foreach($this->$func() as  $i => $ar)
			{
// 				echo "<br>$i";
				$cherche = ($func == "liste_acces") ? $ar["user"]:$ar["nom"];
				$trouve  = ($func == "liste_acces") ? $ar["user"]:$ar["initiales"];
// 				echo "<br>On traite '$trouve'";
				$search = ldap_search($this->ldapConnected, $dn2, "(&(memberuid=$cherche))", $params);
				$infos = ldap_get_entries($this->ldapConnected, $search);
				if(is_array($infos))
				{
// 					echo "<br><br>$trouve est membre de : ";
					foreach($infos as $info)
					{
						$groupe = $info["cn"][0];
						if($groupe)
						{
// 							echo "<br>'$groupe'";
							$toComplete["$groupe"][] = $trouve;
						}
					}
				}
			}
		}
	}
		
	function liste_admins($force=false)
	{
		if(isset($this->liste_des_admins) && $force == false) return $this->liste_des_admins;
		else
		{
			$this->liste_des_admins = array();
			$query = "select user from acces where type like 'admin' order by user";
			@$ex = mysql_query($query);
			if(!$ex) return array();
			while($row=mysql_fetch_array($ex, MYSQL_ASSOC))
			{
				$this->liste_des_admins[] = $row["user"];
			}
			return $this->liste_des_admins;
		}
	}
		
	function liste_droits($user="ALL", $force=false, $withgroups = false)
// 	function liste_droits($user="ALL", $force=false, $withgroups = true)
	{
		if(!isset($this->liste_des_droits)) $this->liste_des_droits = array();
		if($withgroups)
		{
			$accesgroupes = $this->liste_accesgroupes_ex();
			$utilisateursgroupes = $this->liste_utilisateursgroupes_ex();
		}
		if(!$user) return;
		if((isset($this->liste_des_droits_ok["$user"]) || isset($this->liste_des_droits_ok["ALL"])) && $force == false && (isset($this->liste_des_droits_groups["$user"]) || isset($this->liste_des_droits_groups["ALL"]) ||!$withgroups)) return $this->liste_des_droits;
		else
		{
// 			echo "<br>On la teste...";
			if(!$withgroups) $exclusion = "where accesgroupe like '0' AND init not like ''";
			$this->liste_admins();
			$query="select * from droits $exclusion";
			@$ex=mysql_query($query);
			if($ex)
			{
				if(!isset($this->p_values)) $this->perm_list();
// 				$exclusion=array("nod");
// 				$q_ex="show columns from utilisateurs";
// 				$ex_ex=mysql_query($q_ex);
// 				while($q_row=mysql_fetch_array($ex_ex, MYSQL_ASSOC))  $exclusion[] = $q_row["Field"];
				while($row=mysql_fetch_array($ex, MYSQL_ASSOC))
				{
					$ky ++;
// 					if($ky != 1) continue;
					$rowinit=$row["init"];
					$rowaccesgroupe=$row["accesgroupe"];
					$rowgroupname=$row["groupname"];
					$rowpersonne = $row["personne"];
// 					echo "<br><br>rowinit: '$rowinit', rowaccesgroupe: '$rowaccesgroupe',rowgroupname: '$rowgroupname', rowpersonne: '$rowpersonne'";
					$inits = array();
					$personnes = array();
					if($rowinit == "" && $rowgroupname)
					{
//  						echo "<br>rowinit vaut $rowinit et rowgroupname vaut $rowgroupname";
 						if(is_array($utilisateursgroupes["$rowgroupname"])) foreach($utilisateursgroupes["$rowgroupname"] as $member) $inits[] = $member;
					}
					else $inits[] = $rowinit;
// 					echo "<br>Inits enregistrs";
// 					$this->tab_affiche($inits);
// 					echo "--------------";
					if($rowaccesgroupe == "1")
					{
//  						echo "<br>rowaccesgroupe vaut $rowaccesgroupe et rowpersonne vaut $rowpersonne";
 						if(is_array($accesgroupes["$rowpersonne"])) foreach($accesgroupes["$rowpersonne"] as $member) $personnes[] = $member;
					}
					else $personnes[] = $rowpersonne;
// 					echo "<br>Personnes enregistres";
// 					$this->tab_affiche($personnes);
// 					else $inits = $rowinits;
// 					$droit=$row["droit"];
// 					if($row["admin"] == 1) $droit = "admin";
					foreach($row as $nom => $val)if(in_array($nom, $this->p_values))
					{
						foreach($personnes as $personne)foreach($inits as $init) if(substr($user, 1) == $personne || $init == $user || $user == "ALL")
						{
// 							echo "<br>:$init";
							$personne = strtolower($personne);
							if(!isset($this->liste_des_droits[$init][$personne])) $this->liste_des_droits[$init][$personne]=array();
// 							if($init == "os" && $personne == "subilia") echo "<br>$nom => $val: On traite '$personne' comme personne et '$init' comme init";
// 							if(preg_match("#,#", $init)) echo "<br>$nom => $val: On traite '$personne' comme personne et '$init' comme init";
							if(in_array($personne, $this->liste_des_admins)) $this->liste_des_droits[$init][$personne][$nom] = 1;
							elseif($row["admin"] == 1) $this->liste_des_droits[$init][$personne][$nom] = 1;
							elseif($val == 1) $this->liste_des_droits[$init][$personne][$nom] = $val;
						}
					}
// 					$this->tab_affiche($personnes);
// 					$this->tab_affiche($inits);
				}
			}
			$this->liste_des_droits_ok["$user"]=true;
			if($withgroups) $this->liste_des_droits_groups["$user"]=true;
			return $this->liste_des_droits;
		}
	}
	
	function testval($niveau, $base = "", $utilisateur = "")
	{
		//if($this->anchor == "index") return true;
		if($this->menu == "noCheck") return true;
		if(!$utilisateur) $utilisateur = $_SESSION["user"];
		$utilisateur = strtolower($utilisateur);
		if(!$base) $base = $_SESSION["db"];
		//$this->liste_des_admins = $this->liste_admins();
		if($_SESSION["type"] == "admin") return true;
		$this->liste_des_droits = $this->liste_droits("ALL", false, true);
// 		$this->tab_affiche($this->liste_des_droits);
// 		echo "<br>liste des droits[$base][$utilisateur][$niveau] = ".$this->liste_des_droits["$base"]["$utilisateur"]["$niveau"];
		if($niveau == "generique")
		{
			foreach($this->liste_des_droits["$base"]["$utilisateur"] as $key => $value) if($value == "1") return true;
			return false;
		}
		$this->last_test=$niveau;
		if($this->liste_des_droits["$base"]["$utilisateur"]["$niveau"] == "1") return true;
		else return false;
		
		//TODO: rajouter le test via les groupes. Ne pas oublier d'utiliser les fonctions liste_..._ex() qui vont galement rcuprer les groupes LDAP dont l'utilisateur est membre.
	}
	
	function lColors()
	{
		$this->liste_des_utilisateurs = $this->liste_utilisateurs();
		foreach ($this->liste_des_utilisateurs as $gugusse => $props)
		{
			$this->liste_des_utilisateurs["$gugusse"]["lCouleur"] = $this->lColor($this->liste_des_utilisateurs["$gugusse"]["couleur"]);
		}
	}
	
	function lColor($couleur)
	{
		$raw_color=preg_replace("/#/", "", trim($couleur));
		$red = substr($raw_color, 0, 2);
		$green = substr($raw_color, 2, 2);
		$blue = substr($raw_color, 4, 2);
		$lred=dechex(hexdec($red) + (255 - hexdec($red)) /2);
		$lgreen=dechex(hexdec($green) + (255 -hexdec($green)) /2);
		$lblue=dechex(hexdec($blue) + (255 -hexdec($blue)) /2);

		return ("#".$lred.$lgreen.$lblue);
	
	}
	
	function describe_table($name, $ordonne=true)
	{
		$r=array();
		$ressource=mysql_query("describe $name");
		while($row=mysql_fetch_array($ressource, MYSQL_ASSOC))
		{
			$l="";
			foreach($row as $key => $elem) $l.="'$key' = '$elem'\t";
			$r[]=$l;
		}
		if($ordonne) sort($r);
		return $r;
	}
	
	
	public function connection($user = "noUserSet", $pwd = "noPwdSet", $redirect = true, $forceMethod = false)
	{
// 		echo "appel  la fonction connection avec $user, $pwd et $forceMethod";
		/*
		Cette fonction sert  connecter selon divers modules:
		- mysql: connection via les mots de passe de mysql_connect
		- prolawyer: connection via les mots de passe stocks dans la table cre par le programme
		- ldap: connection via les mots de passe stocks dans un serveur LDAP
		
		Le problme existe si prolawyer::connection() est appele sans paramtre. Par dfaut, le programme tente de s'authentifier avec soit des paramtres forcs (forceUser, forcePwd), soit le mot de passe stock en session.
		Ce problme est rsolu en ne donnant pas de paramtre par dfaut  doConnectMysql, mais en passant ces paramtre  cette fonction lorsqu'elle est appele par doConnectProlawyer
		*/

		if(is_array($forceMethod))
		{
			foreach($forceMethod as $method) if($this->doConnect($method, $user, $pwd)) return True;
			return False;
		}
		elseif ($forceMethod)
		{
//  			echo "<br>Connexion...";
			if($this->doConnect($forceMethod, $user, $pwd)) return True;
			return false;
		}
		else
		{
			foreach($_SESSION["connectionMethods"] as $method) if($this->doConnect($method, $user, $pwd))return True; //else echo "<br>La mthode $method avec $user et $pwd a chou";
		}
		if($redirect)
		{
			$nextPage = basename($_SERVER["PHP_SELF"]);
			$location = "./";
			if($this->rel_dir != "config")
			{
				if($_REQUEST["new_check"]) $add = "&erreur=rate1";
				else $add = "&erreur=rate2";
				if($this->rel_dir)
				{
					$add .= "&nextPath={$this->rel_dir}";
					$location = $this->settings["root"];
				}
				$this->setCookie("last_post", serialize($_REQUEST));
			}
			$location .= "index.php?nextPage=$nextPage".$add;
			header ("location: $location");
			die("<br>'$location'");
		}
		return false;
	}
	
	
	private function doConnect($method, $user, $pwd)
	{
		//restauration d'une session antrieure
		if($_REQUEST["restore"])
		{
			$lpost=unserialize(stripslashes($this->getCookie("last_post")));
			$lpost["start_utilisateur"] = $_REQUEST["start_utilisateur"];
			$lpost["start_pwd"] = $_REQUEST["start_pwd"];
			$_REQUEST = $lpost;
			$_REQUEST["new_check"] = "on";
			$this->unsetCookie("last_post");
		}

		if($_REQUEST["start_utilisateur"]) $_REQUEST["forceUser"] = $_REQUEST["start_utilisateur"];
		if($_REQUEST["start_pwd"]) $_REQUEST["forcePwd"] = $_REQUEST["start_pwd"];
		if($user == "noUserSet") $user = $_REQUEST["forceUser"] ? $_REQUEST["forceUser"]: $_SESSION["user"];
		if($pwd == "noPwdSet")  $pwd  = $_REQUEST["forcePwd"] ? $_REQUEST["forcePwd"]: $_SESSION["pwd"];
		if(!$method)  $method  = "(pas de paramtre)";
//     		echo "<br>Connection (mthode $method) avec $user et $pwd ({$_SESSION["user"]} et {$_SESSION["pwd"]})";
		
		$func = "doConnect" .ucfirst($method);
		if(method_exists($this, $func))
		{
			$con = $this->$func($user, $pwd);

			if($con && $_REQUEST["forceUser"]) //TODO: vrifier la cohrence, car l'utilisateur ne change en principe pas  Il n'y a donc pas lieu de recharger ( chaque page, puisque doConnect est appele  chaque page !) les options, surtout aprs les avoir dj charge par __construct();
			{
				$_SESSION = array();
				$_SESSION["user"] = $user;
				$_SESSION["pwd"] = $pwd;
				$this->getOptions("force"); //options passes en session. En principe appeles une seule fois, sinon la fonction ressort sans relire
				$this->getOptionsPerso("force"); //options passes en session relatives  l'utilisateur. En principe appeles une seule fois, sinon la fonction ressort sans relire
				$this->getPagesOptions(); //options de la page, qui doivent tre recharges  chaque page

				$this->getOptionsPerso("force"); //ncessaire, en cas de changement de session, de virer toutes les options..

			}
			if($con) $this->doConnectDb($_SESSION["dbAdmin"], $_SESSION["dbPwd"], true);
			return $con;
		}
		else die("La mthode de connection '$method' (fonction $func) n'est pas dfinie");
	}
	
	private function doConnectApache($user, $pwd)
	{
// 		return false; //franchement pas fonctionnel... quoique...
		if($this->apacheConnected)return true;
		if($_SERVER[PHP_AUTH_USER] == $user && $_SERVER[PHP_AUTH_PW] == $pwd) return true;
		else return false;
	}
	
	private function doConnectProlawyer($user, $pwd)
	{
		if(!$this->doConnectDb($_SESSION["dbAdmin"], $_SESSION["dbPwd"], true)) return false;
		$q = "select * from passwords where user like '$user' AND pwd like password('$pwd')";
// 		echo "'$q'";
		$e = mysql_query($q);
		if(mysql_num_rows($e)) return true;
		else return false;
	}
	
	private function doConnectLdap($user, $pwd)
	{
		$dn = "uid=$user,ou=user,dc={$_SESSION["ldapServer"]}";
		if($this->ldapBinded) return true;
		if(!$this->doConnectLdapDb()) return false;
		$b = @ldap_bind($this->ldapConnected, $dn, $pwd);
		if($b)
		{
			$this->ldapBinded = $b;
			return true;
		}
		return false;
	}
	
	private function doConnectLdapDb()
	{
		if($this->ldapConnected) return true;
		$con = @ldap_connect($_SESSION["ldapServer"]);
		if($con)
		{
			$this->ldapConnected = $con;
			ldap_set_option($this->ldapConnected, LDAP_OPT_PROTOCOL_VERSION, 3);
			return true;
		}
		return false;
		
	}
	private function doConnectMysql($user = "", $pwd = "")
	{
//   		echo "<br>ConnectMysql: mthode appele avec $user et $pwd";
		if($this->dbConnected) return true;
		$connect = @mysql_connect("{$_SESSION["mysqlServer"]}:{$_SESSION["mysqlPort"]}", $user, $pwd);
// 		echo "<br>mysql_connect(\"{$_SESSION["mysqlServer"]}:{$_SESSION["mysqlPort"]}\", $user, $pwd)";
		if($connect)
		{
			$this->con1 = $connect;
			if(mysql_select_db($_SESSION["dbName"])) $this->mysqlConnected = true;
			elseif (mysql_query("CREATE DATABASE {$_SESSION["dbName"]}") && mysql_select_db($_SESSION["dbName"])) $this->mysqlConnected = true;
			$this->testConDb = mysql_select_db($_SESSION["dbName"]);
		}
		if($this->mysqlConnected) return true;
		return false;
	}
	
	
	private function doConnectDb($user = "", $pwd = "", $calledByProlawyer = false)
	{
 		$comp = $calledByProlawyer ? " (appele par Prolawyer)":"";
//   		echo "<br>ConnectDb: mthode appele avec '$user' et '$pwd'$comp";
		if($this->dbConnected) return true;
		$connect = @mysql_connect("{$_SESSION["mysqlServer"]}:{$_SESSION["mysqlPort"]}", $user, $pwd);
		if($connect)
		{
			$this->con2 = $connect;
			if(mysql_select_db($_SESSION["dbName"])) $this->dbConnected = true;
			elseif (mysql_query("CREATE DATABASE {$_SESSION["dbName"]}") && mysql_select_db($_SESSION["dbName"])) $this->dbConnected = true;
		}
		if($this->dbConnected) return true;
		return false;
	}
	
	public function createUser($nom, $pwd, $type, $method="")
	{
		if(!$method)
		{
			if($_SESSION["defaultMethod"]) $method = $_SESSION["defaultMethod"];
			else $method = "Prolawyer";
		}
		$this->setUserType($nom, $type, false, $method);
		if($pwd != "***noChange***") $this->setUserPwd($nom, $pwd);
		
	}

	public function setUserType($user, $type, $check=false)
	{
		if(!$this->doConnectDb($_SESSION["dbAdmin"], $_SESSION["dbPwd"], true)) return false;
		$q1 = "delete from acces where user like '$user'";
		$q2 = "insert into acces set user = '$user', type = '$type'";
		$e1 = mysql_query($q1);
		$e2 = mysql_query($q2);
		if($e1 && $e2) return true;
		return false;
	}
	
	public function setUserPwd($user = "", $pwd = "", $check=false, $forceMethod = false)
	{
		if(is_array($forceMethod))
		{
			foreach($_SESSION["connectionMethods"] as $method) 
			{
				if(in_array($method, $forceMethod) && $this->doSetUser($method, $user, $pwd, $check)) return True;
			}
		}
		else
		{
			foreach($_SESSION["connectionMethods"] as $method) 
			{
				if((!$forceMethod || $method == $forceMethod) && $this->doSetUser($method, $user, $pwd, $check)) return True;
			}
		}
		return false;
	}
	
	private function doSetUser($method, $user, $pwd, $check)
	{
		$func = "doSetUser" .ucfirst($method);
		if(method_exists($this, $func)) return $this->$func($user, $pwd, $check);
		//else echo ("La mthode de connection '$method' (fonction $func) n'est pas dfinie");
// 		if($method == "prolawyer") return $this->doSetUserProlawyer($user, $pwd, $check);
// 		if($method == "mysql") return $this->doSetUserMysql($user, $pwd, $check);
		return false;
	}
	
	private function doSetUserProlawyer($user, $pwd, $check)
	{
// 		echo "toto";
		if(!$this->doConnectDb($_SESSION["dbAdmin"], $_SESSION["dbPwd"], true)) return false;
// 		echo "titi";
		$q1 = "delete from passwords where user like '$user'";
		$q2 = "insert into passwords set user = '$user', pwd = password('$pwd')";
		$q3 = "select *, password('$pwd') as cPwd  from passwords where user like '$user'";
		
		if($check)
		{
			$e3 = mysql_query($q3);
			if(mysql_num_rows($e3))
			{
				$this->catchError("100-005", 2);
				return false;
			}
		}
		$e1 = mysql_query($q1);
		$e2 = mysql_query($q2);
		$e3 = mysql_query($q3);
		while($r = mysql_fetch_array($e3))
		{
			if(mysql_num_rows($e3) == 1 && $user == $r["user"] && $r["cPwd"] == $r["pwd"] && $type == $r["type"]) return true;
			echo " $user == {$r["user"]} && {$r["cPwd"]} == {$r["pwd"]} && $type == {$r["type"]}";
		}
		return false;
	}
	
	
	
	/*Fonctions de configuration*/
	
	function get_prolawyer_tables($force = false)
	{
		if(isset($this->deftables) && $force == false) return $this->deftables;
		else
		{
			$this->deftables = array();
			$dir=opendir("{$this->settings["root"]}config/tables");
			while($file=readdir($dir))
			{
				if(preg_match("#def_#", $file))
				{
					if(preg_match("#_system.sql#", $file))
					{
// 						$tname = preg_replace("#_system.php#", "", preg_replace("#def_#", "", $file));
						$tname= preg_replace("#def_(.*)_system.sql#", "\\1", $file);
						$this->deftables["system"][$file] = $tname;
					}
					if(preg_match("#_partner.sql#", $file))
					{
// 						$tname= preg_replace("#_partner.php#", "", preg_replace("#def_#", "", $file));
						$tname= preg_replace("#def_(.*)_partner.sql#", "\\1", $file);
						$this->deftables["partner"][$file] = $tname;
					}
				}
			}
			return $this->deftables;
		}
	}
	
	function create_prolawyer_table($nom, $type="", $quiet=true, $action="create")
	{
		
		/**************************************************
		Paramtres de la fonction:
		- soit nomDeTableSystem, "", ..
		- soit nomDeTablePartner, clients|op, ..
		o nomDeTablePartner est de type xxclients|xxop
		
		codes de retour:
		false=chec dans la mise  jour ou la cration
		1=cration avec succs
		2=mise  jour avec succs
		3=la table existe dj et est  jour
		**************************************************/
// 		echo "<br>Cration de la table avec nom='$nom', type='$type', quiet='$quiet', action='$action'<br>";
		
		$deftables=$this->get_prolawyer_tables();
// 		$this->tab_affiche($deftables);
		
		$cherche=($type) ? $type:$nom;
		if(in_array($cherche, $deftables["system"]))
		{
			$mode="system";
		}
		elseif(in_array($cherche, $deftables["partner"]))
		{
			$mode="partner";
		}
		else $cherche .= ": erreur";
// 		echo "<br>table de nom '$nom' et de type '$type' en mode '$mode' ('$cherche' recherch):<br>";

		if(!$type) $type=$nom;
		//vrification de l'existence de la table
		$table_checked=FALSE;
		$check_query="show tables from {$_SESSION["dbName"]}";
//  		echo "<br>$check_query<br> ". $this->con1;
		$do_check=mysql_query($check_query) or die("Erreur: " .mysql_error());
		while ($row=mysql_fetch_array($do_check))
		{
			if($row["Tables_in_{$_SESSION["dbName"]}"]==trim($nom))
			{
//   				echo "<br>la table $nom est dj dans le systme";
				$table_checked=TRUE;
// 				$tc=substr($type, 0, 2);
				
				$this->create_prolawyer_table("tempzz234{$tc}", "$type");
				$this->comp["$tc"]=$this->describe_table("tempzz234{$tc}");
				$dropad=mysql_query("drop table tempzz234{$tc}");
				
				if ($this->describe_table(trim($nom)) == $this->comp[$tc]) return 3; //table dj  jour
				else $action = "update";
// 				echo "<br>La table n'est pas  jour. On s'en occupe";
// 				die("non");
			}
		}
		
		global $message_ajour;
		global $temp_ajour;
		$modele = "{$this->settings["root"]}config/tables/def_{$type}_{$mode}.sql";
		$query = file_get_contents($modele);
//		echo "<br>Modle pour $nom de type $type: '$modele'";


		if($mode == "partner") $query=preg_replace("#to_ereg#", $nom, $query);
		elseif($type != $nom)
		{
			$query=preg_replace("#CREATE TABLE '$type'#", "CREATE TABLE '$nom'", $query);
			$query=preg_replace("#CREATE TABLE `$type`#", "CREATE TABLE `$nom`", $query);
		}
		
		if($action == "create")
		{
			$return = (mysql_query($query) or die("$query" .mysql_error()))? 1:0;
			return $return; //return vaut 1 ou 0
		}
		if($action == "update") // pas de mise  jour si la table n'existe pas ou qu'elle est dj  jour
		{
			$return=2;
			$query_temp_array=explode("\n", $query);
			$colarray=array();
			$compteur=0;
			foreach($query_temp_array as $line)
			{
				if(!preg_match("#CREATE#", $line) AND !preg_match("#KEY#", $line) AND !preg_match("#ENGINE#", $line)) 
				{
					$line=trim($line); //oter les blancs
					$line=substr($line, 1, 200); //oter le premier guillemet simple
					list($column, $column_val) = preg_split("#`#", $line);
					$column=trim($column);
					$column_val=trim($column_val);
					if(substr($column_val, -1, 1) == ",") $column_val = substr($column_val, 0, -1);
					$colarray[$column]["valeur"]=$column_val;
					$colarray[$column]["existe"]=FALSE;
					$compteur++;
				}
			}
			$my_query_texte="show columns from $nom";
			$my_query=mysql_query($my_query_texte);
			while($row=mysql_fetch_array($my_query, MYSQL_ASSOC))
			{
				$test=$row["Field"];
				if(isset($colarray["$test"])) $colarray["$test"]["existe"]=TRUE;
			}
			$last_column="";
			if($_SESSION["ajour"]==FALSE)
			{
				if(!$quiet) echo "<br>{$this->lang["config_modify_update"]}&nbsp;: $nom ...";
				foreach($colarray as $column => $type)
				if($column)
				{
					{
						if($colarray[$column]["existe"]==FALSE) 
						{
							if($last_column) $after = "after $last_column";
							else $after = "FIRST";
							$mysql_query_texte="alter table $nom ADD $column {$colarray["$column"]["valeur"]} $after";
							$message_ajour .= "\n<br><font color=\"00FF00\" size=1>{$this->lang["config_modify_update"]}</font>: <font size=1><i>$mysql_query_texte</i></font>";
// 							echo "<br>Cration de la colonne manquante: $mysql_query_texte";
							$test=mysql_query("$mysql_query_texte") or die("<br>$mysql_query_texte: ". mysql_error());
							if(!$test) $return=false;
						}else{
							$mysql_query_texte="alter table $nom CHANGE $column $column {$colarray["$column"]["valeur"]}";
							$message_ajour .= "\n<br><font color=\"00FF00\" size=1>{$this->lang["config_modify_update"]}</font>: <font size=1><i>$mysql_query_texte</i></font>";
							$test=mysql_query("$mysql_query_texte");
// 							echo "<br>Mise  jour: $mysql_query_texte";
// 							echo "<br>Le test vaut $test";
							if(!$test) $return=false;
						}
						$last_column=$column;
					}
				}
			}
		if(!function_exists(sys_get_temp_dir))
		{
			function sys_get_temp_dir()
			{
				foreach (array("/tmp", "/var/tmp", "C:\\Windows\\Temp", "D:\\Windows\\Temp") as $testDir) if(is_dir($testDir)) return $testDir;
			}
		}
		$temp_ajour=tempnam(sys_get_temp_dir(), 'majProlawyer');
		$open=fopen($temp_ajour, "w+");
		$config_modify_update_question=html_entity_decode($this->lang["config_config_modify_update_question"]);
		$texte_write="<html>\n<head><title>{$this->lang["config_modify_update"]}</title><script language=Javascript>\nfunction quitenreg(){\nconf=confirm(\"$config_modify_update_question?\");\nif(conf==true){\nself.close();\n}\n}\n</script></head>\n<body onclick=\"quitenreg()\">\n".$message_ajour."\n</body>\n</html>";
		$write=fwrite($open, $texte_write);
		
		return $return;
		}
	}
	
	
	
	//Fonctions d'affichage et de gestion des clients
	//fonction d'affichage des noms
	function affiche_personne($type_personne, $nodossier, $no_de_personne="0", $texte_seul="", $type_affiche="0")
	{
		if(!isset($this->affichage_total)) $this->affichage_total="";
/*		global $modifier_donnees_titre;
		global $modifier_donnees_prenom;
		global $modifier_donnees_nom;
		global $modifier_donnees_fonction;
		global $modifier_donnees_adresse;
		global $modifier_donnees_conseil;
		global $modifier_donnees_cp;
		global $modifier_donnees_zip;
		global $modifier_donnees_ville;
		global $modifier_donnees_pays;
		global $modifier_donnees_fax;
		global $modifier_donnees_tel;
		global $modifier_donnees_natel;
		global $modifier_donnees_mail;
		global $modifier_donnees_modifier_client;
		global $modifier_donnees_changer_client;
		global $modifier_donnees_choisir;
		global $modifier_donnees_client;
		global $modifier_donnees_modifier_pa;
		global $modifier_donnees_changer_pa;
		global $modifier_donnees_changer_conseil;
		global $modifier_donnees_pa;
		global $modifier_donnees_rc;
		global $modifier_donnees_type_societe;
		global $adresses_modifier_ccp;*/
	//	global $_SESSION;
		if($no_de_personne==0) $no_de_personne="";
		
		if($type_personne=="client") {
			$column="noadresse".$no_de_personne;
			$modifier_donnees_modifier_personne=$this->lang["modifier_donnees_modifier_client"];
			$modifier_donnees_changer_personne=$this->lang["modifier_donnees_changer_client"];
			$modifier_donnees_personne=$this->lang["modifier_donnees_client"];
		}
		if($type_personne=="pa") {
			$column="nopa".$no_de_personne;
			$cur_ca="noca".$no_de_personne;
			$modifier_donnees_modifier_personne=$this->lang["modifier_donnees_modifier_pa"];
			$modifier_donnees_changer_personne=$this->lang["modifier_donnees_changer_pa"];
			$modifier_donnees_personne=$this->lang["modifier_donnees_pa"];
			$plus=", {$_SESSION["db"]}clients.$cur_ca";
			//echo $plus;
		}
		$no_de_personne++;
		
		
		$query_personne="select adresses.* $plus from adresses, {$_SESSION["db"]}clients where adresses.id={$_SESSION["db"]}clients.$column and {$_SESSION["db"]}clients.nodossier like '$nodossier'";
// 		echo "<br>toti<br>$query_personne<br>";
		$resultat_recherche=mysql_query("$query_personne");
		$row=mysql_fetch_array($resultat_recherche, MYSQL_ASSOC);
		//$i=0;
		
		$vide=FALSE;
		if(mysql_num_rows($resultat_recherche)!=0){
			foreach($row as $nom_val=>$val){
	//			if (!get_magic_quotes_gpc()) $row["$nom_val"]=addslashes($row["$nom_val"]);
	//			$$nom_val=preg_replace("#'#", "`", "$val");
// 				$row["$nom_val"]=preg_replace("#'#", "`", $row["$nom_val"]);
				$v = $this->getClickableItem($nom_val, $val);
				$class["$nom_val"] = $v["class"];
				$sup["$nom_val"] = $v["sup"];
				$$nom_val=$v["val"];
	//			echo "<br>", $row["$nom_val"];
			}
			if($no_de_personne == 1)
			{
				$this->donnee_premier["$type_personne"] = strtoupper($this->no_accent($row["nom"]));
				if($row["prenom"]) $this->donnee_premier["$type_personne"] .= " ".$this->no_accent($row["prenom"]);
			}
			if($no_de_personne == 2)
			{
				$this->donnee_premier["$type_personne"] .= " {$this->lang["general_al"]}";
			}
		}
		else{
			$vide=TRUE;
			$modifier_donnees_changer_personne=$this->lang["modifier_donnees_choisir"];
	//	echo "<br>ne marche pas pour $column<br>";
			$req_vide="show columns from adresses";
			$vide=mysql_query("$req_vide");
			while($col=mysql_fetch_array($vide)){
				$valeur=$col["Field"];
				$$valeur="";
			}
		}
		if($zip==0) $zip="";
		$no_ca=$$cur_ca;
		$query_ca="select prenom, nom, tel, fax, mail from adresses where adresses.id='$no_ca'";
		//echo $query_ca;
		$exec_ca=mysql_query($query_ca);
		while($donnees=mysql_fetch_array($exec_ca)){
			if(!$texte_seul) $donnees_ca="{$donnees["prenom"]} <b>{$donnees["nom"]}</b>. {$this->lang["modifier_donnees_tel"]}: {$donnees["tel"]}. {$this->lang["modifier_donnees_fax"]}: {$donnees["fax"]}. {$this->lang["modifier_donnees_mail"]}: {$donnees["mail"]}";
			else $donnees_ca="{$donnees["prenom"]} {$donnees["nom"]}. {$this->lang["modifier_donnees_tel"]}: {$donnees["tel"]}. {$this->lang["modifier_donnees_fax"]}: {$donnees["fax"]}. {$this->lang["modifier_donnees_mail"]}: {$donnees["mail"]}";
		}
		/*while($exec_ca=mysql_fetch_array(mysql_query($query_ca))){
		$donnees_ca=$exec_ca["donnee_ca"];
		}*/
		$texte="";
		if(!$print)
		{
			$aid="popup_$type_personne$no_de_personne";
			$form = $this->form("creer_dossier.php<td>", "$modifier_donnees_changer_personne", "", "", "", "action", "$column", "nodossier", "$nodossier");
			$texte .= "<table class=$type_personne border=0>";
			$texte .= "<tr><td><b><a href=\"{$this->settings["root"]}adresses/modifier.php?id=$id\" target=\"_new\">$modifier_donnees_personne ($no_de_personne)</a></b></td>$form"; 
			$texte .= "<td style=\"cursor:pointer\" onClick=\"document.getElementById('$aid').style.visibility='hidden'\">[X]</td></tr>";
			$texte .= "</table>";
			if(!$vide)
			{
				$tsociete=$this->simple_selecteur($this->societes, $typesociete, 2);
				$texte .= "<form action=\"./maj_op.php\"method=post>";
				$texte .= "<input type=\"hidden\" name=\"nodossier\" value=\"$nodossier\">";
				$texte .= "<input type=\"hidden\" name=\"id\" value=\"$id\">";
				$texte .= "<input type=\"hidden\" name=\"retour\" value=\"modifier_donnees\">";
				$texte .= "<input type=\"hidden\" name=\"action\" value=\"modifier_fiche\">";
				$texte .= "<table class=$type_personne border=0>";
				//$texte .= "<tr><td colspan=2><a href=# onMouseOver=hide()>[X]</a></td><td colspan=2 align=right><a href=# onMouseOver=hide()>[X]</a></td></tr>";
				$texte .= "<tr><td>{$this->lang["modifier_donnees_titre"]} :</td><td><input type=text size=15 name=titre value=\"$titre\"></td><td{$class["nosociete"]}>{$sup["nosociete"]}&nbsp;<b>{$this->lang["modifier_donnees_nosociete"]} :</td><td><input type=text size=15 name=nosociete id=nosociete{$no_de_personne} value=\"$nosociete\"></b></tr>";
				$texte .= "<tr><td>{$this->lang["modifier_donnees_prenom"]} :</td><td><input type=text size=15 name=prenom value=\"$prenom\"></td><td><b>{$this->lang["modifier_donnees_nom"]} :</td><td><input type=text size=15 name=nom id=nom{$no_de_personne} ordretab=1 value=\"$nom\"></b></td></tr>";
				$texte .= "<tr><td>{$this->lang["modifier_donnees_fonction"]} :</td><td><input type=text size=15 name=fonction value=\"$fonction\"></td><td>{$this->lang["modifier_donnees_type_societe"]} :</td><td><select name=typesociete id=typesociete{$no_de_personne}>$tsociete</select></td></tr>";
				$texte .= "<tr><td>{$this->lang["modifier_donnees_adresse"]} :</td><td><input type=text size=15 name=adresse value=\"$adresse\"></td><td>{$this->lang["modifier_donnees_cp"]} :</td><td><input type=text size=15 name=cp value=\"$cp\"></td></tr>";
				$texte .= "<tr><td>{$this->lang["modifier_donnees_zip"]} :</td><td><input type=text size=15 name=zip value=\"$zip\"></td><td>{$this->lang["modifier_donnees_ville"]} :</td><td><input type=text size=15 name=ville value=\"$ville\"></td></tr>";
				$texte .= "<tr><td>{$this->lang["modifier_donnees_canton"]} :</td><td><input type=text size=15 name=canton id=canton{$no_de_personne} value=\"$canton\"></td><td>{$this->lang["modifier_donnees_pays"]} :</td><td><input type=text size=15 name=pays value=\"$pays\"></td></tr>";
				$texte .= "<tr><td>{$this->lang["adresses_modifier_ccp"]} :</td><td><input type=text size=15 name=ccp value=\"$ccp\"></td></tr>";
				$texte .= "<tr><td colspan=\"2\"><b>{$this->lang["adresses_modifier_prof"]}:</b></td></tr>";
				$texte .= "<tr><td {$class["tel"]}>{$sup["tel"]}&nbsp;{$this->lang["modifier_donnees_tel"]} :</td><td><input type=text size=15 name=tel value=\"$tel\"></td><td {$class["fax"]}>{$sup["fax"]}&nbsp;{$this->lang["modifier_donnees_fax"]} :</td><td><input type=text size=15 name=fax value=\"$fax\"></td></tr>";
				$texte .= "<tr><td {$class["natel"]}>{$sup["natel"]}&nbsp;{$this->lang["modifier_donnees_natel"]} :</td><td><input type=text size=15 name=natel value=\"$natel\"></td><td {$class["mail"]}>{$sup["mail"]}&nbsp;{$this->lang["modifier_donnees_mail"]} :</td><td><input type=text size=15 name=mail value=\"$mail\"></td></tr>";
				$texte .= "<tr><td colspan=\"2\"><b>{$this->lang["adresses_modifier_prive"]}:</b></td></tr>";
				$texte .= "<tr><td {$class["telprive"]}>{$sup["telprive"]}&nbsp;{$this->lang["modifier_donnees_tel"]} :</td><td><input type=text size=15 name=telprive value=\"$telprive\"></td><td {$class["faxprive"]}>{$sup["faxprive"]}&nbsp;{$this->lang["modifier_donnees_fax"]} :</td><td><input type=text size=15 name=faxprive value=\"$faxprive\"></td></tr>";
				$texte .= "<tr><td {$class["natelprive"]}>{$sup["natelprive"]}&nbsp;{$this->lang["modifier_donnees_natel"]} :</td><td><input type=text size=15 name=natelprive value=\"$natelprive\"></td><td {$class["mailprive"]}>{$sup["mailprive"]}&nbsp;{$this->lang["modifier_donnees_mail"]} :</td><td><input type=text size=15 name=mailprive value=\"$mailprive\"></td></tr>";
				$texte .= "<tr><td colspan=2><button type=submit>$modifier_donnees_modifier_personne</button></td></tr></table>";
				$texte .= "</form>";
				if($type_personne=="pa")
				{
					$texte .= "<form action=\"./creer_dossier.php\" method=post><input type=\"hidden\" name=\"nodossier\" value=\"$nodossier\"><input type=\"hidden\" name=\"action\" value=\"$cur_ca\"><table class=$type_personne border=0><tr><td><button type=submit>{$this->lang["modifier_donnees_conseil"]}: $donnees_ca</button></td></tr></table></form>";
				}
			}
		}
		//$texte .= "<tr><td colspan=2><a href=# onMouseOver=hide()>[X]</a></td><td colspan=2 align=right><a href=# onMouseOver=hide()>[X]</a></td></tr>";
// 		if(!$_POST["print"]) $texte="<tr><td onMouseOver=\"this.style.cursor='pointer';this.style.color='a0a0a0'\" onMouseOut=\"this.style.color='000000'\" onClick=\"show_static('$texte','popbox_static')\">$no_de_personne: $prenom <b>$nom</b></td></tr>";
		if(!$_POST["print"])
		{
			$doOnclick = "actpersonne.style.visibility='hidden';actpersonne=document.getElementById('$aid');actpersonne.style.visibility='visible'";
			$nomRC = rawurlencode($nom);
                        $recherche=(!$vide)? "<td style=\"cursor:pointer;font-style:italic;font-size:10\" onClick=\"$doOnclick;window.open('{$this->settings["root"]}modules/recherche/zefix.php?get=TRUE&nom=$nomRC&persid=$no_de_personne','modifier','width=400,height=400,toolbar=no,directories=no,menubar=no,location=no,status=no,resizable=yes,scrollbars=yes')\"><i>{$this->lang["modifier_donnees_rc"]}</i></td>":"";
			$class=($aid == "popup_client1")? "popupguyshow":"popupguy";
			$this->affichage_total .= "\n<div class=\"$class\" id=\"$aid\">$texte</div>";
			$texte="<tr><td onMouseOver=\"this.style.cursor='pointer';this.style.color='a0a0a0'\" onMouseOut=\"this.style.color='000000'\" onClick=\"$doOnclick\">$no_de_personne: $prenom <b>$nom</b></td>$recherche</tr>";
		}else {
			if($cp) $affiche_cp = "$modifier_donnees_cp $cp";
			else $affiche_cp="";
			$texte="<tr><td>$no_de_personne: $prenom <b>$nom</b> $fonction $adresse $affiche_cp $zip <b>$ville</b>. <br>{$this->lang["modifier_donnees_tel"]}: $tel. {$this->lang["modifier_donnees_fax"]}: $fax. {$this->lang["modifier_donnees_natel"]}: $natel. {$this->lang["modifier_donnees_mail"]}: $mail.";
			if($type_personne=="pa") $texte .= " {$this->lang["modifier_donnees_conseil"]}: $donnees_ca";
			$texte .= "</td></tr>";
			if($vide) $texte="<tr><td>$no_de_personne:</td></tr>";
		}
		if($texte_seul)
		{
			if($cp) $affiche_cp = "{$this->lang["modifier_donnees_cp"]} $cp";
			else $affiche_cp="";
			if($type_affiche=="1") $texte="$no_de_personne: $prenom $nom $fonction $adresse $affiche_cp $zip $ville.";
			if($type_affiche=="2") $texte="{$this->lang["modifier_donnees_tel"]}: $tel. {$this->lang["modifier_donnees_fax"]}: $fax. {$this->lang["modifier_donnees_natel"]}: $natel. {$this->lang["modifier_donnees_mail"]}: $mail.";
			if($type_affiche=="3") {
			if($donnees_ca != "") $texte="{$this->lang["modifier_donnees_conseil"]}: $donnees_ca";
			else $texte="";
			}
		}
		return $texte;
	}


	function recherche_conflit($base, $type_personne, $vnombis, $vnomter, $blacklist, $suivi=FALSE, $trouve_qqch=FALSE)
	{
		$return="";
		$base=substr($base, "0","2"); //compatibilit avec l'ancien nomage des bases
		$base .= "clients";
		
		$this->trouve_qqch=$trouve_qqch;
// 		echo "<br>trouve qqch this =", $this->trouve_qqch;
		if($type_personne=="client") $type_column="noadresse";
		else $type_column="nopa";
		
		if($type_personne=="client")
		{
			$h=$this->lang["creer_client_h41"];
			if(preg_match("#nopa#", "{$_POST["action"]}") || preg_match("#noca#", "{$_POST["action"]}") || isset($_POST["cherche_pa"])) $couleur="ffa0a0"; //la couleur est inverses si on veut une pa
			else $couleur="a0ffa0";
		}
		
		if($type_personne=="pa")
		{
			$h=$this->lang["creer_client_h42"];
			if(preg_match("#nopa#", "{$_POST["action"]}") || preg_match("#noca#", "{$_POST["action"]}") || isset($_POST["cherche_pa"])) $couleur="a0ffa0"; //la couleur est inverses si on veut une pa
			else $couleur="ffa0a0";
		}
		
		if($type_personne=="autres")
		{
			$h=$this->lang["creer_client_h43"];
			$couleur="a0ffa0"; //la couleur est toujours verte
		}
		
		for($x=1;$x<5; $x++)
		{
			$typeplus=$type_column.$x;
			$chercheplus=$chercheplus." or $base.$typeplus=adresses.id";
		}
		//recherche du type voulu
		$texte_requete="select adresses.*, nodossier from adresses, $base where ($vnombis) and ($base.$type_column=adresses.id $chercheplus) group by adresses.id order by adresses.nom";
		if($type_personne=="autres") $texte_requete="select adresses.* from adresses where ($vnombis and $blacklist) order by adresses.nom";
		$requete=mysql_query("$texte_requete");
		$numofrow=mysql_num_rows($requete);
		$numrow=1;
		if($numofrow > 1) 
		{
			$affiche_trouve=$this->lang["creer_client_trouves"];
			$this->trouve_qqch = TRUE;
		}
		elseif($numofrow == 1)
		{
			$affiche_trouve=$this->lang["creer_client_trouve"];
			$this->trouve_qqch = TRUE;
		}
		
		//on dcrit les enregistrements trouvs
		
		if($numofrow >0)
		{
			$return .= "<h4>$h ($numofrow  $affiche_trouve)</h4>";
			$return .= "<table>";
			
			//on crit ce qui se passe ligne par ligne 
			while($row = mysql_fetch_array($requete))
			{
				if(!$row["zip"]) $row["zip"]=""; //pour viter l'affichage de numros postaux vide par "0"
				$blacklist=$blacklist."and id!='".$row["id"]."'";
				$return .= "<tr bgcolor=$couleur><td>";
				$return .= "{$row["titre"]}&nbsp;</td><td>";
				$return .= $row["prenom"];
				if($row["prenom"]) $return .= "&nbsp;";
				$return .= htmlentities(strtoupper(html_entity_decode($row["nom"]))). "&nbsp;</td><td>";
				$return .= "{$row["fonction"]}&nbsp;</td><td>";
				$return .= "{$row["adresse"]}&nbsp;</td><td>";
				$return .= "{$row["zip"]}&nbsp;</td><td>";
				$return .= "{$row["ville"]}&nbsp;</td>";
				if(isset($_POST["action"]))
				{
					$return .= "<form action=./modifier_donnees.php method=post><td>";
					$return .= "<input type=hidden name=\"nodossier\" value=\"{$_POST["nodossier"]}\">";
					$return .= "<input type=hidden name=\"fiche\" value=\"{$row["id"]}\">";
					$return .= "<input type=hidden name=\"action\" value=\"{$_POST["action"]}\">";
					$return .= "<input type=submit value=\"{$this->lang["creer_client_accepter"]}\">";
					$return .= "</td></form>";
				}
				else {
					if($_POST["cherche_pa"]=="on")
					{
						$return .= "<form action=./modifier_donnees.php method=post><td>";
						$return .= "<input type=hidden name=\"noadresse\" value=\"{$_POST["noadresse"]}\">";
						$return .= "<input type=hidden name=\"nopa\" value=\"{$row["id"]}\">";
						$return .= "<input type=hidden name=\"new\" value=\"on\">";
						$return .= "<input type=submit value=\"{$this->lang["creer_client_accepter"]}\">";
						$return .= "</td></form>";
					}elseif(!$_POST["cherche_conflits"]){
						$return .= "<form action=./creer_dossier.php method=post><td>";
						$return .= "<input type=hidden name=\"noadresse\" value=\"{$row["id"]}\">";
						$return .= "<input type=hidden name=\"cherche_pa\" value=\"on\">";
						$return .= "<input type=submit value=\"{$this->lang["creer_client_accepter"]}\">";
						$return .= "</td></form>";
					}else{
						$setval=substr($base, 0, 2);
						$nodossier=$row["nodossier"];
						$return .= $this->form("modifier_donnees.php<td>", "{$this->lang["adresses_resultat_consulter"]}", "", "", "", "nodossier", "$nodossier", "new_av", "$setval");
					}
				}
			} 
			$return .= "</table>";
		}
//		elseif($suivi == TRUE AND $this->trouve_qqch == FALSE) echo "<h4>(rien trouv)</h4>";
		elseif($suivi == TRUE AND $this->trouve_qqch == FALSE) $this->niet[] = $this->act_nom;
		$ret["return"]=$return;
		$ret["blacklist"] = $blacklist;
		return $ret;
	}
	
	function debugNow($add = "")
	{
		if(!isset ($this->nowNumber)) $this->nowNumber = 0;
		if(!isset ($this->now)) $this->now = array();
		$n1 = $this->nowNumber;
		$n2 = $this->nowNumber -1;
		$add = $add ? " $add":"";
		$this->now[] = microtime();
		if($n1)
		{
			list($s1, $m1) = preg_split("/ /", $this->now["$n1"]); 
			list($s2, $m2) = preg_split("/ /", $this->now["$n2"]);
			$s = number_format($s1 + $m1 - $s2 - $m2, 2);
			$add .= " - $s secondes coules";// ($s1, $s2, $m1, $m2, '{$this->now["$n2"]}')";
		} 
		$this->now["$n1"].=" point ".$this->nowNumber . $add;
		$this->nowNumber ++;
		return true;
	}
	
	function checkDebug()
	{
		foreach($this->now as $point => $texte)
		{
			echo "\n<br>$point. $texte";
			if($point > 28)
			{
				$ms = substr($texte, 0, 21);
				$msa = substr($this->now[$point -1], 0, 21);
				list($ma, $sa) = preg_split("/ /", $msa);
				list($m, $s) = preg_split("/ /", $ms);
		// 		echo " --$ms--$msa--|$s|$m|$sa|$ma| ";
				$ma = substr($ma, 0, 5);
				$m  = substr($m, 0, 5);
				$nm = $m -$ma;
				$ns = $s -$sa;
				$nmi = $m -$mi;
				$nsi = $s -$si;
				if($nm < 0)
				{
					$ns -= 1;
					$nm += 1;
				} 
				if($nmi < 0)
				{
					$nsi -= 1;
					$nmi += 1;
				}
				$nm = substr($nm, 2);
				$nmi = substr($nmi, 2);
				$t = "$ns.$nm";
				$tt = "$nsi.$nmi";
				echo " ($t - $tt)";
			}
		}
	}

	function recuperationAssocies($test = False, $return = "", $suite = "") #$test  True se contente d'indiquer s'il existe une base vide ou non. $test  false affiche le formulaire de rcupration.
	{
		if(!$test) echo "\n<//dbut de la rcupration des associs//>";
		
		$sys_tables=$this->get_prolawyer_tables();
		$arr_system_tables = $sys_tables["system"];
		$arr_perso_tables = $sys_tables["partner"];
		$arr_total_tables = array_merge($arr_system_tables, $arr_perso_tables);
	
		$assoc_recup=array();
		$show_tables = @mysql_query("show tables");
		if(! $show_tables) return false;
		while($row=mysql_fetch_array($show_tables))
		{
			$coltosee="Tables_in_".$_SESSION["dbName"];
			$table_cours=trim($row["$coltosee"]);
			foreach($arr_perso_tables as $file => $test_cours)
			{
				$init_prob=substr($table_cours, 0, 2);
				if($init_prob.$test_cours == $table_cours)
				{
					$assoc_recup["$init_prob"]["$test_cours"]=TRUE;
				}
			}
		}
		
		$req="select * from utilisateurs";
		$ex=mysql_query($req);
		while($row=mysql_fetch_array($ex))
		{
			$init=$row["initiales"];
			$compare["$init"]=TRUE;
		}
		$t="";
		$compt = 0;
		if(!$return) $return = $this->rel_file_name;
		foreach($assoc_recup as $init => $type)
		{
			if($assoc_recup[$init]["op"]==TRUE AND $assoc_recup[$init]["clients"]==TRUE AND $compare["$init"] != TRUE)
			{
				$compt ++;
				$t .= "\n<tr><td>{$this->lang["config_modify_init"]}&nbsp;:&nbsp;$init.</td><td>{$this->lang["config_modify_assoc_name"]}</td><td><input type=\"text\" name=\"nom$compt\">";
				$t .= $this->input_hidden("init$compt", "", "$init");
				$t .= "\n</td></tr>";
			}
			
		}
		
		if ($test) return $compt;
		if($t)
		{
			echo "\n<br><br>\n<h3>{$this->lang["config_modify_recup"]}</h3>\n{$this->lang["config_modify_missing_parts"]} :<br>\n<form action=\"{$this->settings["root"]}config/create.php\" method=\"post\">";
			echo $this->table_open("border=0");
			echo $t;
			echo $this->input_hidden("corriger", "", "on");
			echo $this->input_hidden("mode", "", "partner");
			echo $this->input_hidden("return", "", $return);
			echo $this->input_hidden("suite", "", $suite);
			echo "\n<tr><td colspan=\"2\">".$this->button("{$this->lang["config_modify_corriger"]}", "")."</td></tr>";
			echo $this->table_close();
			echo "</form>";
		}
		echo "\n<//fin de la rcupration des associs//>";
		return $compt;
	}
	
}
