<?php
/****
* Titre........... : Fonctions pour la cration de pages web
* Description..... : Ensemble de fonctions pour la mise en place de code HTML  partir de php
* version......... : 4.0
* date............ : 1.3.2010
* fichier......... : functions.class.php
* Auteur.......... : Olivier Subilia (etudeav@users.sourceforge.net)
*
*
* licence......... : The GNU General Public License (GPL) 
*					 http://www.opensource.org/licenses/gpl-license.html
*
****/
		
/*******************************************************************
*
*    class 
*
********************************************************************/

class functions
{
	
	/*Fonctions relatives au systme de fichier*/
	
	
	function open_and_prepare($ftoopen, $ancien_mode=FALSE) //fonction pour lire le fichier, crer un tableau vide s'il n'existe pas et ter les lignes de commentaire
	{
		if(is_file($ftoopen)) 
		{
			$arr=$this->wipe_control(file("$ftoopen"));
		}else{
			$arr=array();
		}
		foreach($arr as $key=>$elem)
		{
			$arr[$key] = trim($elem); //pour ter les fins de ligne
			//echo "<br>$key a pour valeur $elem";
		}
		return $arr;
	}
	
	function close_and_write($arr, $ftoclose, $secure=TRUE, $php=TRUE, $sort=TRUE) //fonction pour crire le fichier en rajoutant les lignes de commentaires
	{
		if($sort) asort($arr);
		if($php) $ins2=array_unshift($arr, "<?php/*");
		if($php) $ins3=array_push($arr, "*/?>");
		$implode=implode($arr, "\n");
		$implode=preg_replace("#\n\n#", "\n", $implode);
		@$file=fopen("$ftoclose", "w+");
		@$write=fwrite($file, "$implode");
		if($secure) $change=@chmod($ftoclose, 0660);
		$close=@fclose($file);
		return $close;
	}
	
	function wipe_array($arr, $string, $needle=",") //fonction pour ter une ligne
	{
		$arr2=$arr;
		foreach($arr as $key => $elem)
		{
			list($first)=explode($needle, $elem);
			if(trim($first)==$string)
			{
				array_splice($arr, $key, 1);
				break;
			}
		}
		return $arr;
	}

	
	function wipe_control($arr) //fonction pour ter les lignes de commentaire et les lignes vides
	{
		$arr=$this->wipe_array($arr, "*/?>");
		$arr=$this->wipe_array($arr, "<?php/*");
		for($x=1;; $x++)
		{
			$arr2=$this->wipe_array($arr, "");
			if($arr2==$arr) break;
			$arr=$arr2;
		}
		return $arr;
	}
	
	function do_post_request($url, $data, $optional_headers = null)
	{
		$params = array
		(
			'http' => array
			(
				'method' => 'POST',
				'content' => $data
			)
		);
		if ($optional_headers !== null)
		{
			$params['http']['header'] = $optional_headers;
		}
		$ctx = stream_context_create($params);
		$fp = @fopen($url, 'rb', false, $ctx);
		if (!$fp)
		{
			throw new Exception("Problem with $url, $php_errormsg");
		}
		$response = @stream_get_contents($fp);
		if ($response === false)
		{
			throw new Exception("Problem reading data from $url, $php_errormsg");
		}
		return $response;
	}
	
	
	//fonctions de cryptographie
	function codage($string, $pass)
	{
		$result="";
		for($x=0, $y=0;;$x++, $y++)
		{
			if($x >= strlen($string)) break;
			if (!substr($pass, $y, 1)) $y=0;
			$char1=substr($string, $x, 1);
			$char2=substr($pass, $y, 1);
			$valtemp=sprintf("%03s",ord($char1) + ord($char2));
			$result=$result.$valtemp;
		}
		return $result;
	}
	
	
	function decodage($string, $pass)
	{
		$result2="";
		for($x=0, $y=0;;$x=$x+3, $y++)
		{
			if($x >= strlen($string)) break;
			if (!substr($pass, $y, 1)) $y=0;
			$char1=substr($string, $x, 3);
			$char2=substr($pass, $y, 1);
			$result2=$result2.chr($char1 - ord($char2));
		}
		return $result2;
	}
	
	function code($string, $pass)
	{
		if($this->settings["crypt_algo"])
		{
			$code = mcrypt_encrypt($this->settings["crypt_algo"], substr($pass, 0, $this->settings["keysize"]), $string, $this->settings["crypt_mode"], $this->settings["iv"]);
			$sericode=serialize(array($code, $this->settings["iv"]));
			$sericode=rawurlencode($sericode);
			return $sericode;

		}
		$codetmp=$this->codage($string, $pass);
		$revpass=strrev($pass);
		$code=$this->codage($codetmp, $revpass);
		return $code;
	}
	
	function decode($string, $pass)
	{
		if(is_array(unserialize($string)))
		{
// 			$this->tab_affiche($this->settings);
			$key=substr($pass, 0, $this->settings["keysize"]);
			$cipher=$this->settings["crypt_algo"];
			$mode=$this->settings["crypt_mode"];
			list($code, $iv) = unserialize($string);
// 			echo "<br>dcodage de l'algorythme '$cipher' avec la cl $key et pour le mode $mode<br>";
			$decode = mcrypt_decrypt($this->settings["crypt_algo"], $key, $code, $mode, $iv);
			return trim($decode);
		}
		elseif(is_array(unserialize(rawurldecode($string))))
		{
// 			$this->tab_affiche($this->settings);
			$key=substr($pass, 0, $this->settings["keysize"]);
			$cipher=$this->settings["crypt_algo"];
			$mode=$this->settings["crypt_mode"];
			list($code, $iv) = unserialize(rawurldecode($string));
// 			echo "<br>dcodage de l'algorythme '$cipher' avec la cl $key et pour le mode $mode (la cl vaut '$iv'<br>";
			$decode = mcrypt_decrypt($this->settings["crypt_algo"], $key, $code, $mode, $iv);
			return trim($decode);
		}
		$revpass=strrev($pass);
		$codetmp=$this->decodage($string, $revpass);
		$decode=$this->decodage($codetmp, $pass);
		return $decode;
	}
	
	
	
	/*Fonctions de gestion des erreurs*/
	
	public function catchError($errMsg, $severity, $index=0)
	{
		$this->errorMsg[$index][$errMsg] = $severity;
		if($severity)     $this->errorContSet[$index] = true;
		if($severity == 4) $this->errorStopSet[$index] = true;
	}
	
	public function isError($level="all", $index = 0)
	{
		if($level == "all" || $level == "stop")
		{
			if($this->errorStopSet[$index]) return true;
		}
		if($level == "all" || $level == "cont")
		{
			if($this->errorContSet[$index]) return true;
		}
		return false;
	}


	public function resetError($level="all", $index = 0)
	{
		if($level == "all" || $level == "stop")
		{
			if($this->errorStopSet[$index])
			{
				unset($this->errorStopSet[$index]);
			}
		}
		if($level == "all" || $level == "cont")
		{
			if($this->errorContSet[$index])
			{
				unset($this->errorContSet[$index]);
			}
		}
		if(isset($this->errorMsg[$index]))
		{
			unset($this->errorMsg[$index]);
		}
	}


	public function echoError($errMsg = "auto", $index=0, $mef = "mefLi")
	{
		$this->errStop = false;
		$this->errCont = false;
		if($errMsg == "noStop") $noStop = true;
		if($errMsg == "auto" || $errMsg == "noStop")
		{
			$arr = $this->errorMsg[$index];
			if(!is_array($arr)) return;
			foreach($arr as $errMsg => $severity) $texte .= $this->echoErrorText($errMsg, $severity, $mef);
		}
		
		else $texte = $this->echoErrorText($errMsg, $severity, $mef);

		if($mef) $texte = "\n<ul>\n\t$texte\n</ul>";
		if($this->errStop && !$noStop) die($texte . "(arrt automatique par le systme en cas d'erreur blocante)");
		return $texte;
	}
	
	public function echoUniqueError($errMsg, $severity, $mef, $noErrCat = False)
	{
		if($noErrCat) $this->noEchoErrCat = True;
		$return = $this->echoErrorText($errMsg, $severity, $mef);
		$this->noEchoErrCat = False;
		return $return; 
	}
	
	private function echoErrorText($errMsg, $severity, $mef)
	{
		if (! $this->noLangRequire)
		{
			$this->getLangFile("err/");
		}
		else
		{
			$root = "./";
			while(!is_file ($root."root.php")) $root .= "../";
			require($root."lang/err/fr.php");
			foreach($langchoisie as $n => $l)
			{
				$this->lang["$n"] = $this->smart_html("$l");
				if(preg_match("#modifier_donnees_societe#", $n))
				{
					$x2 = preg_replace("#modifier_donnees_societe_#", "", $n);
					$this->societes["$x2"] = $this->lang["$n"];
				}
			}
		}
		
		$sevArray = array
		(
			0 => "true",
			1 => "advice",
			2 => "warning",
			4 => "false"
		);

		$sevColors = array
		(
			0 => "#00ff00", //green
			1 => "#ffff00", //yellow
			2 => "#ff8000", //orange
			4 => "#ff0000" //red
		);

		if(preg_match("#^(0)?([0-9]{3}\-[0-9]{3}.*)#", $errMsg, $regs))
		{
			list($errMsg, $inds) = preg_split("#::#", $regs[2]);
			list($errMsg, $reps) = preg_split("/#-#/", $errMsg); //s'il y a un #, cela nettoye la chane
			list($inds, $reps2) = preg_split("/#-#/", $inds ); //s'il y a un #, cela nettoye la chane
			$errname_string="errors_".$errMsg;
			$errcat_string="errors_".substr($errMsg, 0, 3)."-000";
			$errind_string="errors_".substr($errMsg, 0, 3)."-$inds";
			$errString = $this->lang["$errname_string"];
			$errCat    = $this->lang["$errcat_string"];
			$rem=($inds && isset($this->lang["$errind_string"]))? $this->lang["$errind_string"]:"";
			if($repsa=1) //pas certain que ce soit utile de vrifier si reps est utile et non vide. Avant la condition tait "if($reps)"
			{
				$aReps = explode("#", $reps);
				foreach($aReps as $rep)
				{
					$offset = strpos($errString, "{##}");
					if($offset) $errString = substr($errString, 0, $offset). $rep . substr($errString, $offset + 4);
				}
			}
	
			if($inds)
			{
				$aInds = explode("#", $reps2);
				foreach($aInds as $ind)
				{
					$offset = strpos($rem, "{##}");
// 					echo "recherche dans <b>$errString</b> de {##} (trouv  l'offset $offset)<br>";
					if($offset) $rem = substr($rem, 0, $offset). $ind . substr($rem, $offset + 4);
				}
			}
			
	
			if($severity && $regs[1] != "0" && ! $this->noEchoErrCat) $errMsg = /*"{$this->lang["errors_categorie"]}: ".*/"$errCat. $errString.";
			else $errMsg = "$errString.";
		}
		
		$rem2 = $rem ? "<img src=\"{$this->settings["root"]}images/advice.png\" onmouseover = \"show('".addslashes(stripslashes($rem))."')\" onmouseout = \"hide()\">":"";
		if($mef == "mefOnly") $texte = "\n<img src=\"{$this->settings["root"]}images/{$sevArray[$severity]}.png\">$errMsg $rem2";
		elseif($mef == "mefTextOnly") $texte = "\n$errMsg $rem2";
		elseif($mef) $texte = "\n<li style=\"list-style-image : url({$this->settings["root"]}images/{$sevArray[$severity]}.png);\">$errMsg $rem2</li>";
		else $texte = "$errMsg <i>$rem</i>";
		if($severity == 4) $this->errStop = true;
		if($severity)      $this->errCont = true;
		return $texte;
	}
	
	function advice($texte, $img="advice", $add = "")
	{
		if(is_file("{$this->settings["root"]}images/$img.png")) $img = "{$this->settings["root"]}images/$img.png";
		elseif(is_file("{$this->settings["root"]}images/$img")) $img = "{$this->settings["root"]}images/$img";
		elseif(is_file($img)) $img = $img;
		else return "";
		$texte = addslashes(stripslashes($texte));
		return "<img src=\"$img\" onmouseOver = \"show('$texte')\" onmouseout = \"hide()\" $add>";
	}
	
	
	/*Fonctions de texte*/
	
	function smart_html($hval)
	{
		$trans=get_html_translation_table(HTML_SPECIALCHARS);
		$trans = array_flip($trans);
		
		//gestion de l'utf-8
		$hval=$this->smart_utf8($hval);
		$hval2=htmlentities("$hval");
		//attention au codage intempestif des caractres spciaux
		$hval3=strtr("$hval2", $trans);
		return $hval3;
	}
	
	function smart_utf8($hval)
	{
		if(preg_match("##", $hval)) $hval=utf8_decode($hval);
		return $hval;
	}
	
	function no_accent($string)
	{
		$string=strtr($string, "", "aaaaeeeeiiiioooouuuuyycnAAAAEEEEIIIIOOOOUUUUYN");
		return $string;
	}
	
	function liste_ok($liste) //fonction pour lire une liste sans problme
	{
		$n=0;
		$liste_ok="";
		foreach(explode("\n", "$liste") as $val)
		{
			if($n>0 AND trim($val)!="")$liste_ok=$liste_ok."\n";
			$n++;
			$liste_ok=$liste_ok.trim($val);
		}
		return($liste_ok);
	}
	
	function listeArray($liste, $needle=",") //fonction pour lire une liste sans problme
	{
		$array = array();
		foreach(explode("\n", "$liste") as $val)
		{
			if(trim($val)!="")$array[] = preg_split("@$needle@", trim($val));
		}
		return($array);
	}
	
	function make_visible($haystack, $string)
	{
		if(!isset($this->gardefou)) $this->gardefou=0;
		$this->gardefou ++;
		if(is_string($haystack)) $haystack=array($haystack);
		$libellesansaccents=strtolower($this->no_accent($string));
		$libelle=strtolower($string);
		$offset=FALSE;
		$endoffset=FALSE;
		$new=FALSE;
		$restrict="";
		foreach($haystack as $temprestrict) if(trim($temprestrict) != "")
		{
			$temprestrict=strtolower($this->no_accent($temprestrict));
			if (strpos($libellesansaccents, $temprestrict) === FALSE) echo "";
			else
			{
				$tempoffset=strpos($libellesansaccents, $temprestrict);
				$tempendoffset=$tempoffset + strlen($temprestrict);
				if($tempoffset < $offset || $new == FALSE || ($tempoffset == $offset && $tempendoffset > $endoffset))
				{
					$new = TRUE;
					$offset=$tempoffset;
					$endoffset=$tempendoffset;
					$restrict = $temprestrict;
				}
			}
		}
		
		$debut=substr($string, 0, $offset);
		$milieu=substr($string,$offset,strlen($restrict));
		$fin=substr($string, $endoffset);
		
		if($restrict AND $this->gardefou <5) $fin=$this->make_visible($haystack, $fin);
		
		$new_libelle=$this->smart_html("$debut<span class=attention>$milieu</span>$fin");
		$this->gardefou --;
		return $new_libelle;
	}
	
	function nice_array($array, $cols=3, $table="", $tr="", $td="")
	{
		$compteur=0;
		$return = "<table $table>";
		foreach($array as $cell)
		{
			if($compteur == 0) $return .= "\n\t<tr $tr>";
			$return .= "<td $td>$cell</td>";
			$compteur++;
			if($compteur == $cols)
			{
				$compteur = 0;
				$return .= "</tr>";
			}
		}
		if($compteur != $cols) for($x=$compteur;$x<$cols;$x++) $return .= "<td>&nbsp;</td>";
		$return .= "\n<table>";
		return $return;
	}

	function scientifique($vartotest)
	{
		$neg=FALSE;
		if($vartotest<0)
		{
			$vartotest=0-$vartotest;
			$neg=TRUE;
		}
		if($vartotest <1 AND $vartotest >0)
		{
			for($n=1;$vartotest<10;$n++,$vartotest = $vartotest *10)
			{
				if($vartotest>=1)
				{
					$result["mantisse"]=$vartotest;
					$result["exposant"]= 1-$n;
				}
			}
		}
		elseif($vartotest >10)
		{
			for($n=1;$vartotest>=1;$n++,$vartotest = $vartotest / 10)
			{
				if($vartotest<10)
				{
					$result["mantisse"]=$vartotest;
					$result["exposant"]= $n -1;
				}
			}
		}else{
					$result["mantisse"]=$vartotest;
					$result["exposant"]= 0;
		}
		if($neg) $result["mantisse"] = 0 - $result["mantisse"];
		return $result;

	}

	function button($nom="", $accesskey="", $style=""){
		if(preg_match("#<td#", $nom) || preg_match("#<th#", $nom)) //permet de grer correctement les formulaires dans les cellules avec Konqueror
		{	
			if(preg_match("#<td#", $nom))
			{
				$motif="<td";
				$end="</td>";
			}
			if(preg_match("#<th#", $nom))
			{
				$motif="<th";
				$end="</th>";
			}
			$offset=strpos($nom, $motif);
			$td_val=substr($nom, $offset);
			$nom=substr($nom, 0, $offset);
			if(!$nom) $nom = "TODO";
			if($nom == 1) $nom == "";
			$td=TRUE;
		}
		if(preg_match("#<id>#", $accesskey))
		list($accesskey, $id) = preg_split("#<id>#", $accesskey);
		if($accesskey!="")
		{
			$key="accesskey=$accesskey";
			if(!isset($id)) $id=$this->find_accesskey($nom, $accesskey);
		}
		else $key="";
		if($style) $stylekey="class=$style";
		else $stylekey="";
		$string="<button $stylekey type=\"submit\" $key id=\"$id\">$nom</button>";
		if($td) $string = $td_val.$string.$end;
		return $string;
	}
	
	function input_hidden($nom, $idem, $value="", $id="")
	{
		if($idem) $value=$_REQUEST["$nom"];
		if(!$id) $id=$name;
		$string="<input type=\"hidden\" id=\"$id\" name=\"$nom\" value=\"$value\">";
		return $string;
	}

	function input_texte($nom, $idem=FALSE, $value="", $size="10"){
		if(preg_match("#<td#", $nom) || preg_match("#<th#", $nom)) //permet de grer correctement les formulaires dans les cellules avec Konqueror
		{	
			if(preg_match("#<td#", $nom))
			{
				$motif="<td";
				$end="</td>";
			}
			if(preg_match("#<th#", $nom))
			{
				$motif="<th";
				$end="</th>";
			}
			$offset=strpos($nom, $motif);
			$td_val=substr($nom, $offset);
			$nom=substr($nom, 0, $offset);
			$td=TRUE;
		}
		$nomOK=$nom;
		if(preg_match("#\[#", $nom))
		{
			$offset2=strpos($nom, "[");
			$of=substr($nom, $offset2);
			$nom=substr($nom, 0, $offset2);
			$of=substr($of, 1);
			$of=substr($of, 0, -1);
		}
		if(!$id) $id=$nomOK;
		if($idem) $value=$_REQUEST["$nom"];
		if($idem && isset($of)) $value=$_REQUEST["$nom"]["$of"];
// 		echo "<br>nom vaut $nom. of vaut $of. ";
		$string="<input type=\"texte\" name=\"$nomOK\" id=\"$id\" value=\"$value\" size=\"$size\">";
		if($_REQUEST["print"]) $string=$value;
		if($td) $string = $td_val.$string.$end;
// 		echo "<br>string vaut '$string'";
		return $string;
	}

	function input_pwd($nom, $idem=FALSE, $value="", $size="10")
	{
		if($idem) $value=$_REQUEST["$nom"];
		$string="<input type=\"password\" name=\"$nom\" value=\"$value\" size=\"$size\">";
		return $string;
	}

	function form($url, $nom, $accesskey, $style="", $target="", $option1="", $val1="", $option2="", $val2="", $option3="", $val3="", $option4="", $val4="", $option5="", $val5="", $option6="", $val6="", $option7="", $val7="", $option8="", $val8="")
	{
		$keep_val=FALSE;
		if(preg_match("#__liste__#", $url))
		{
			$keep_val=TRUE;
			$url = preg_replace("#__liste__#", "", $url);
			$act_form=array();
			if(!isset($this->arr_forms)) $this->arr_forms=array();
			$act_form["nom"]= $nom;
			$act_form["style"]=$style;
			$act_form["accesskey"]=$accesskey;
		}
		for($x=1;$x<9;$x++)
		{
			$testname="option".$x;
			$testval=$$testname;
			$exclusion[]=$testval;
		}
		if(isset($this->exclusion)) foreach($this->exclusion as $var) $exclusion[]=$var;		
		$string="\n";
		$nom_form=preg_replace("# #", "", $nom);
		$nom_form=preg_replace("#'#", "", $nom_form);
		$nom_form=preg_replace("#&nbsp;#", "", $nom_form); //lorsqu'on a un nom de formulaire automatique pr-trait avec le remplacement par des espaces protgs (cf etude::entete() )
		$td=FALSE;
		if(preg_match("#<td#", $url) || preg_match("#<th#", $url)) //permet de grer correctement les formulaires dans les cellules avec Konqueror
		{	
			if(preg_match("#<td#", $url))
			{
				$motif="<td";
				$end="</td>";
			}
			if(preg_match("#<th#", $url))
			{
				$motif="<th";
				$end="</th>";
			}
			$offset=strpos($url, $motif);
			$td_val=substr($url, $offset);
			$url=substr($url, 0, $offset);
			$td=TRUE;
			if($keep_val) $act_form["url"] = $url;
		}

		if(preg_match("#<td>#", $target)) //oubli de rajouter avant...
		{	
			list($nom_form, $target) = preg_split("#<td>#", $target);
		}

		if($accesskey!="")
		{
			$key="accesskey=$accesskey";
			$nom=$this->find_accesskey($nom, $accesskey);
		}
		else $key="";
		if(trim($target)!="") $targetkey="target=\"$target\"";
		else $targetkey="";
		if($style)
		{
			if(preg_match("#^style#i", $style)) $stylekey = $style;
			else $stylekey="class=\"$style\"";
		}
		else $stylekey="";
		if(!preg_match("#http#", $url)) $url=$this->settings["root"].$url;
		if(!is_file($url) && is_file("$url.php")) $url="$url.php"; 
		if($this->keep_val) $this->arr_forms["$nom_form"]["action"] = $url;
		if($td) $string=$string.$td_val;
		$string=$string."<form style=\"display:inline\" action=\"$url\" name=\"$nom_form\" id=\"$nom_form\" method=\"post\" $targetkey>";
		if($option1!="")
		{
			if(preg_match("#<option#", "$val1")) $string=$string."<select name=\"$option1\">$val1</select>";
			else $string=$string."<input type=\"hidden\" name=\"$option1\" value=\"$val1\">";
			if($keep_val)
			{
				$act_form["option1"] = $option1;
				$act_form["val1"] = $val1;
			}
		}
		for($nx=2;$nx<9;$nx++) //conserver les valeurs du formulaire dans un tableau spar.
		{
			$opname="option".$nx;
			$opx=$$opname;
			$valname="val".$nx;
			$valx=$$valname;
			if($opx!="")
			{
				$string=$string."<input type=\"hidden\" name=\"$opx\" value=\"$valx\">";
				if($keep_val)
				{
					$act_form["$opname"] = $opx;
					$act_form["$valname"] = $valx;
				}
			}
		}
		if(isset($this->form_global_var)) //mettre dans le formulaire les options gnrales, utiles par exemple pour que les pieds de page intgrent automatiquement toutes les variables de page.
		{
			foreach($this->form_global_var as $vkey => $vval)
			{
				if(!in_array($vkey, $exclusion))
				{
					$string .= "<input type=\"hidden\" name=\"$vkey\" value=\"$vval\">";
				}
			}
		}
		if($keep_val) $this->arr_forms[]=$act_form;
		$string=$string."<button $stylekey type=submit $key>$nom</button>";
		if(isset($this->forward_test)) $string .= "<input type=\"hidden\" name=\"last_test\" value=\"{$this->last_test}\">";
		$string=$string."</form>";
		if($td) $string .= $end;
		return $string;
	}

	function table_open($options = "")
	{
		$return="\n";
		if(!isset($this->table_level)) $this->table_level = "0";
		$this->table_level ++;
		for($n=1;$n<$this->table_level; $n++) $return .= "\t";
		$name = (!preg_match("#name#i", $options)) ? "name=\"table_".$this->table_level."\"" : "";
		$return .= "<table $options $name>\n";
		for($n=0;$n<$this->table_level; $n++) $return .= "\t";
		return $return;
	}
	
	function table_close()
	{
		$return = "\n";
		for($n=1;$n<$this->table_level; $n++) $return .= "\t";
// 		$name="table_".$this->table_level;
 		$return .= "</table>\n";
		for($n=1;$n<$this->table_level; $n++) $return .= "\t";
		$this->table_level --;
		return $return;
	}
	
	function find_accesskey($string, $accesskey)
	{
		if(preg_match("#\*#", "$accesskey")) $accesskey="no_key";
		$test=0;
		$suspend = FALSE;
		$string2="";
		for($x=0, $y=0;;$x++, $y++)
		{
			if($x >= strlen($string)) break;
			$char1=substr($string, $x, 1);
			$arr=array($accesskey, strtolower($accesskey), strtoupper($accesskey));
			foreach ($arr as $val)
			{
				//echo "'$accesskey'<br>";
				if($char1 == "&") $suspend=TRUE;
				if(!$suspend) $char2=preg_replace("#$val#", "<u>$val</u>", "$char1");
				else $char2 = $char1;
				if($char1 == ";") $suspend=FALSE;
				if($char1!=$char2 AND $test==0)
				{
					$test=1;
					$char1=$char2;
					break;
				}
			}
			$string2=$string2.$char1;
		}
		return $string2;
	}

	function color_select($onclick="", $onmouseover="", $choisi="", $id="", $id2="", $escape=TRUE, $referer=FALSE, $submit=FALSE)
	{
		$choisi=trim($choisi);
		if(!preg_match("/#/", $choisi)) $choisi = "#".$choisi;	
		$choisi=strtoupper($choisi);
		if($referer) $width="100%";
		else $width="40";
		$string="<table width=\"$width\" border=1 cellspacing=0 cellpading=0>\n\t<tr>";
		for($r=0, $g=0, $b=0, $compteur = 1; $r < 5; $b++, $compteur ++)
		{
			if($b == 5)
			{
				$b=0;
				$g ++;
			}
			if($g == 5)
			{
				$g=0;
				$r ++;
			}
			$color["cur"]="#";
			$color["ccur"]="#";
			foreach(array("cur", "ccur") as $etat)
			{
				if($etat == "cur")
				{
					$array=array($r, $g, $b);
				}else{
					$array=array(4-$r, 4-$g, 4-$b);
					foreach($array as $rang =>$val)
					{
						if($val == "2") $array["$rang"] = "0";
					}
				}
				foreach($array as $cur)
				{
					if($cur <3) $color["$etat"] .= 4 * $cur;
					elseif($cur == 3) $color["$etat"] .= "C";
					elseif($cur == 4) $color["$etat"] .= "FF";
					if($cur != 4) $color["$etat"] .= "0";
				}
			}
		if($onmouseover)
		{
			if($escape) $onover="onMouseover=\"show(\\'{$color["cur"]}\\')\" onMouseout=\"hide()\"";
			else $onover="onMouseover=\"show('{$color["cur"]}')\" onMouseout=\"hide()\"";
		}
		if($onclick)
		{
			$add_submit=($submit) ? ";window.opener.document.getElementById('$submit').submit()" : "";
			if(!$referer) $oncli = "onClick=\"hideandselect(\\'{$color["cur"]}\\')\"";
			else $oncli = "onClick=\"window.opener.document.getElementById('$referer').value='{$color["cur"]}';window.opener.document.getElementById('$referer').style.backgroundColor='{$color["cur"]}'$add_submit;self.close()\"";
		}
		else $onover="";
		if($color["cur"] == $choisi)
		{
			$texte="<li>x</li>";
//			echo "tralala";
		}
//		else $texte=$color["cur"];
		else $texte="&nbsp;&nbsp;";
//		$string .= "<td color = \"{$color["ccur"]}\" bgcolor = \"{$color["cur"]}\" $onover $oncli>$texte</td>";
		if($color["cur"] == $choisi) $string .= "<td style=color:{$color["cur"]};background-color:{$color["ccur"]};font-size:5;cursor:pointer $onover $oncli>$texte</td>";
		else $string .= "<td style=color:{$color["ccur"]};background-color:{$color["cur"]};font-size:8;cursor:pointer $onover $oncli>$texte</td>";
		if($compteur == 25)
		{
			$compteur = 0;
			$string .= "</tr>\n\t<tr>";
		}
		if($color["cur"] == "#FFFFFF") break;
		}
		$string .= "</tr>\n</table>";
	return $string;
	}

	
	function qui_fait_quoi($np="", $nple="", $mp="", $mple="", $date_format="%c")
	{
		$nple=($nple && $nple != "0000-00-00")?$this->mysql_to_print("$nple", "%d.%m.%Y"):"";
		$mple=($mple && $mple != "0000-00-00")?$this->mysql_to_print("$mple", "%d.%m.%Y"):"";
/*		if($np!="") $np="{$this->lang["general_np"]} $np";
		if($mp!="") $mp="{$this->lang["general_mp"]} $mp";
		if($nple!="") $nple=" ($nple)";
		if($mple!="") $mple=" ($mple)";
		if($np !="" AND $mp !="") $semicolon=" ; ";
		$texte=$np.$nple.$semicolon.$mp.$mple;*/
		$options_infobulle="onMouseover=\"shi('$np','$nple','$mp','$mple')\" onMouseout=\"hide()\"";
		return $options_infobulle;
	}

	

	//divers
	function univ_strftime($param, $time="") //hlas, il y a des gens qui utilisent cette cochonnerie de windows qui ne gre pas une bonne partie des options de strftime...
	{
		$temp_percent="temppourcent";
		$return="";
		if(!$time) $time=time();
		$idem=array("a","A","b","B","c","d","H","I","j","m","M","p","S","s", "U","W","w","x","X","y","Y","Z","z");
		$param=preg_replace("#%%#", $temp_percent, $param);
		$arr_param = explode("%", $param);
		foreach($arr_param as $line)
		{
			if(trim($line) != "")
			{
				$lparam=trim(substr($line, 0, 1));
				if(in_array($lparam, $idem))
				{
					$return .= strftime("%$lparam", $time);
				}
				elseif($lparam == "C")
				{
					$annee = strftime("%Y", $time);
					$ansim = strftime("%y", $time);
					if(substr($ansim, 0, 1) == "0") $ansim = substr($ansim, 1);
					if(substr($ansim, 0, 1) == "0") $ansim = substr($ansim, 1);
					$soustr = $annee - $ansim;
					$soustr = ($annee - fmod($annee, 100)) / 100;
					$return .= $soustr;
					
				}
				elseif($lparam == "D")
				{
					$return .= strftime("%m/%d/%y", $time);
					
				}
				elseif($lparam == "e")
				{
					$day=strftime("%d", $time);
					if($day < 10) $day = " ".substr($day, 1);
					$return .= $day;
					
				}
				elseif($lparam == "h")
				{
					$return .= strftime("%b", $time);
					
				}
				elseif($lparam == "n")
				{
					$return .= "\n";
					
				}
				elseif($lparam == "r")
				{
					$m = "AM";
					$heure = strftime("%H", $time);
					$minute = strftime("%M", $time);
					$seconde = strftime("%S", $time);
					if($heure > 12)
					{
						$heure = $heure -12;
						$m = "PM";
					}
					if($heure == "12") $m = "PM";
					if($heure == "00")
					{
						$heure = "12";
					}
					$return .= "$heure:$minute:$seconde $m";
				}
				elseif($lparam == "R")
				{
					$return .= strftime("%H:%M", $time);
					
				}
				elseif($lparam == "T")
				{
					$return .= strftime("%H:%M:%S", $time);
					
				}
				elseif($lparam == "t")
				{
					$return .= "\t";
					
				}
				elseif($lparam == "V")
				{
					$return .= strftime("%U", $time);
					
				}
				elseif($lparam == "u")
				{
					$jnum = strftime("%w", $time);
					if($jnum == 0) $jnum = 7;
					$return .= $jnum;
					
				}else{
					$return .= "";
				}
				$return .= substr($line, 1);
			}
		}
		$return=preg_replace("#$temp_percent#", "%", $return);
// 		$return = trim($return);
		if(preg_match("##", $return)) $return=utf8_decode($return);
		return $return; 
	}
	
	function tab_affiche($arr="RienDeDefini", $sup="", $level=0) //fonction de contrle plus jolie (retours  la ligne, indentation) que print_r
	{
		if($this->do_return && $level ==0) $this->ret="";
		if($arr==="RienDeDefini" || $arr === 0)
		{
			$arr=$_POST;
			echo "<br><b>POST values: </b>";
		}
		if($arr === 1)
		{
			$arr=$_GET;
			echo "<br><b>GET values: </b>";
		}
		if($arr === 2)
		{
			$arr=$_SESSION;
			echo "<br><b>SESSION values: </b>";
		}
		if($arr === 3)
		{
			$arr=$_COOKIE;
			echo "<br><b>COOKIE values: </b>";
		}
		if($arr === 4)
		{
			$arr=$_REQUEST;
			echo "<br><b>REQUEST values: </b>";
		}
		if($arr === "?" || $arr === "help" || $arr === "aide")
		{
			echo "<br><b>USAGE: </b>\n<br>0 => POST\n<br>1 => GET\n<br>2 => SESSION\n<br>3 => COOKIE";
			return;
		}
		if(!is_array($arr) && $level == 0)
		{
			
			return ;
		}
		foreach($arr as $key=>$elem)
		{
			if($this->do_return) $plustab = "   ";
			else $plustab = "&nbsp;&nbsp;&nbsp;";
			$tab="";
			for($compt=0;$compt<$level;$compt++) $tab .= $plustab;
			if(is_array($elem)) {
				if($this->do_return) $this->ret .= "\n$tab $sup [$key] a pour valeur '[$key]'";
				else echo "\n<br>$tab $sup [$key] a pour valeur '[$key]'";
				$elem=ksort($arr[$key]);
				$oldsup=$sup;
				$sup .= " [$key]";
				$level++;
				$this->tab_affiche($arr[$key], $sup, $level);
				$level--;
				$sup=$oldsup;
			}
			else
			{
				if($this->do_return) $this->ret .= "\n$tab $sup [$key] a pour valeur '$elem'";
				else echo "\n<br>$tab $sup [$key] a pour valeur '$elem'";
			}
		}
		if($level == 0)
		{
			if($this->do_return)
			{
				$this->ret .= "\n";
				return $this->ret;
			}
			else echo "\n<br><br>";
		}
	}
	
	function mysql_to_print($mysql_date, $date_format="%d.%m.%Y")
	{
		list($annee_n, $mois_n, $jour_n)=preg_split("#-#", $mysql_date);
		$tmstmp_n=mktime(0, 0, 0, $mois_n, $jour_n, $annee_n);
		$date_print=strftime("$date_format", $tmstmp_n);
		$date_print=strftime("%x", $tmstmp_n);
		return $date_print;
	}
	
	function mtf_date($date = "") //$date format= yyyy-mm-date
	{
		if($date != "")
		{
			list($year, $month, $day) = preg_split("#-#", $date);
			$timestamp=mktime(1, 0, 0, $month, $day, $year);
		}
		else $timestamp = time();
		return $timestamp;
	}
	
	function split_date($date, $nom="", $nomjour="", $nommois="", $nomannee="")
	{
		if(preg_match("#<td#", $date) || preg_match("#<th#", $date)) //permet de grer correctement les formulaires dans les cellules avec Konqueror
		{	
			if(preg_match("#<td#", $date))
			{
				$motif="<td";
				$end="</td>";
			}
			if(preg_match("#<th#", $date))
			{
				$motif="<th";
				$end="</th>";
			}
			$offset=strpos($date, $motif);
			$td_val=substr($date, $offset);
			$date=substr($date, 0, $offset);
			$td=TRUE;
		}
		if(!$id) $id=$name;
		if($nomjour == "") $nomjour = "jour".$nom;
		if($nommois == "") $nommois = "mois".$nom;
		if($nomannee== "") $nomannee= "annee".$nom;
/*		$jour=substr($date, 8, 2);
		$mois=substr($date, 5, 2);
		$annee=substr($date, 0, 4);*/
		list($annee, $mois, $jour) = preg_split("#-#", $date);
		if($date == "POST")
		{
			//vrification des donnes introduites

			$anneeI = $_POST["annee$nom"];
			$moisI = $_POST["mois$nom"];
			$jourI = $_POST["jour$nom"];
                        if($jourI && $moisI && $anneeI)
                        {
                                if(!is_array($this->autoDates)) $this->autoDates = array();
                                $this->autoDates["$nom"] = array("m" => "$anneeI-$moisI-$jourI");
                        }
			if(!$anneeI) $anneeI=0;
			if(!$moisI) $moisI=0;
			if(!$jourI) $jourI=0;

			$d=mktime(1, 0, 0, $moisI, $jourI, $anneeI);
			$annee=$this->univ_strftime("%Y", $d);
			$jour=$this->univ_strftime("%d", $d);
			$mois=$this->univ_strftime("%m", $d);

			if($mois != $moisI || $jour != $jourI || $annee != $anneeI)
			{
				$this->dateErrors["$nom"] = true;
				$mois=$moisI;
				$jour=$jourI;
				$annee=$anneeI;
			}
		}
		$string="\n<input onfocus=select() name=\"$nomjour\" id=\"$nomjour\" value=\"$jour\" size=\"2\">&nbsp;<input onfocus=select() name=\"$nommois\" id=\"$nommois\" value=\"$mois\" size=\"2\">&nbsp;<input onfocus=select() name=\"$nomannee\" id=\"$nomannee\" value=\"$annee\" size=\"4\">";
		if($_POST["print"]) $string="$jour.$mois.$annee";
		if($string == "..") $string = "";
		if($td) $string = $td_val.$string.$end;
		return $string;
	}

	function split_time($time, $nom="", $nomheure="", $nomminute="")
	{
		if($nomheure == "") $nomheure = "heure".$nom;
		if($nomminute == "") $nomminute = "minute".$nom;
		list($heure, $minute)=preg_split("#:#", $time);
		$string="\n<input onfocus=select() name=\"$nomheure\" id=\"$nomheure\" value=\"$heure\" size=\"2\">&nbsp;<input onfocus=select() name=\"$nomminute\" id=\"$nomminute\" value=\"$minute\" size=\"2\">";
		if($_POST["print"]) $string="$heure:$minute";
		return $string;
	}
	
	function checkDate($d1, $mois = "POST", $annee=0)
	{
		if($mois === "POST" || $mois === "GET" || $mois === "REQUEST")
		{
			if($mois == "POST") $val = $_POST;
			if($mois == "GET") $val = $_GET;
			if($mois == "REQUEST") $val = $_REQUEST;
			$jour  = $val["jour$d1"];
			$mois  = $val["mois$d1"];
			$annee = $val["annee$d1"];
		}
		else $jour = $d1;
		
		if(strlen($annee) == 3) return false;

		$q = "select date_add('$annee-$mois-$jour', interval 0 day) as d";
		$e = mysql_query($q);
		while ($r = mysql_fetch_array($e)) list($anneeCom, $moisCom, $jourCom) = preg_split("/-/", $r["d"]);
// 		print "<br>$jour.$mois.$annee: $jourCom.$moisCom.$anneeCom";
		if($jour + 0 == 0 && $mois + 0 == 0 && $annee + 0 == 0) return -1;
		elseif($jour + 0 == $jourCom + 0 && $mois + 0 == $moisCom + 0 && $annee + 0 == $anneeCom + 0) return 1;
		else return 0;
	}
	
	function getImageName($name, $compPath=false)
	{
		$name = html_entity_decode($name);
		$name = $this->no_accent($name);
		$name = preg_replace("#\'#", "_", $name);
		$name = preg_replace("# #", "_", $name);
		#if($compPath) $name = "{$this->settings["root"]}images/auto/$name.png";
		if($compPath) $name = "{$this->settings["root"]}/images/auto/$name.png";
		return($name);
	}
	
	function getClickableItem($design, $val)
	{
		if(preg_match("/^(tel|natel|fax)/", $design))
		{
			$prefix = "";
			$val = preg_replace("#[^0-9+]#", "", $val);
			if(!$val)
			{
				$class = "";
				$sup = "<img src=\"{$this->settings["root"]}images/empty.png\">";
			}
			elseif($val && strlen($val) <10)
			{
				$class = "class=\"attention\"";
				$sup = "<span><img src=\"{$this->settings["root"]}images/empty.png\"></span>";
			}
			else
			{
				$valSansPlus = preg_replace("/^\+/", "00", $val);
				$class = "style=\"cursor:pointer\" onclick=\"XHR = new XHRConnection();data='callback';XHR.appendData(data, 'on');XHR.appendData('number', '$valSansPlus');XHR.appendData('path', '..');XHR.appendData('ip', '{$_SERVER["REMOTE_ADDR"]}');XHR.appendData(div, 'on');div='img{$design}';XHR.sendAndLoad( '{$this->settings["root"]}redirect.php', 'GET', remplirChamp)\"";
				$sup = "<span id=\"img{$design}\"><img src=\"{$this->settings["root"]}images/telr.png\"></span>";
			}
			if(substr($val, 0, 1) != "+" && substr($val, 0, 2) != "00" && strlen($val) == 10) $val = substr($val, 0, 3) . " / " .substr($val, 3, 3) . " " . substr($val, 6, 2) . " " . substr($val, 8, 2);
			elseif(preg_match("/^(\+|00)([0-9]+)/", $val, $reg))
			{
				$val = "+" . $reg[2];
				$indicatifs = array
				(
					"1",
					"7",
					"20",
					"27",
					"30",
					"31",
					"32",
					"33",
					"34",
					"36",
					"39",
					"40",
					"41",
					"43",
					"44",
					"45",
					"46",
					"47",
					"48",
					"49",
					"51",
					"52",
					"53",
					"54",
					"55",
					"56",
					"57",
					"58",
					"60",
					"61",
					"62",
					"63",
					"64",
					"65",
					"66",
					"81",
					"82",
					"84",
					"86",
					"90",
					"91",
					"92",
					"93",
					"94",
					"95",
					"98"
				);
				foreach($indicatifs as $indicatif) if(preg_match("/(\+$indicatif)([0-9]+)/", $val, $reg))
				{
					$prefix .= $reg[1];
					$val = $reg[2];
					$pasTrois = true;
					break;
				}
				if(!$pasTrois)
				{
					preg_match("/(\+[0-9]{3})([0-9]+)/", $val, $reg);
					$prefix .= $reg[1];
					$val = $reg[2];
				}
				
				if($prefix == "+33") $val = preg_replace("/([0-9]{1})([0-9]{2})([0-9]{2})([0-9]{2})([0-9]{2})/", "$prefix \\1 \\2 \\3 \\4 \\5", $val);
				else
				{
					$string = $val;
					$val = "$prefix";
					for($x=0;$x<strlen($string) + 2; $x +=3)
					{
						$val .= " " . substr($string, $x, 3);
					}
				}
			}

		}
		elseif(preg_match("/^mail/", $design))
		{
			$sup = $val ? "<a href=\"mailto:$val\"><img style=\"border:none\" valign=bottom src=\"{$this->settings["root"]}images/courriel.png\"></a>":"<img src=\"{$this->settings["root"]}images/empty.png\">";
		}
		elseif($design == "nosociete")
		{
			$sup = $val ? "<a href=\"#\" onClick=\"window.open('{$this->settings["root"]}modules/recherche/zefix.php?norc=$val','modifier','width=400,height=400,toolbar=no,directories=no,menubar=no,location=no,status=no,resizable=yes,scrollbars=yes')\"><img style=\"border:none\" valign=bottom src=\"{$this->settings["root"]}images/rc.png\"></a>":"<img src=\"{$this->settings["root"]}images/empty.png\">";
// 			$sup = $val ? "<a href=\"{$this->settings["root"]}modules/recherche/zefix.php?norc=$val\" target=\"_new\"><img style=\"border:none\" valign=bottom src=\"{$this->settings["root"]}images/rc.png\"></a>":"<img src=\"{$this->settings["root"]}images/empty.png\">";
		}
		
		$val = $this->smart_html($val);
		
		$return["sup"] = $sup;
		$return["val"] = strtr($val, chr(146), "'");
		$return["class"] = $class;
		return $return;
	}

	function mimeGet($file)
	{
		$m = "";
		preg_match("#\.([^.]+$)#", $_POST["fichier"], $reg);
		$ext = $reg[1];
		if($ext == "txt") $m = "text/plain";
		elseif($ext == "rtf") $m = "text/rtf";
		elseif($ext == "odt") $m = "application/vnd.oasis.opendocument.text";
		elseif($ext == "ott") $m = "application/vnd.oasis.opendocument.text-template";
		elseif($ext == "sxw") $m = "application/vnd.sun.xml.writer";
		elseif($ext == "stw") $m = "application/vnd.sun.xml.writer.template";
		if($m) return $m;
		if(function_exists(finfo_file) && function_exists(finfo_open))
		{
			$i = finfo_open(FILEINFO_MIME_TYPE);
			$m = finfo_file($i, $file);
			if ($m && $m != "application/octet-stream") return $m;
		}
		if(function_exists(mime_content_type))
		{
			$m = mime_content_type($file);
			if($m && $m != "application/octet-stream") return $m;
		}
	}

	
}
