<?php class calendarnew extends prolawyer
/****
* Titre........... : Classe Agenda
* Description..... : Ensemble de fonctions pour la mise en place d'un calendrier / todo list
* version......... : 3.0
* date............ : 30.6.2005
* fichier......... : document.class.php
* Auteur.......... : Olivier Subilia (etudeav@users.sourceforge.net)
*
* remarques ...... : Cette classe s'appuie sur les classes functions.class.php et document.class.php, qui doivent avoir t requises avant l'ouverture de la prsente. Mais elle peut tre utilise sans le cadre propos par la classe Etude (document.class.php) pourvu que les fonctions et les fichiers de configuration crs automatiquement par cette classe soient accessibles.
calendar.class.php va rechercher dans le rpertoire de configuration un fichier avocats.php dont la structure doit tre la suivante:

NomDeLaBase1,initiales1,user1=DroitsSurLaBase1;user2=DroitsSurLaBase1;user3=DroitsSurLaBase1,...
NomDeLaBase12,initiales1,user1=DroitsSurLaBase2;user2=DroitsSurLaBase2;user3=DroitsSurLaBase2,...
NomDeLaBase13,initiales1,user1=DroitsSurLaBase3;user2=DroitsSurLaBase3;user3=DroitsSurLaBase3,...
...

* licence......... : The GNU General Public License (GPL) 
*					 http://www.opensource.org/licenses/gpl-license.html
*
****/
		
/*******************************************************************
*
*    class 
*
********************************************************************/
{	
	function calendarnew($agendaSolo=false)
	{
		$this->cal_mode=TRUE;
		$this->agendaSolo = $agendaSolo;
		parent::__construct();
		$this->date_jour 	= 	$this->univ_strftime("%Y-%m-%d");
		$this->time 		= 	time();
		if(!isset($dbt_jour)) $this->dbt_jour="06:00";
		if(!isset($fin_jour)) $this->fin_jour="22:00";
		if(!isset($interval_rdv)) $this->interval_rdv=15;
		
		$this->titleAddons = array("<script type=\"text/javascript\" src=\"./externe/XHRConnection.js\"></script>", "<script type=\"text/javascript\" src=\"./js/calendar.js\"></script>");
		if($_REQUEST["type"] == "jour") $this->titleAddons[] = "<script type=\"text/javascript\" src=\"./externe/libdeplace.js\"></script>";
		
		$this->registerLocale();
		$this->liste_utilisateurs();
		$this->lColors();
		
		//variables de document
		if($this->anchor == "ra") $this->dest = "ra.php";
		elseif($this->anchor == "ra_new") $this->dest = "ra_new.php";
		else $this->dest = "agendanew.php";
		if(!isset($_POST["date_cours"]) AND isset($_POST["jour_cours"]) AND isset($_POST["mois_cours"]) AND isset($_POST["annee_cours"])) $_POST["date_cours"] = "{$_POST["annee_cours"]}-{$_POST["mois_cours"]}-{$_POST["jour_cours"]}";
		if(!isset($_POST["date_cours"])) $_POST["date_cours"] = $this->univ_strftime("%Y-%m-%d", time());
		
		if(!isset($_POST["type"]) || !$_POST["type"]) $_POST["type"] = ($this->getCookie("pda"))? "jour": "mois";
		$this->liste_personne="";
		$this->liste_soustraitant="";
		if(isset($_POST["soustraitant"])) if(is_array($_POST["soustraitant"])) foreach($_POST["soustraitant"] as $nom) $this->liste_soustraitant .= "$nom,";
		if(isset($_POST["groups"])) if(is_array($_POST["groups"])) foreach($_POST["groups"] as $nom) $_POST["personne"][] = $nom;
		if(isset($_POST["personne"]))
		{
			$this->utilisateursgroupes=$this->liste_utilisateursgroupes_ex();
// 			$this->tab_affiche($this->utilisateursgroupes);
			$deja_note=array(); //pour viter qu'une personne qui se trouve dans plusieurs groupes apparaisse plusieurs fois
			if(is_array($_POST["personne"]))
			{
				foreach($_POST["personne"] as $nom)
				{
					if(preg_match("#\*\*\*group\*\*\*#", $nom))
					{
						$nudename=preg_replace("#\*\*\*group\*\*\*#", "", $nom);
						foreach($this->utilisateursgroupes["$nudename"] as $val)
						{
							if(trim($val) != "")
							{
								$val=trim($val);
								if(!in_array($val, $deja_note))
								{
									$this->liste_personne .= "$val,";
									$deja_note[] = $val;
								}
							}
						}
					}else{
						if(!in_array($nom, $deja_note))
						{
							$this->liste_personne .= "$nom,";
							$deja_note[] = $nom;
						}
					}
				}
// 				$this->tab_affiche($deja_note);
//  				echo $this->liste_personne;
				$this->setCookie("liste_personne",$this->liste_personne);
				
			}
		}
		elseif($this->getCookie("liste_personne") !== false)
		{
			$this->liste_personne=$this->getCookie("liste_personne");
		}
		if($this->liste_personne == "") 
		{
			if($this->getSinglePersoOption("agenda")) $this->liste_personne = $this->getSinglePersoOption("agenda");
			elseif(isset($_SESSION["session_avdb"])) $this->liste_personne = substr($_SESSION["session_avdb"],0,2);
			else $this->liste_personne = "nobody";
		}
		
		if($_POST["persReload"]) $this->liste_personne = $_POST["persReload"];
		
		if($_POST["template"]) $this->setCookie("template",$_POST["template"]);
		elseif($this->getCookie("template") !== false)
		{
			$_POST["template"] = $this->getCookie("template");
		}
		else
		{
			$this->setCookie("template", "agenda");
			$_POST["template"] = "agenda";
		}
		
		if($_POST["faits"]!="on")
		{
			$this->faits_check = "";
		}else {
			$this->faits_check = "checked";
		}
		if($agendaSolo) die($this->display_multi($agendaSolo, $_POST["date_cours"], FALSE, $this->liste_personne));

	}
	
	function liste_rdv($restrict="", $personne="")
	{
		$debut_mysql = ($_POST["debut"] <> "") ? $_POST["debut"] : "0";
		if($_POST["print"]!="on") $limite_nombre="limit $debut_mysql,{$_SESSION["nb_affiche"]}";
		
		if($personne == "")
		{
			$clause = "rdv_pour like ''";
		}else{
			$this->liste_utilisateursgroupes_revert();	
			$this->liste_utilisateursgroupes_ex();	
			$compteur=1;
			$array1=preg_split("#,#", $personne);
			$array_clause = array();
			foreach($array1 as $n) if(trim($n) != "")
			{
				if(!in_array($n, $array_clause)) $array_clause[] = $n;
				if(is_array($this->liste_des_utilisateursgroupes_revert["$n"])) foreach($this->liste_des_utilisateursgroupes_revert["$n"] as $grp) if(!in_array("_$grp", $array_clause)) $array_clause[] = "_$grp";
				if(substr(trim($n), 0, 1) == "_")
				{
					$grp = substr(trim($n), 1);
					foreach($this->liste_des_utilisateursgroupes_ex[$grp] as $member) if(!in_array($member, $array_clause)) $array_clause[] = $member;
				}
			}
			
			foreach ($array_clause as $gugusse)
			{
				if(trim($gugusse) != "")
				{
					$gugusse = trim($gugusse);
					if($compteur == 1) $clause = "rdv_pour like '%$gugusse%'";
					else $clause .= " OR rdv_pour like '%$gugusse%'";
					$compteur ++;
				}
			}
		}
		
		$compteur=1;
		$array_limitation=preg_split("# #", $restrict);
		foreach ($array_limitation as $gugusse)
		{
			if(trim($gugusse) != "")
			{
				if($compteur == 1) $limitation = "libelle like '%$gugusse%'";
				else $limitation .= " AND libelle like '%$gugusse%'";
				$compteur ++;
			}
		}
		
		$limitation = $limitation ? "($limitation) AND":"";
		
		if($_POST["typerecherche"]=="agenda")
		{
		
			if($_POST["limiterecherche"])
			{
				foreach(array("Debut", "Fin") as $moment)
				{
					if($_POST["jourrecherche$moment"] && $_POST["moisrecherche$moment"] && $_POST["anneerecherche$moment"])
					{
						$jour = $_POST["jourrecherche$moment"];
						$mois = $_POST["moisrecherche$moment"];
						$annee = $_POST["anneerecherche$moment"];
						$comp = ($moment == "Debut") ? "(date_debut >= '$annee-$mois-$jour' OR (date_debut like '0000-00-00' AND date_fin >= '$annee-$mois-$jour'))":"date_fin <= '$annee-$mois-$jour'";
						$limitation = $limitation ? "$limitation $comp AND":"$comp AND";
					}
				}
			}
			
			$query0="select * from rdv where $limitation ($clause)";
			$exec0=mysql_query($query0);
			$stop_mysql = mysql_num_rows($exec0);
			$query="select * from rdv where $limitation ($clause) ORDER BY date_debut, date_fin $limite_nombre";
// 			echo "<br>$query";
			$exec=mysql_query($query);
			if(mysql_num_rows($exec)) echo "<h2>{$this->lang["agenda_title"]}</h2>";
			echo $this->table_open();
			while($row=mysql_fetch_array($exec))
			{
				$this->dejaTrouve=array();
				$couls=$this->table_open("border=\"0\" cellspacing=\"0\" cellpadding=\"0\"");
				$couls .="<tr>";
				$qqn=FALSE;
				foreach(explode(",", $row["rdv_pour"]) as $value)
				{
					$value = trim($value);
					if(substr($value, 0, 1) == "_")
					{
						$gName = substr($value, 1);
						$groupes = $this->liste_utilisateursgroupes_ex();
						foreach($groupes["$gName"] as $part) if(!in_array($part, $this->dejaTrouve)) $this->dejaTrouve[] = $part;
							
					}
					elseif($value != "" && !in_array($value, $this->dejaTrouve)) $this->dejaTrouve[] = $value;
				}
				foreach($this->dejaTrouve as $value)
				{
					$init=substr($value, 0, 2);
					$actColor = trim($this->liste_des_utilisateurs["$init"]["couleur"]);
					if(!$actColor) $actColor = "#ffffff";
					$couls .= "<td align=\"center\" class=\"$classtexte\" style=\"background-color:$actColor;color:000000\">$init</td>";
					$qqn=TRUE;
				}
				if($qqn==FALSE)
				{
					$init="";
					$couls .= "<td align=\"center\">??</td>";
				}
				$couls .= "</tr>";
				$couls .= $this->table_close();
				
				//$id="form".$row["id"];
				if($row["biffe"]) $row["libelle"] = "<del>{$row["libelle"]}</del> <span class=\"attention\">{$this->lang["agenda_annule"]}</span>";
				$new_libelle = $row["libelle"];
				$new_libelle = $this->make_visible($array_limitation, $new_libelle);
				$date_debut=$this->univ_strftime("%d.%m.%Y", $this->mtf_date($row["date_debut"]));
				$heure_debut=substr($row["heure_debut"], 0, -3);
				//$form = $this->form("modifier_rdv.php", "", "", "$classtexte", "$id<td>", "id", $row["id"]);

				echo "\n<tr style=\"cursor:pointer\" onclick=\"openRdv('{$row["id"]}')\"><td>$date_debut&nbsp;($heure_debut)&nbsp;:</td><td>$couls</td><td>$new_libelle</td><td>$form</td></tr>";//." (offsets: $offset et $endoffset";
			}
			echo $this->table_close();
			echo $this->footer($debut_mysql, $stop_mysql);
		}
		
		if($_POST["typerecherche"]=="delais")
		{
		
// 			$this->tab_affiche();
			if($_POST["limiterecherche"])
			{
				foreach(array("Debut", "Fin") as $moment)
				{
					if($_POST["jourrecherche$moment"] && $_POST["moisrecherche$moment"] && $_POST["anneerecherche$moment"])
					{
						$jour = $_POST["jourrecherche$moment"];
						$mois = $_POST["moisrecherche$moment"];
						$annee = $_POST["anneerecherche$moment"];
						$comp = ($moment == "Debut") ? "date_fin >= '$annee-$mois-$jour'":"date_fin <= '$annee-$mois-$jour'";
						$limitation = $limitation ? "$limitation $comp AND":"$comp AND";
					}
				}
			}
			
			if(!$_POST["faits"])
			{
				$limitation = $limitation ? "$limitation fait not like 'on' AND":"fait not like 'on' AND";
			}
			$clause=preg_replace("#rdv_pour#", "dl_pour", $clause);
// 			echo "<br>$clause";
			$query0="select * from delais where $limitation ($clause)";
			$exec0=mysql_query($query0);
			$stop_mysql = mysql_num_rows($exec0);
			$query="select * from delais where $limitation ($clause) ORDER BY date_fin $limite_nombre";
			$exec=mysql_query($query);
			if(mysql_num_rows($exec)) echo "<h2>{$this->lang["entete_delais"]}</h2>";
// 			echo "<br>$query";
			echo $this->table_open();
			while($row=mysql_fetch_array($exec))
			{
				$couls=$this->table_open("border=\"0\" cellspacing=\"0\" cellpadding=\"0\"");
				$couls .="<tr>";
				$qqn=FALSE;
				foreach(explode(",", $row["dl_pour"]) as $value)
				{
					if(trim($value) != "")
					{
						$init=substr($value, 0, 2);
						$actColor = trim($this->liste_des_utilisateurs["$init"]["couleur"]);
						if(substr($value, 0, 1) == "_")
						{
							$init= substr($value, 1);
							$actColor = "ff0000";
						}
						if(!$actColor) $actColor = "#ffffff";
						$couls .= "<td align=\"center\" class=\"$classtexte\" style=\"background-color:$actColor;color:000000\">$init</td>";
						$qqn=TRUE;
					}
				}
				if($qqn==FALSE)
				{
					$init="";
					$couls .= "<td align=\"center\">??</td>";
				}
				$couls .= "</tr>";
				$couls .= $this->table_close();
				
				//$id="form".$row["id"];
				if($row["biffe"]) $row["libelle"] = "<del>{$row["libelle"]}</del> <span class=\"attention\">{$this->lang["agenda_pas_faire"]}</span>";
				$new_libelle = $row["libelle"];
				$new_libelle = $this->make_visible($array_limitation, $new_libelle);
				$date_debut=$this->univ_strftime("%d.%m.%Y", $this->mtf_date($row["date_fin"]));
				//$form = $this->form("modifier_delai.php", "", "", "$classtexte", "$id<td>", "id", $row["id"]);

				echo "\n<tr style=\"cursor:pointer\"><td onclick=\"openDl('{$row["id"]}')\">$date_debut&nbsp;:</td><td onclick=\"openDl('{$row["id"]}')\">$couls</td><td onclick=\"openDl('{$row["id"]}')\">$new_libelle</td><td onclick=\"openDl('{$row["id"]}')\">$form</td><td style=\"text-align:right;padding-right:10\"><a class=\"duplicate\" name=\"#\" onclick=\"copyDl('{$row["id"]}')\">[+]</a></td></tr>";//." (offsets: $offset et $endoffset";
			}
			echo $this->table_close();
			echo $this->footer($debut_mysql, $stop_mysql);
		}
	}
	
	function display_vacation($date="", $personne="")
	{
		
		//variables
			
		$date=$this->mtf_date($date);//atention: display_vacation est appele directement, donc avec une date de type mysql. Corriger.
		$year = $this->univ_strftime("%Y", $date);
		$array_verif=array();
		
		//gestion de la clause where relative  la personne
		if($personne == "")
		{
			$clause = "rdv_pour like ''";
//			echo "rat";
		}else{
			$this->liste_utilisateursgroupes_revert();	
			$this->liste_utilisateursgroupes_ex();	
		
			$compteur=1;
			$array1=preg_split("#,#", $personne);
			$array = array();
			$array2 = array();
			foreach($array1 as $n) if(trim($n) != "")
			{
				if(!in_array($n, $array)) $array[] = $n;
				if(!in_array($n, $array2)) $array2[] = $n;
				if(is_array($this->liste_des_utilisateursgroupes_revert["$n"])) foreach($this->liste_des_utilisateursgroupes_revert["$n"] as $grp) if(!in_array("_$grp", $array)) $array[] = "_$grp";
				if(substr(trim($n), 0, 1) == "_")
				{
					$grp = substr(trim($n), 1);
					foreach($this->liste_des_utilisateursgroupes_ex[$grp] as $member)
					{
						if(!in_array($member, $array)) $array[] = $member;
						if(!in_array($member, $array2)) $array2[] = $member;
					}
				}
			}

			//construction de la requte
			foreach ($array as $gugusse)
			{
				if(trim($gugusse) != "")
				{
					$gugusse = trim($gugusse);
					if($compteur == 1) $clause = "rdv_pour like '%$gugusse%'";
					else $clause .= " OR rdv_pour like '%$gugusse%'";
					$compteur ++;
				}
			}
		}
		
		$max=$this->univ_strftime("%j", mktime(5,5,5,12,31,$year));
		foreach($array as $gugusse) for($x=1;$x<($max + 1);$x++) $days["$x"]["$gugusse"] = 0;
		
		//construction de la requte
		$mdate=$this->univ_strftime("%Y-%m-%d", $date);
		$debutdate=$this->univ_strftime("%Y-1-1", $date);
		$findate=$this->univ_strftime("%Y-12-31", $date);
		$mjour=$this->univ_strftime("%d", $date);
		$mmois=$this->univ_strftime("%m", $date);
		$mannee=$this->univ_strftime("%Y", $date);
		$manneemois=$this->univ_strftime("%Y%m", $date);
		
		//en cas d'affichage par semaine ou mois, il faut afficher tous les rendez-vous
		if($type == "jour")
		{
			$semaine_mois = "AND (heure_debut <'{$this->fin_jour}:00' OR date_debut <> '$mdate') 
		AND (heure_fin >'{$this->dbt_jour}:00' OR date_fin <> '$mdate')";
		}else{
			$semaine_mois = "";
		}
		$query="select 
		*, date_format(date_debut, '%e') AS jour_debut, 
		date_format(date_debut, '%m') AS mois_debut, 
		date_format(date_debut, '%w') AS jour_semaine, 
		'$mdate' as debut_jour,
		adddate('$mdate', datediff(date_fin, date_debut)) AS fin_jour,
		adddate(date_debut, 7 * floor(datediff('$mdate', date_debut) / 7)) AS debut_semaine,
		adddate(date_fin, 7 * floor(datediff('$mdate', date_debut) / 7)) AS fin_semaine,
		adddate(date_debut, INTERVAL period_diff('$manneemois', date_format(date_debut, '%Y%m')) month) AS debut_mois,
		adddate(adddate(date_debut, INTERVAL period_diff('$manneemois', date_format(date_debut, '%Y%m')) month), datediff(date_fin, date_debut)) AS fin_mois,
		adddate(date_debut, INTERVAL 12 * floor(period_diff('$manneemois', date_format(date_debut, '%Y%m'))/12) month) AS debut_annee,
		adddate(adddate(date_debut, INTERVAL 12 * floor(period_diff('$manneemois', date_format(date_debut, '%Y%m'))/12) month), datediff(date_fin, date_debut)) AS fin_annee
		from rdv 
		where 
		(
			(
			date_debut <= '$findate' AND date_fin >= '$debutdate' AND repete like '')
			OR (date_debut <= '$mdate' AND (adddate(repete_fin, datediff(date_fin, date_debut)) >= '$mdate' OR repete_fin  like '0000-00-00' OR repete_fin like '') AND 
				(
					repete like 'j' 
					OR repete like 's' AND '$mdate' BETWEEN adddate(date_debut, 7 * floor(datediff('$mdate', date_debut) / 7)) AND adddate(date_fin, 7 * floor(datediff('$mdate', date_debut) / 7)) 
					OR repete like 'm' AND '$mdate' BETWEEN adddate(date_debut, INTERVAL period_diff('$manneemois', date_format(date_debut, '%Y%m')) month) AND adddate(adddate(date_debut, INTERVAL period_diff('$manneemois', date_format(date_debut, '%Y%m')) month), datediff(date_fin, date_debut))
					OR repete like 'a' AND '$mdate' BETWEEN adddate(date_debut, INTERVAL 12 * floor(period_diff('$manneemois', date_format(date_debut, '%Y%m'))/12) month) AND adddate(adddate(date_debut, INTERVAL 12 * floor(period_diff('$manneemois', date_format(date_debut, '%Y%m'))/12) month), datediff(date_fin, date_debut))
				)
			)
		)
		$semaine_mois
		AND (rdv_pour like '%$pers%')
		AND ($clause)
		AND (type like 'vacances')
		order by date_debut, heure_debut, heure_fin";
		
// 		echo nl2br($query);
		$exec=mysql_query($query);
		$amArray = array();
		while($row=mysql_fetch_array($exec))
		{
			list($year_start, $month_start, $day_start) = preg_split("#-#", $row["date_debut"]);
			list($year_end, $month_end, $day_end) = preg_split("#-#", $row["date_fin"]);
			$date_debut=($year_start < $year)? "$year-1-1" : "$year_start-$month_start-$day_start";
			$date_fin=($year_end > $year)? "$year-12-31" : "$year_end-$month_end-$day_end";
			list($year_start, $month_start, $day_start) = preg_split("#-#", $date_debut);
			list($year_end, $month_end, $day_end) = preg_split("#-#", $date_fin);
			
			$monthArray = array();
			foreach($array as $gugusse) if(preg_match("#$gugusse#", $row["rdv_pour"]))
			{
				if(substr(trim($gugusse), 0, 1) == "_")
				{
					$grp = substr(trim($gugusse), 1);
					foreach($this->liste_des_utilisateursgroupes_ex[$grp] as $member)
					{
						if(!in_array($member, $amArray)) $amArray[] = $member;
						if(!in_array($member, $monthArray)) $monthArray[] = $member;
					}
				}
				else
				{
					if(!in_array($gugusse, $amArray)) $amArray[] = $gugusse;
					if(!in_array($gugusse, $monthArray)) $monthArray[] = $gugusse;
				}
			
			}
			foreach($monthArray as $gugusse)
			{
//  				print "<br>+$gugusse";
				if(!in_array($gugusse, $array_verif)) $array_verif[]= $gugusse;
				$debut=$this->univ_strftime("%j", $this->mtf_date($date_debut));
				$fin=$this->univ_strftime("%j", $this->mtf_date($date_fin));
				for($x=$debut;$x<$fin+1;$x++)
				{
					$x+=0;
					$days[$x][$gugusse]=$row["id"];
				}
			}
		}
		
// 		$this->tab_affiche($amArray);
		
		$y=1;
		for($x=1;$x<13;$x++)
		{
			$test=($x==12)? $this->univ_strftime("%j", mktime(5,5,5,12,31,$year)) +1:($this->univ_strftime("%j", mktime(5,5,5,$x+1,1,$year)));
			for($z=1;$y<$test;$y++,$z++) $vacances["$x"]["$z"] = $days[$y];
		}
		
		
		$tableau = "";
		$tableau .= "<form action=\"./agendanew.php \" name=\"change1\" method=\"post\">";
		$tableau .= $this->table_open();
		$tableau .= "<tr><td>";
		$tableau .= $this->input_hidden("date_cours", 1);
		$tableau .= $this->input_hidden("template", 1);
		$tableau .= $this->input_hidden("type", 1);
		$tableau .= $this->button("{$this->lang["apropos_pour"]}&nbsp;->", "", "semaine_entete");
		$tableau .= "</td></tr><tr><td>";
		$tableau .= "<select multiple name=\"personne[]\" size=\"6\" class=\"semaine\">";
		$tableau .= $this->selecteur($_SESSION["session_utilisateur"], TRUE, FALSE, FALSE, $this->liste_personne, TRUE, $groups);
		$tableau .= "</select></td><td>";
		$tableau .= "<select multiple name=\"personne[]\" size=\"6\" class=\"semaine\">";
		$tableau .= $this->selecteur($_SESSION["session_utilisateur"], TRUE, FALSE, FALSE, $this->liste_personne, TRUE, TRUE, TRUE);
		$tableau .= "</select></td></tr>";
		$tableau .= $this->table_close();
		$tableau .= "</form>";
		
		$tableau .= $this->table_open();
		$tableau .= "<tr>".$this->form("agendanew.php<th colspan=16 align=right>","[-]", "", "menu", "", "template", "agenda", "type", "vacances", "date_cours", $year - 1 ."-1-1")."<th colspan=6>".$this->univ_strftime("%Y", mktime(5,5,5,1,1,$year))."</th>".$this->form("agendanew.php<th colspan=16 align=left>","[+]", "", "menu", "", "template", "agenda", "type", "vacances", "date_cours", $year + 1 ."-1-1")."</tr>";
		$cur_month=0;
		for($x=1;$x<13;$x++)
		{
			//test de l'existence de chaque personne dans le mois
			foreach($amArray as $gugusse) 
			{
// 				print "<br>$gugusse";
				$test_mois[$x][$gugusse]=FALSE;
				foreach($vacances[$x] as $jour => $personne)
				{
// 	 				echo "<br>vacances [$x][$jour] [$personne]";
					if($vacances[$x][$jour][$gugusse]>0)
					{
// 						print "$gugusse";
						$test_mois[$x][$gugusse]=$personne;
					}
				}
			}
			
			//criture du tableau, ligne par ligne selon les personnes
			
			$linestyle=(2 * floor($x /2) == $x)? "ligneplan1":"ligneplan2";
			
// 			$this->tab_affiche($test_mois);
// 			echo "tralala";
			$first_line = FALSE;
			$array3=$array2;
			$array3[] = "blankcontrol";
			$this->lcolor_all["blankcontrol"] = "e0e0e0";
			$this->color_all_all["blankcontrol"] = "c0c0c0";
			$rowspan=0;
			foreach($array2 as $pers) if($test_mois[$x][$pers]) $rowspan ++;
			if($rowspan == 0) $rowspan = 1;
			foreach($array3 as $nom => $gugusse2) if($test_mois[$x][$gugusse2] || ($gugusse2 == "blankcontrol" && $first_line == FALSE))
			{
				if(!$first_line) $add=$this->form("agendanew.php<td rowspan = \"$rowspan\">", $this->univ_strftime("%B", mktime(5,5,5,$x,1,$year)), "", "$linestyle", "",  "template", "agenda", "date_cours", "$year-$x-1");
				else $add="";
				$first_line = TRUE;
				$tableau .= "<tr class=\"$linestyle\">$add";
				for($k=1;$k<$this->univ_strftime("%u", mktime(5,5,5,$x,1,$year));$k++) $tableau .= "<td>&nbsp;</td>";
				foreach($vacances["$x"] as $jour => $val)
				{
					$valeur = $vacances[$x][$jour][$gugusse2];
					$color = ($valeur > 0)? $this->liste_des_utilisateurs["$gugusse2"]["couleur"]/*$this->color_all["$gugusse2"]*/:$this->color_all_all["blankcontrol"];
					$test_we=$this->univ_strftime("%u", mktime(5,5,5,$x,$jour,$year));
					if($test_we>5)
					{
						$color = ($valeur > 0) ? $this->liste_des_utilisateurs["$gugusse2"]["lCouleur"]:$this->lcolor_all["blankcontrol"];
					}
					$tableau .= $valeur ? "<td bgcolor=$color><a style=\"cursor:pointer;color:000000\" name=\"#\" onclick=\"openRdv('$valeur')\">$jour</a></td>":"<td bgcolor=$color>$jour</td>";
				}
				for($k=1;$k<39 -$this->univ_strftime("%u", mktime(5,5,5,$x,1,$year)) - $jour;$k++) $tableau .= "<td>&nbsp;</td>";
				$tableau .= "</tr>";
			}
		}
		
		$tableau .= $this->table_close();
		
		$tableau .= "<br><br>".$this->table_open()."\n<tr>";
		foreach($array_verif as $gugusse) $tableau .="<td style=\"border-color:000000;border-style:solid;border-width:1\" bgcolor=\"{$this->liste_des_utilisateurs["$gugusse"]["couleur"]}\">&nbsp;&nbsp;&nbsp;</td><td>$gugusse</td><td>&nbsp;</td>";
		$tableau .= "</tr>".$this->table_close();
		return $tableau;
	}
	
	function display_day($date="", $class="", $type="", $personne="", $preload=False)
	{
// 		echo "<br>appel de display_day pour $date";
		$mdate=$this->univ_strftime("%Y-%m-%d", $date);
		$mjour=$this->univ_strftime("%d", $date);
		$mmois=$this->univ_strftime("%m", $date);
		$mannee=$this->univ_strftime("%Y", $date);
		$manneemois=$this->univ_strftime("%Y%m", $date);
		
		//en cas d'affichage par semaine ou mois, il faut afficher tous les rendez-vous
		if($type == "jour")
		{
			$semaine_mois = "AND (heure_debut <'{$this->fin_jour}:00' OR date_debut <> '$mdate') 
		AND (heure_fin >'{$this->dbt_jour}:00' OR date_fin <> '$mdate')";
		}else{
			$semaine_mois = "";
		}
	
		//gestion de la clause where relative  la personne
		if($this->clause) $clause = $this->clause;
		elseif($personne == "")
		{
			$clause = "rdv_pour like ''";
			$this->clause = $clause;
		}else{			
			$this->liste_utilisateursgroupes_revert();	
			$this->liste_utilisateursgroupes_ex();	
		
			$compteur=1;
			$array1=preg_split("#,#", $personne);
			$array = array();
			foreach($array1 as $n) if(trim($n) != "")
			{
				if(!in_array($n, $array)) $array[] = $n;
				if(is_array($this->liste_des_utilisateursgroupes_revert["$n"])) foreach($this->liste_des_utilisateursgroupes_revert["$n"] as $grp) if(!in_array("_$grp", $array)) $array[] = "_$grp";
				if(substr(trim($n), 0, 1) == "_")
				{
					$grp = substr(trim($n), 1);
					if(is_array($this->liste_des_utilisateursgroupes_ex[$grp])) foreach($this->liste_des_utilisateursgroupes_ex[$grp] as $member) if(!in_array($member, $array)) $array[] = $member;
				}
			}

			//construction de la requte
			foreach ($array as $gugusse)
			{
				if(trim($gugusse) != "")
				{
					$gugusse = trim($gugusse);
					if($compteur == 1) $clause = "rdv_pour like '%$gugusse%'";
					else $clause .= " OR rdv_pour like '%$gugusse%'";
					$compteur ++;
				}
			}
			$this->clause = $clause;
			$this->arrGugusses = $array;
		}
				
		
		//-------------cration du tableau des rendez-vous--------------
		$actuel=$this->dbt_jour;
		$liste_plages=array();
		$liste_plages["$actuel"] = array("dbt" => array(), "fin" => array(), "nb" => "0");
		$jo = $this->univ_strftime("%d", $date);
		$mo = $this->univ_strftime("%m", $date);
		$an = $this->univ_strftime("%Y", $date);
		list($he_comp_dbt,$mi_comp_dbt) = preg_split("#:#", $this->dbt_jour);
		list($he_comp_fin,$mi_comp_fin) = preg_split("#:#", $this->fin_jour);
		$se="00";
		$timestamp_ref=mktime($he_comp_fin, $mi_comp_fin, $se, $mo, $jo, $an);

		for($x=1;$x<120;$x++)
		{
			list($he,$mi) = preg_split("#:#", $actuel);
			$se="00";
			$jo = $this->univ_strftime("%d", $date);
			$mo = $this->univ_strftime("%m", $date);
			$an = $this->univ_strftime("%Y", $date);
			$timestamp_actuel=mktime($he, $mi, $se, $mo, $jo, $an);
			$new_timestamp_actuel = $timestamp_actuel + (60 *$this->interval_rdv);
			$new_actuel=$this->univ_strftime("%H:%M", $new_timestamp_actuel);
			if($new_timestamp_actuel >= $timestamp_ref) break;
			$liste_plages["$new_actuel"] = array("dbt" => array(), "fin" => array(), "nb" => "0");
			$actuel=$new_actuel;
		}
//		$this->tab_affiche($liste_plages);
		
		$classtexte=$class."texte";
		if($date == "") $date = time();
		else $date = $this->mtf_date($date);
		$aDate = $this->univ_strftime("%Y-%m-%d", $date);
		$return=$this->table_open("width=\"100%\" height=100% border=0 valign=top cellspacing=0 cellpadding=0 id=\"framejour_$aDate\" class=\"$classtexte\"")."<tr valign=top><td>";
		$return .= $this->table_open("width=\"100%\" border=0 valign=top");
		$form = $this->form("{$this->dest}", $this->univ_strftime("%a", $date)."&nbsp;".$this->univ_strftime("%d", $date), "", "nomjourmois", "", "date_cours", $this->univ_strftime("%Y-%m-%d", $date), "type", "jour");
		$nouvelle_date_cours=$this->univ_strftime("%Y-%m-%d", $date);
		//$form2 = $this->form("modifier_rdv.php<td>", "+", "", "delai_seul", "", "date_cours", $this->univ_strftime("%Y-%m-%d", $date), "nouveau", "on", "personne", $personne);
		$return .= "<tr><td class = \"$classtexte\" colspan=2>";
		if($class == "dujour") $return .= "<a name=today></a>";
		$return .= $this->table_open("class=\"$classtexte\" cellspacing=\"0\" cellpadding=\"0\" border=0 valign=top");
		$return .= "<tr><td>$form</td>	<td>&nbsp;</td><td class=\"delai_seul\" style=\"cursor:pointer;color:#0000ff\" onclick=\"newRdv('$nouvelle_date_cours', '{$this->dbt_jour}', '$personne')\">&nbsp;+&nbsp;</td></tr>";
		$return .= $this->table_close();
		$return .= "</td></tr>";
		
		//construction de la requte
		
		$mdate=$this->univ_strftime("%Y-%m-%d", $date);
		$mjour=$this->univ_strftime("%d", $date);
		$mmois=$this->univ_strftime("%m", $date);
		$mannee=$this->univ_strftime("%Y", $date);
		$manneemois=$this->univ_strftime("%Y%m", $date);
		
		//en cas d'affichage par semaine ou mois, il faut afficher tous les rendez-vous
		if($type == "jour")
		{
			$semaine_mois = "AND (heure_debut <'{$this->fin_jour}:00' OR date_debut <> '$mdate') 
		AND (heure_fin >'{$this->dbt_jour}:00' OR date_fin <> '$mdate')";
		}else{
			$semaine_mois = "";
		}
		
		$mTime=time() - 1284450000 + microtime();
		if($this->lTime) $eTime = $mTime -$this->lTime;
		if(! $this->calendarDays)
		{
			$bmdate=$this->fBegDay;
			$emdate=$this->fEndDay;
			print "<br>$mdate, $bmdate, $emdate";
		//TODO: qqs lignes aprs: AND 0 supprime les rptitions.
			$query="select 
			*, date_format(date_debut, '%e') AS jour_debut, 
			date_format(date_debut, '%m') AS mois_debut, 
			date_format(date_debut, '%w') AS jour_semaine,
			case type when 'anniversaire' then 0 when 'vacances' then 1 else 2 end as subclass 
			from rdv 
			where 
			(
				(
				date_debut <= '$mdate' AND date_fin >= '$mdate' AND repete like '')
				OR (date_debut <= '$mdate' AND (adddate(repete_fin, datediff(date_fin, date_debut)) >= '$mdate' OR repete_fin  like '0000-00-00' OR repete_fin like '') AND 1 AND 
					(
						repete like 'j' 
						OR repete like 's' AND '$mdate' BETWEEN adddate(date_debut, 7 * floor(datediff('$mdate', date_debut) / 7)) AND adddate(date_fin, 7 * floor(datediff('$mdate', date_debut) / 7)) 
						OR repete like 'm' AND '$mdate' BETWEEN adddate(date_debut, INTERVAL period_diff('$manneemois', date_format(date_debut, '%Y%m')) month) AND adddate(adddate(date_debut, INTERVAL period_diff('$manneemois', date_format(date_debut, '%Y%m')) month), datediff(date_fin, date_debut))
						OR repete like 'a' AND '$mdate' BETWEEN adddate(date_debut, INTERVAL 12 * floor(period_diff('$manneemois', date_format(date_debut, '%Y%m'))/12) month) AND adddate(adddate(date_debut, INTERVAL 12 * floor(period_diff('$manneemois', date_format(date_debut, '%Y%m'))/12) month), datediff(date_fin, date_debut))
					)
				)
			)
			$semaine_mois
			AND (($clause) or lieu not like '')
			order by date_debut, subclass, heure_debut, heure_fin";
	// 		echo nl2br(preg_replace("/\t/", "&nbsp;&nbsp;&nbsp;&nbsp;", "<br>$query"));
	//		$query="select *from rdv where (date_debut <= '".$this->univ_strftime("%Y-%m-%d", $date)."' AND date_fin >= '".$this->univ_strftime("%Y-%m-%d", $date)."') AND (heure_debut <'{$this->fin_jour}:00' OR date_debut <> '".$this->univ_strftime("%Y-%m-%d", $date)."') AND (heure_fin >'{$this->dbt_jour}:00' OR date_fin <> '".$this->univ_strftime("%Y-%m-%d", $date)."') AND rdv_pour like '%$pers%' AND ($clause) order by date_debut, heure_debut, heure_fin";
			global $testrepet;
	// 		if(!$testrepet) echo "<br>$query";
			$testrepet= TRUE;
			$this->now[] = microtime() . ": Dbut de l'excution de mysql_query";
			$exec=mysql_query($query);
			$this->now[] = microtime() . ": Fin de l'excution de mysql_query";
		}
		$this->lTime = time() -1284450000 + microtime();
		$lTime = $this->lTime;
		//echo "<br>Avant: $mTime. Aprs: $lTime. Temps d'excution de la requte: ", $lTime -$mTime, " secondes. ";
		//if($eTime) echo "Dernier temps d'excution: $eTime";
		$formulaires=array();
		$this->now[] = microtime() . ": Dbut de l'excution de mysql_fetch_array (agenda)";
		while($row=mysql_fetch_array($exec))
		{
			//gestion des anniversaires
			if($row["type"] == "anniversaire")
			{
				$row["heure_debut"] = "00:00";
				$row["heure_fin"]   = "00:00";
			}
		//transformation des rendez-vous rpts comme tant des rendez-vous du jour en question
			foreach(array("j" => "jour", "s" => "semaine", "m" => "mois", "a" => "annee") as $init => $nom_complet)
			{
				if($row["repete"] == $init)
				{
					$dnom= "debut_".$nom_complet;
					$fnom= "fin_".$nom_complet;
					$row["date_debut"] = $row["$dnom"];
					$row["date_fin"] = $row["$fnom"];
				}
			}
//			echo "<br>{$row["jour"]},{$row["mois"]},{$row["jour_semaine"]}";
			$row["heure_debut"] = substr($row["heure_debut"], 0, -3);
			$row["heure_fin"] = substr($row["heure_fin"], 0, -3);
			if($row["date_debut"] != $this->univ_strftime("%Y-%m-%d", $date)) $row["heure_debut"] = "00:00";
			if($row["date_fin"] != $this->univ_strftime("%Y-%m-%d", $date)) $row["heure_fin"] = "23:59";
			list($hd, $md) = preg_split("#:#", $row["heure_debut"]);
			list($hf, $mf) = preg_split("#:#", $row["heure_fin"]);
			$comp_dbt=60 * $he_comp_dbt + $mi_comp_dbt;
			$comp_fin=60 * $he_comp_fin + $mi_comp_fin;
			$test_dbt=60 * $hd + $md;
			$test_fin=60 * $hf + $mf;
			if($test_dbt < $comp_dbt)
			{
//			echo "tradebut";
				$hd=$he_comp_dbt;
				$md=$mi_comp_dbt;
			}
			if($test_fin > $comp_fin)
			{
//			echo "trafin";
				$hf=$he_comp_fin;
				$mf=$mi_comp_fin;
			}
			$armd=$this->interval_rdv * floor($md / $this->interval_rdv);
			if($armd == 0) $armd = "00";
			$arrondi_dbt="$hd:".$armd;
			$min_arr_dbt=60*$hd + $armd;
			$armf=$this->interval_rdv * floor(($mf -1) / $this->interval_rdv);
			if($armf == (0 - $this->interval_rdv))
			{
				$armf = 60 - $this->interval_rdv;
				$hf --;
			}
			if($armf == 0) $armf = "00";
			if($armf < 10) $armf = "0".$armf;
			$armf=preg_replace("#00#", "0", $armf);
			if($hf < 10) $hf = "0".$hf;
			$hf=preg_replace("#00#", "0", $hf);
			$arrondi_fin="$hf:".$armf;
			$min_arr_fin=60*$hf + $armf;
//			echo "<br>$arrondi_dbt-$arrondi_fin, soit $min_arr_dbt - $min_arr_fin ($test_dbt, $comp_dbt; $test_fin, $comp_fin)";
			
			//-----------cration des icnes de personnes---------
			$couls=$this->table_open("border=\"0\" cellspacing=\"0\" cellpadding=\"0\"");
			$couls .="<tr><td>$spL<table><tr>";
			$qqn=FALSE;
			$nb_part=-1;
			$coul_deja_note=array();
			if($row["lieu"])
			{
				$pourMoi = false;
				foreach($this->arrGugusses as $g) if(preg_match("/\b$g\b/", $row["rdv_pour"])) $pourMoi = True;
				if($pourMoi) $couls  .=  "<td><img src=\"images/lieu.png\" onmouseover=\"javascript:show(' ".$this->smart_html($row["lieu"])."')\" onmouseout=\"hide()\"></td>";
				else $couls .= "<td><img src=\"images/lieu.png\"></td>";
				$nb_parts ++;
			}
			if($row["type"])
			{
				$couls .= "<td><img src=\"images/{$row["type"]}.png\"></td>";
				$nb_part ++;
			}
			foreach(explode(",", $row["rdv_pour"]) as $value) if($row["type"] != "anniversaire")
			{
				$value=trim($value);
				if(trim($value) != "" && !in_array($value, $coul_deja_note))
				{
					$nb_part ++;
					if($nb_part == 3)
					{
						$couls .= "</tr><tr>";
						$nb_part = 0;
					}
					if(substr($value, 0, 1) == "_")
					{
						$init= substr($value, 1);
						$tCol = "ff0000";
					}else{
						$init = substr($value, 0, 2);
						$tCol = "000000";
					}
					$actColor = $this->liste_des_utilisateurs["$init"]["couleur"];
					if(!$actColor) $actColor = "#ffffff";
					$couls .= "<td align=\"center\" class=\"$classtexte\" style=\"background-color:$actColor;color:$tCol\">$init</td>";
					$qqn=TRUE;
					$coul_deja_note[]=$value;
				}
			}
			if($qqn==FALSE && $row["type"] != "anniversaire")
			{
				$init="";
				$couls .= "<td align=\"center\">??</td>";
			}
			if(trim($row["priorite"]) == "") $row["priorite"] = "&nbsp;";
			$couls .= "</tr></table></td><td style=\"background-color:ffffff\">{$row["priorite"]}</td></tr>";
			$couls .= $this->table_close();
/*			echo "<br><br>************************<br>";
			echo nl2br(htmlentities(nl2br($couls)));*/
			//-----fin de cration des icnes de personnes---------
			
			
			$row["libelle"] = $this->smart_html($row["libelle"]);
			if($row["lieu"] && !$pourMoi) $row["libelle"] = "<i>{$this->lang["agenda_lieu_occupe"]}&nbsp;: {$row["lieu"]}</i>";
			if($row["biffe"]) $row["libelle"] = "<del>{$row["libelle"]}</del> <span class=\"attention\">{$this->lang["agenda_annule"]}</span>";
			$id="id-".$row["id"].$this->univ_strftime("%Y-%m-%d", $date);
			$id=preg_replace("#-#", "", $id);
//			$texte="<a class=button href=# onclick=\"$id.submit()\">{$row["heure_debut"]}-{$row["heure_fin"]}:{$row["libelle"]}</a>";
			$form3 = $this->form("modifier_rdv.php", "", "", "$classtexte", "$id<td>modif", "id", $row["id"]);
			list($heuredebut, $minutedebut) = preg_split("#:#", $row["heure_debut"]);
			list($heurefin, $minutefin) = preg_split("#:#", $row["heure_fin"]);
			$form4 = "<form action = \"./maj_op.php\" method = \"post\" id = \"submit$id\" class = \"$classtexte\"><td>
			<input type = \"hidden\" name = \"id\" value = \"{$row["id"]}\">
			<input type = \"hidden\" name = \"heure_debut\" id = \"heuredebut$id\" value=\"$heuredebut\">
			<input type = \"hidden\" name = \"heure_fin\" id = \"heurefin$id\" value=\"$heurefin\">
			<input type = \"hidden\" name = \"minute_debut\" id = \"minutedebut$id\" value=\"$minutedebut\">
			<input type = \"hidden\" name = \"minute_fin\" id = \"minutefin$id\" value=\"$minutefin\">";
/*			<input type = \"text\" name = \"minutefin\" id = \"minutefin$id\" value=\"$minutefin\">
			<input type = \"text\" name = \"minutefin\" id = \"minutefin$id\" value=\"$minutefin\">";*/
			$form4 .= $this->input_hidden("retour", "", "agendanew");
			$form4 .= $this->input_hidden("date_cours", 1);
			$form4 .= $this->input_hidden("type", 1);
			$form4 .= "</td></form>";
// 			$formulaires[]=$form3;
//			echo "<br>".htmlentities($couls);
// 			$return .= "<tr><td>$couls</td><td class=$classtexte onclick=\"$id.submit()\">{$row["heure_debut"]}-{$row["heure_fin"]}:{$row["libelle"]}</td><td>$form3</td></tr>";
			$onmouseover=$this->qui_fait_quoi($row["np"], $row["nple"], $row["mp"], $row["mple"]);
			$spClass = $row["type"] ? "class=\"$class"."vacances\"":"";
			$liste_simple["$id"]="{$row["heure_debut"]}/@{$row["heure_fin"]}/@{$row["libelle"]}/@$form3/@$couls/@{$row["id"]}/@$onmouseover/@$spClass/@{$row["type"]}";
//			$liste_plages["$arrondi_dbt"]["dbt"][]=$id;
			$liste_plages["$arrondi_dbt"]["dbt"]["$id"]=($min_arr_fin - $min_arr_dbt)/$this->interval_rdv + 1;
			$liste_plages["$arrondi_fin"]["fin"]["$id"]=1;
			$divid="div".$id;
			$tdid="td".$id;
			$noanniv = ($row["type"] != "anniversaire")? "<span id=\"plage$id\">{$row["heure_debut"]}-{$row["heure_fin"]}</span>:":"";
			$liste_id["$id"]=$this->table_open("width=\"100%\" border=0 cellspacing=0 cellpadding=0 style=\"height:toereg\"") ."<tr><td>$couls</td><td class=$classtexte $onmouseover><a $spClass href=\"#\" onclick=\"openRdv('{$row["id"]}');drag=false\">$noAnniv{$row["libelle"]}</td><td>$form3 $form4</td><td style=\"text-align:right;padding-right:10\"><a class=\"duplicate\" name=\"#\" onclick=\"copyRdv('$click3')\">[+]</a></td><td style=\"cursor:move;background-color:d0d0d0\" align=center width=40 onmousedown=\"dragPiece(document.getElementById('$divid'),'$id');document.getElementById('$tdid').className='attention_bg'\" onmouseup=\"drop()\"><img src=\"./images/move.png\" height=\"16\" width=\"16\"/></tr>".$this->table_close();
		}
		$this->now[] = microtime() . ": Fin de l'excution de mysql_fetch_array";
		
		//rcupration des rendez-vous pour le mois ou la semaine
		if(is_array($liste_simple)) 
		{
			asort($liste_simple);
			foreach($liste_simple as $id => $texte_partiel)
			{
				list($aDeb, $aFin, $libelle, $form3, $couls, $click3, $onmouseover, $spClass, $anni) = preg_split("#/@#", $texte_partiel);
				$libelle = ( $anni == "anniversaire")? $libelle : "$aDeb-$aFin:$libelle";
				
				//$return .= "<tr><td>$couls</td><td class=$classtexte onclick=\"$id.submit()\">$libelle</td><td>$form3</td></tr>";
				$return .= "<tr><td>$couls</td><td class=$classtexte $onmouseover ><a $spClass name=\"#\" onclick=\"openRdv('$click3')\">$libelle</a></td><td><a class=\"duplicate\" name=\"#\" onclick=\"copyRdv('$click3')\">[+]</a></td></tr>";
			}
		}
		
		$return .= $this->table_close();
		$return .= "</td></tr>";
		$return .= "<tr height=100%><td>&nbsp;</td></tr>";
		$this->now[] = microtime() . ": Dbut de l'excution de display_dl";
		$return .= "<tr width=100% valign=bottom><td>".$this->display_dl("=", $mdate, $personne, "abrege")."</td></tr>";
		$this->now[] = microtime() . ": Fin de l'excution de display_dl";
		$return .= $this->table_close();
// 		foreach ($formulaires as $singleform) $return .= $singleform;
		$liste_ghost=$liste_plages;
		$actuel=0;
		$retard=0;
		$new_retard=0;
		$max_rdv=0;
		foreach($liste_ghost as $plage => $df)
		{
			$lastnext=$next;
			$next=0;
			foreach($liste_ghost["$plage"] as $df => $offset)
			{
				if(is_array($liste_ghost["$plage"]["$df"]))
				{
					foreach($liste_ghost["$plage"]["$df"] as $offset => $val)
					{
						if($df == "dbt") $actuel ++;
						if($df == "fin") $next --; 
/*						{
							$next --;
							if($liste_ghost["$plage"]["fin"]["$offset"] ==  $liste_ghost["$plage"]["dbt"]["$offset"]) $new_retard --;
							else $actuel --;
						}*/
					}
				}
			}
//			echo "<br>actuel vaut $actuel et lastnext vaut $lastnext";
/*			if($retard == 8)
			{
				$liste_plages["$plage"]["nb"] = $actuel;
			}else{
				//$liste_plages["$plage"]["nb"] = $actuel + $retard;
			}*/
			$actuel += $lastnext;
			$liste_plages["$plage"]["nb"] = $actuel;
/*			$retard=$new_retard;
			$new_retard=0;*/
			if($actuel > $max_rdv) $max_rdv = $actuel;
		}
//		echo "<br>le maximum de rdv est de $max_rdv";
//		$this->tab_affiche($liste_plages);
		$return2= "<table border=0 cellspacing=0 cellpadding=0 width=100%>";
		$ncol=0;
		foreach($liste_plages as $plage => $df)
		{
			if($ncol==0) $lcol = "lignejour1";
			else $lcol = "lignejour2";
			$colspan=$max_rdv -$liste_plages["$plage"]["nb"];
			$return2 .= "\n<tr class=$lcol>";
			list($pheure, $pminute) = preg_split("#:#", $plage);
			if($pheure == "23")
			{
				$fheure="23";
				$fminute="59";
			}else{
				$fheure=$pheure + 1;
				$fminute=$pminute;
			}
			$tfin="$fheure:$fminute";
			$formdate=$this->univ_strftime("%Y-%m-%d", $date);
			$se="00";
			$jo = $this->univ_strftime("%d", $date);
			$mo = $this->univ_strftime("%m", $date);
			$an = $this->univ_strftime("%Y", $date);
			list($hplage,$mplage) = preg_split("#:#", $plage);
			$timeplage=mktime($hplage, $mplage, $se, $mo, $jo, $an);
			$endplage=$this->univ_strftime("%H:%M", $timeplage + 60 *($this->interval_rdv - 1));
			$aff_plage="$plage - $endplage";
// 			$this->form("modifier_rdv.php<td width=\"40%\">", "$plage", "", "$lcol", "", "nouveau", "on", "date_cours", "$formdate", "date_fin", "$formdate", "heure_debut", "$plage", "heure_fin", "$tfin", "personne", $personne).$this->form("modifier_rdv.php<td align=\"center\">", "-", "", "$lcol", "", "nouveau", "on", "date_cours", "$formdate", "date_fin", "$formdate", "heure_debut", "$plage", "heure_fin", "$tfin", "personne", $personne).$this->form("modifier_rdv.php<td align=\"right\" width=\"40%\">", "$endplage", "", "$lcol", "", "nouveau", "on", "date_cours", "$formdate", "date_fin", "$formdate", "heure_debut", "$plage", "heure_fin", "$tfin", "personne", $personne)
//			$return2 .= "<td>$plage ({$liste_plages["$plage"]["nb"]}/$max_rdv)</td>";
			$return2 .= "\n<td width=\"20\" class=\"$lcol\" style=\"cursor:pointer;color:#0000ff\" onclick=\"newRdv('$formdate','$plage','$personne')\">&nbsp;{$plage}&nbsp;-&nbsp;{$endplage}&nbsp;</td>";
			if(is_array($liste_plages["$plage"]["dbt"])) foreach($liste_plages["$plage"]["dbt"] as $id => $nombre)
			{
				$divid="div".$id;
				$tdid="td".$id;
				$height=20*$nombre ."px";
				$liste_id["$id"]=preg_replace("#toereg#", $height, $liste_id["$id"]);
				$return2 .= "<td class=\"delai_seul\" id=\"$tdid\" rowspan=$nombre style=\"height:100%\"><div id=$divid class=\"$classtexte\" style=\"position:relative;cursor:move\">{$liste_id["$id"]}</div></td>";
//				$return2 .= "<td>$nombre</td>";
			}
			for($x=0;$x<$colspan;$x++)
			{
				$return2 .= "<td class=\"$lcol\">&nbsp;</td>";
			}
			$return2 .= "</tr>";
			$ncol++;
			if($ncol == 2) $ncol = 0;
		}
		$return2 .= "</table>";
		if($type=="jour" AND $this->getCookie("etude_pda") != "on") $return=$return2;
		return $return;
	}
	
	function afficheDL($e, $class)
	{
		//il faut la liste des dlais, qui dpend de l'utilisateur
		if(!isset($this->listeDelaisTypes))
		{
			$this->listeDelaisTypes = array();
			$select=explode("\n", "{$_SESSION["optionGen"]["delais_type"]}");
			foreach($select as $option)
			{
				list($abrev, $nom)=preg_split("#,#", $option);
				$this->listeDelaisTypes[$abrev] = $nom;
			}
		}
		$couls .= $this->getColors($e[2], "delai");
		$rdv .= $this->smart_html($e[1]);
		if($e[4]) $rdv = "<del>$rdv</del> <span class=\"attention\">{$this->lang["agenda_annule"]}</span>";
		
		//infobulle
		$infobulle = $this->qui_fait_quoi($e[6], $e[7], $e[8], $e[9]);
		
		//ouverture RDV
		$onclick = "onclick=\"openDl('{$e[3]}')\"";
		
		//priorit
		if($e[10] == "2") $priorite = "<font color=orange>".$this->mysql_to_print($e[0], "%d.%m.%Y")."</font>";
		else $priorite = $this->listeDelaisTypes[$e[5]];
		if($e[5] == "1") $class = "class = \"attention\"";
		else $class = "";
		
		//Retour
		$r = "<td class='delaitexte'>$couls</td><td class='delaitexte' $infobulle $onclick>$rdv</td><td $class>$priorite</td><td style=\"text-align:right;padding-right:10\"><a class=\"duplicate\" name=\"#\" onclick=\"copyDl('{$e[2]}')\">[+]</a></td>";
		return $r;
	}
	function afficheRDV($e, $class)
	{
		//Couleurs des personnes concernes
		if($e[10])
		{
			$ajout = "<td><img src=\"images/{$e[10]}.png\"></td>";
			$nump =1;
		}
		else
		{
			$ajout = "";
			$nump = 0;
		}
		$couls .= $this->getColors($e[3], $class, $nump, $ajout);
		//Affichage du RDV
		$rdv = "";
		if(!$e[10])
		{
			$ajout = "texte";
			$rdv .= "{$e[1]}-{$e[2]}: ";
		}
		else
		{
			$ajout = "vacances";
		}
		$rdv .= $this->smart_html($e[0]);
		if($e[12]) $rdv = "<del>$rdv</del> <span class=\"attention\">{$this->lang["agenda_annule"]}</span>";
		
		//infobulle
		$infobulle = $this->qui_fait_quoi($e[6], $e[7], $e[8], $e[9]);
		
		//ouverture RDV
		$onclick = "onclick=\"openRdv('{$e[14]}')\"";
		
		//Retour
		$r = "<td class='{$class}texte'>$couls</td><td class='{$class}{$ajout}' $infobulle $onclick>$rdv</td><td style=\"text-align:right;padding-right:10\"><a class=\"duplicate\" name=\"#\" onclick=\"copyRdv('{$e[14]}')\">[+]</a></td>";
		return $r;
	}
	
	function getColors($c, $class, $nump = 0, $ajout = "")
	{
		$couls="<table class='{$class}texte' border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr style=padding:2px;margin:2px>$ajout";
		$qqn=FALSE;
		foreach(preg_split("/,/", $c) as $value)
		{
			if(trim($value) != "")
			{
				$nump++;
				$init=substr($value, 0, 2);
				$actColor = $this->liste_des_utilisateurs["$init"]["couleur"];
				$fond="background-";
				if(substr($value, 0, 1) == "_")
				{
					$init= substr($value, 1);
					$actColor = "ff0000";
					$fond="";
				}
				if(!$actColor) $actColor = "#ffffff";
				if(strtolower(substr($actColor, -6)) == "000000" && $fond == "background-") $txColor = ";color:ffffff";
				else $txColor = "";
				$couls .= "<td align=\"center\" style=\"{$fond}color:$actColor{$txColor}\" $pstyle>$init</td><td>&nbsp;</td>";
				$qqn=TRUE;
				if($nump ==3)
				{
					$nump=0;
					$couls .= "</tr><tr>";
				}
			}
		}
		if($qqn==FALSE)
		{
			$init="";
			$couls .= "<td align=\"center\">??</td>";
		}
		$couls .= "</tr></table>";
		return $couls;
	}
	
	function getMonth($date)
	{
// 		$date = "2013-1-25";
		list($annee, $mois, $jour) = preg_split("/-/", $date);
		//print "<br>'$date'";
		$mois += 0; // supprimer un ventuel zro initial
		//getting first and las days of month
		$fDOW = $this->univ_strftime("%u", mktime(1, 0, 0, $mois, 1, $annee));
		$fDOM = $this->univ_strftime("%Y-%m-%d", mktime(1, 0, 0, $mois, 2-$fDOW, $annee));
		
		$lDOW = $this->univ_strftime("%u", mktime(1, 0, 0, $mois + 1, 0, $annee));
		$lDOM = $this->univ_strftime("%Y-%m-%d", mktime(1, 0, 0, $mois + 1, 7 - $lDOW, $annee));

		list($aTD, $mTD, $jTD) = preg_split("/-/", $fDOM); 
		list($aTF, $mTF, $jTF) = preg_split("/-/", $fDOM);
		$this->jourAct = $this->univ_strftime("%Y-%m-%d", time());
		$this->jourActMTF = $this->mtf_date($this->jourAct);
		
		//comptons les jours...
		
		$nbJours = $this->univ_strftime("%j", mktime(1, 0, 0, $mois + 1, 7 - $lDOW, $annee) - mktime(1, 0, 0, $mois, 2-$fDOW, $annee)) + 0;
		
		//crons le tableau des jours  remplir
		
		$jours   = array();
		$indexes = array();
		list($pAnnee, $pMois, $pJour) = preg_split("/-/", $fDOM);
		for($x = 0; $x < $nbJours; $x ++)
		{
			$uTime = mktime(1, 0, 0, $pMois, $pJour + $x, $pAnnee);
			$jourTraite = $this->univ_strftime("%Y-%m-%d", $uTime);
			if($this->jourAct == $jourTraite) $class = "dujour";
			elseif($mois == $this->univ_strftime("%m", $uTime)) $class = "enmois";
			else $class = "horsmois";
			$jours[$jourTraite] = array("c" => $class, "u" => $uTime, "e" => array(), "d" => array());
			$indexes[] = $jourTraite;
		}
		
		
		
		//getting Month events
		$q="SELECt
		*,
		date_format(date_debut, '%c') as nomdumois
		from rdv 
		where 
		(
			(
				date_debut between '$fDOM' AND '$lDOM'
				OR date_fin between '$fDOM' AND '$lDOM'
				OR
				(
					date_debut <= '$fDOM' 
					AND (repete_fin >= '$fDOM' OR repete_fin  like '0000-00-00' OR repete_fin like '') 
					AND
					(
						repete like 'j' 
						OR repete like 's' 
						OR repete like 'm'
						OR (repete like 'a' AND (date_format(date_debut, '%c') = '$mois' OR date_format(date_fin, '%c') = '$mois'))
					)
				)
			)
			AND (({$this->clause}) or lieu not like '')
		)
		order by date_debut, heure_debut, heure_fin
		";
		$q2 = preg_replace("/\t/", "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;", nl2br($q));
// 		print "<br>'$q2'";
		$e = mysql_query($q);
		$this->now[] = microtime().": Dbut de la ventilation des dates";
		while($r = mysql_fetch_array($e, MYSQL_ASSOC))
		{
// 			$r["libelle"].= $r["nomdumois"];
			if($r["type"] == "vacances") $r["heure_debut"] = "-1";
			elseif($r["type"] == "anniversaire") $r["heure_debut"] = "-2";
			else
			{
				$r["heure_debut"] = substr($r["heure_debut"], 0, -3);
				$r["heure_fin"] = substr($r["heure_fin"], 0, -3);
			}
			if(!$r["repete"])
			{
				$i = $r["date_debut"];
				if($r["date_debut"] == $r["date_fin"])
				{
					$debut = $r["heure_debut"];
					$fin   = $r["heure_fin"];
					$jours[$i]["e"][] = array($r["libelle"], $debut, $fin, $r["rdv_pour"], $r["rdv_grp"], $r["priorite"], $r["np"], $r["nple"], $r["mp"], $r["mple"], $r["type"], $r["repete"], $r["biffe"], $r["lieu"], $r["id"]);
				}
				else
				{
					list($aD, $mD, $jD) = preg_split("/-/", $r["date_debut"]);
					list($aF, $mF, $jF) = preg_split("/-/", $r["date_fin"]);
					$tD = mktime(1, 0, 0, $mD, $jD, $aD);
					$tF = mktime(1, 0, 0, $mF, $jF, $aF);
					foreach($jours as $j => $arr) if($tD <= $arr["u"] && $tF >= $arr["u"])
					{
						$debut = ($tD < $arr["u"])? "00:00" : $r["heure_debut"];
						if($r["type"] == "vacances") $debut = "-1";
						elseif($r["type"] == "anniversaire") $debut = "-2";
						$fin = ($tF > $arr["u"])? "23:59" : $r["heure_fin"];
						$jours[$j]["e"][] = array($r["libelle"], $debut, $fin, $r["rdv_pour"], $r["rdv_grp"], $r["priorite"], $r["np"], $r["nple"], $r["mp"], $r["mple"], $r["type"], $r["repete"], $r["biffe"], $r["lieu"], $r["id"]);			
					}
				}
			}
			else
			{
				list($aD, $mD, $jD) = preg_split("/-/", $r["date_debut"]);
				list($aF, $mF, $jF) = preg_split("/-/", $r["repete_fin"]);
				$tD = mktime(1, 0, 0, $mD, $jD, $aD);
				$tF = mktime(1, 0, 0, $mF, $jF, $aF);
				if($aF + $mF + $jF == 0) $tF = False;
				if($r["repete"] == "j")
				{
					foreach($jours as $j => $arr) if($tD <= $arr["u"] && $tF >= $arr["u"])
					{
						$jours[$j]["e"][] = array($r["libelle"], $r["heure_debut"], $r["heure_fin"], $r["rdv_pour"], $r["rdv_grp"], $r["priorite"], $r["np"], $r["nple"], $r["mp"], $r["mple"], $r["type"], $r["repete"], $r["biffe"], $r["lieu"], $r["id"]);	
					}
				}
				if($r["repete"] == "s") //TODO: complter. Les RDV sur plusieurs jours ne sont pas pris en compte.
				{
// 					print "<br>{$r["libelle"]}";
					for($k = $this->univ_strftime("%u", $tD) -1;$indexes[$k];$k += 7) //Attention: les indexes commencent  zro alors que la semaine commence  1
					{
						$j = $indexes[$k];
						$arr = $jours[$j];
// 						print "<br>Test semaine de $k ($j): $tD <= {$arr["u"]} && $tF >= {$arr["u"]}";
						if($tD <= $arr["u"] && (!$tF || $tF >= $arr["u"]))
						{
// 							print " ... OK";
							$jours[$j]["e"][] = array($r["libelle"], $r["heure_debut"], $r["heure_fin"], $r["rdv_pour"], $r["rdv_grp"], $r["priorite"], $r["np"], $r["nple"], $r["mp"], $r["mple"], $r["type"], $r["repete"], $r["biffe"], $r["lieu"], $r["id"]);
						}
					}
				}				
				if($r["repete"] == "a") //TODO: idem que ci-dessus. En outre, il faut faire en sorte de vrifier non seulement le mois en cours mais galement les dbuts et fins de mois prcdant ou suivant. Je pense qu'on ne s'en sort pas sans un "adddate"
				{
// 					print "<br>TAGADA{$r["libelle"]} ({$r["date_debut"]}";
// 					$jourTest = $this->univ_strftime("%d", $tD);
// 					$tD <= $arr["u"] && $tF >= $arr["u"])
// 					{
// 						$jours[$j]["e"][] = array($r["libelle"], $r["heure_debut"], $r["heure_fin"], $r["rdv_pour"], $r["rdv_grp"], $r["priorite"], $r["np"], $r["nple"], $r["mp"], $r["mple"], $r["type"], $r["repete"], $r["biffe"], $r["lieu"]);	
// 					}
				}				
			}
// 			if(!$true)
// 			{
// 				print "<br>";
// 				foreach($r as $a => $b) /*if(! is_numeric($a))*/ print "$a: '$b'; ";
// 				$true = True;
// 			}
// 			print "<br>{$r["date_debut"]}, {$r["date_fin"]}, {$r["libelle"]}";
		}
		$this->now[] = microtime().": Fin de la ventilation des dates";
		$this->now[] = microtime().": Debut de l'affichage du mois";
		
		//getting Month todos
		$q="SELECt
		*
		from delais
		where 
		(
			(
				date_debut between '$fDOM' AND '$lDOM'
				OR date_fin between '$fDOM' AND '$lDOM'
			)
			AND ({$this->clause_DL})
			AND fait not like 'on'
		)
		order by date_fin, priorite
		";
// 		echo preg_replace("/\t/", "&nbsp;&nbsp;&nbsp;&nbsp;", nl2br("\n\n$q"));
/*				$ANDrepeteCond = "AND repete not like 'o'";
				$repeteCond = "OR ('$date_jour' between date_debut and date_fin AND repete like 'o')";
// 				echo "<br>$repeteCond";
			}

			
			$requete="select * from delais where ((date_fin $where_cond '$date_jour' $ANDrepeteCond) $repeteCond ) $where $who order by date_fin, priorite";*/		
		$e = mysql_query($q);
		while($r = mysql_fetch_array($e, MYSQL_ASSOC))
		{
// 			if(preg_match("/MOUTALATIF/", $r["libelle"]))
// 			{
// 				echo "\n<br>";
// 				foreach($r as $a => $b) echo "$a: $b ";
// 				echo "<br>".$this->mtf_date($r["date_debut"]). "<= {$this->jourActMTF} && {$r["repete"]} == 'o'";
// 			}
			if($jours[$r["date_fin"]]) $jours[$r["date_fin"]]["d"][] = array($r["date_fin"], $r["libelle"], $r["dl_pour"], $r["id"], $r["biffe"], $r["priorite"], $r["np"], $r["nple"], $r["mp"], $r["mple"], 1);
			if($r["repete"] == "o" && $r["date_fin"] != $r["date_debut"])
			{
				if($this->mtf_date($r["date_debut"]) <= $this->jourActMTF) $jours[$this->jourAct]["d"][] = array($r["date_fin"], $r["libelle"], $r["dl_pour"], $r["id"], $r["biffe"], $r["priorite"], $r["np"], $r["nple"], $r["mp"], $r["mple"], 2);
				else                                                       $jours[$r["date_debut"]]["d"][] = array($r["date_fin"], $r["libelle"], $r["dl_pour"], $r["id"], $r["biffe"], $r["priorite"], $r["np"], $r["nple"], $r["mp"], $r["mple"], 2);
			}
			//echo "<br>{$r["date_debut"]}-{$r["date_fin"]}: {$r["libelle"]}";
		}
		$monthname=$this->univ_strftime("%B %Y", $this->mtf_date($date));
		$affiche  = $this->table_open("align=center");
		$affiche .= $this->form("agendanew.php<td>", "-", "", "", "", "date_cours", $this->univ_strftime("%Y-%m-%d", mktime(1, 0, 0, $mois -1, 1, $annee)));
		$affiche .= "<td>".htmlentities(ucfirst($monthname))."</td>";
		$affiche .= $this->form("agendanew.php<td>", "+", "", "", "", "date_cours", $this->univ_strftime("%Y-%m-%d", mktime(1, 0, 0, $mois +1, 1, $annee)));
		$affiche .= $this->table_close();
		
		$affiche .= $this->table_open("height=100%");
		$compteur = 1;
		foreach($indexes as $i)
		{
			if($compteur == 1) $affiche .= "\n\t<tr>".$this->form("{$this->dest}<td>", $this->univ_strftime("%V", $jours[$i]["u"]), "", "semaine", "", "date_cours", $i, "type", "semaine");//.$this->univ_strftime("%V", $jours[$i]["u"])."</td>";
			$nomJour = $this->univ_strftime("%a %d", $jours[$i]["u"]);
			$nouvelle_date_cours=$this->univ_strftime("%Y-%m-%d", $jours[$i]["u"]);
			if($jours[$i]["c"] == "dujour") $affiche .= "<a name=today></a>";
			$affiche .= "\n\t\t<td class='{$jours[$i]["c"]}texte' style = 'vertical-align:top' width=14%>";
			$affiche .= $this->table_open("width=100% height=100%");
			$affiche .= "<tr><td style='vertical-align:top;height:10px'>";
// 			$affiche .= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<br>";
			$affiche .= "<span class='nomjourmois'>$nomJour</span>";
			$affiche .= "&nbsp;<span class=\"delai_seul\" style=\"cursor:pointer;color:#0000ff\" onclick=\"newRdv('$nouvelle_date_cours', '{$this->dbt_jour}', '{$this->liste_personne}')\">&nbsp;+&nbsp;</span>";

			//Tri par heure_debut (priorit) !
			$rdvs = array();
			$dls = array();
			foreach($jours[$i]["e"] as $j => $e) $rdvs[$j] = $e[1].$e[0];
			foreach($jours[$i]["d"] as $j => $d) $dls[$j]  = $d[5];
			asort($rdvs);
			asort($dls);
// $this->tab_affiche($dls);
			$e = $jours[$i]["e"];
			$d = $jours[$i]["d"];
// 			foreach($jours[$i]["e"] as $e)
// 			$rdvs2 = $rdvs;
// 			$this->tab_affiche($rdvs2);
			$affiche .= "</td></tr><tr><td style='vertical-align:top'>\n\t\t\t<table width=100%>";
			foreach($rdvs as $j => $v)
			{
// 				$affiche .= "<br>{$e[$j][1]}-{$e[$j][2]}:{$e[$j][0]}";
				$affiche .= "\n\t\t\t<tr>".$this->afficheRDV($e[$j], $jours[$i]["c"])."</tr>";
			}
			$affiche .= "\n\t\t\t</table></td></tr><tr width=100% valign=bottom><td>";
			$affiche .= "\n\t\t\t<table width=100% class='delaitexte'>";
			foreach($dls as $j => $v)
			{
// 				$affiche .= "<br>{$e[$j][1]}-{$e[$j][2]}:{$e[$j][0]}";
				$affiche .= "\n\t\t\t<tr>".$this->afficheDL($d[$j], $jours[$i]["c"])."</tr>";
			}
			$affiche .= "\n\t\t\t</table></td></tr>";
			$affiche .= $this->table_close();
			$affiche .= "\n\t\t</td>";
			if($compteur == 7)
			{
				$affiche .= "\n\t</tr>";
				$compteur = 0;
			}
			$compteur ++;
		}
		$affiche .= $this->table_close();
		print $affiche;
		$this->now[] = microtime().": Fin de l'affichage du mois";
// 		$this->tab_affiche($jours);
		
	}
	
	function getPeriode($date=False, $typePeriode = False)
	{
		if(!$date) 
		{
			//print "{$_POST["date_cours"]} = {$_POST["annee_cours"]}-{$_POST["mois_cours"]}-{$_POST["jour_cours"]}";
			if(! $_POST["date_cours"] && $_POST["jour_cours"] && $_POST["mois_cours"] && $_POST["annee_cours"])
			{
				$_POST["date_cours"] = "{$_POST["annee_cours"]}-{$_POST["mois_cours"]}-{$_POST["jour_cours"]}";
			}
			$date = $_POST["date_cours"];
		}
		if(!$typePeriode) $typePeriode = $_POST["type"];
		if(!$typePeriode) $typePeriode = "mois";
		if($typePeriode == "mois")
		{
			$this->getClause();
			return $this->getMonth($date);
		}
		else return $this->display_multi($typePeriode, $date, FALSE, $this->liste_personne);
	}
	function getClause()
	{
		$this->liste_utilisateursgroupes_revert();	
		$this->liste_utilisateursgroupes_ex();	
	
		$personne = $this->liste_personne;
		$compteur=1;
		$array1=preg_split("#,#", $personne);
		$array = array();
		foreach($array1 as $n) if(trim($n) != "")
		{
			if(!in_array($n, $array)) $array[] = $n;
			if(is_array($this->liste_des_utilisateursgroupes_revert["$n"])) foreach($this->liste_des_utilisateursgroupes_revert["$n"] as $grp) if(!in_array("_$grp", $array)) $array[] = "_$grp";
			if(substr(trim($n), 0, 1) == "_")
			{
				$grp = substr(trim($n), 1);
				if(is_array($this->liste_des_utilisateursgroupes_ex[$grp])) foreach($this->liste_des_utilisateursgroupes_ex[$grp] as $member) if(!in_array($member, $array)) $array[] = $member;
			}
		}

		//construction de la requte
		foreach ($array as $gugusse)
		{
			if(trim($gugusse) != "")
			{
				$gugusse = trim($gugusse);
				if($compteur == 1) $clause = "rdv_pour like '%$gugusse%'";
				else $clause .= " OR rdv_pour like '%$gugusse%'";
				$compteur ++;
			}
		}
		$this->clause = $clause;
		$this->clause_DL = preg_replace("/rdv_pour/", "dl_pour", $this->clause);
		$this->arrGugusses = $array;
	
	}
	
/*	function get_rdv($date, $pers)
	{
		$query="select *from rdv where (date_debut <= '$date' AND date_fin >= '$date') AND dl_pour like '%$pers%'";
		$exec=mysql_query($query);
		while($row=mysql_fetch_array($exec))
		{
			echo "<br>rendez-vous: {$row["titre"]} de {$row["heure"]}  {$row["heure"]}";
		}
	}*/
	
	function display_multi($type="semaine", $date="", $petit=FALSE, $personne="", $with_select=FALSE) //$type : "jour" | "semaine" | "mois"
	{
//		if($personne == "") echo "rat d'entre";
		if($date == "") $date = time();
		else $date = $this->mtf_date($date);
		$initdate=$date;
		$fdate=$this->univ_strftime("%Y-%m-%d", $date);
		if($type == "mois") $date=$this->mtf_date($this->get_first($this->univ_strftime("%Y-%m-%d", $date), "mois"));
		$var=$this->get_first($this->univ_strftime("%Y-%m-%d", $date), "semaine");
		$fday=$var["first"];
		$lday=$var["last"];
		$frameName = ($type == "jour") ? "framejour_$fdate" : "frame$type";
		if($petit) $affiche=$this->table_open("border = \"0\" cellspacing = \"0\" cellpadding = \"0\"");
		elseif(!$this->agendaSolo) $affiche=$this->table_open("width=\"100%\" height=\"100%\" border = \"0\" id=\"$frameName\"");
		else $affiche = "";
		if($type == "semaine")
		{
			$this->fBegDay=$fday;
			$this->fEndDay=$this->univ_strftime("%Y-%m-%d", $this->mtf_date($fday) + 6 * 84000);
			$afday=$this->mysql_to_print($fday);
			$alday=$this->mysql_to_print($lday);
			$sem=$this->univ_strftime("%V", $this->mtf_date($fday));
			$affiche .= "\n<tr><th colspan = \"2\">{$this->lang["agenda_semaine_no"]} $sem ($afday - $alday)</th></tr>";
			for($d=1; $d<8; $d ++)
			{
				if ($this->date_jour == $fday) $class = "dujour";
				else $class = "enmois"; 
				if(round($d / 2) != ($d / 2)) $affiche .= "\n<tr>";
				$rowspan = ($d == 5)? "rowspan = 2":"";
				$affiche .= "<td $rowspan class=\"$class\" valign=top width=50%>";
				$affiche .= $this->display_day($fday, $class, "", $personne);
				$affiche .= "</td>";
				if(round($d / 2) == ($d / 2)) $affiche .= "\n</tr>";
				$fday=$this->univ_strftime("%Y-%m-%d", $this->mtf_date($fday) + 84000);
			}
		}
		if($type == "mois")
		{
// 			$fdate=$this->univ_strftime("%Y-%m-%d", $date);
			if(isset($this->nb_form)) $this->nb_form ++;
			else $this->nb_form = 1;
			$monthname=$this->univ_strftime("%B %Y", $date);
			if($petit)
			{
				$url=$this->settings["root"].$this->dest;
				$name = "change" . $this->nb_form;
// 				$target=($this->retour)? "target=\"window.opener\"":"";
				$target="";
				$affiche .= "<form action=\"$url\" name=\"$name\" id=\"$name\" method=\"post\" $target>";
				$affiche .= "\n<tr valign=top><td colspan = \"9\">". $this->table_open("cellpadding=0 cellspacing=0 align=\"right\" border=0")."<tr>";
				$affiche .= "<td>";
				$affiche .= $this->button("->", "", "semaine_entete");
				$affiche .= $this->chdate($date, "mois", FALSE, "semaine");
				$affiche .= $this->chdate($date, "annee", FALSE, "semaine");
				$affiche .= $this->input_hidden("jour_cours", "", $this->univ_strftime("%d", $date));
				$affiche .= $this->input_hidden("type", "", "mois");
				$affiche .= "</td>";
				$affiche .= "</tr>".$this->table_close()."</td>";
				if($with_select)
				{
					$groups=(preg_match("#LSSTRAIT#", $personne))? FALSE:TRUE;
					$colspan=(preg_match("#LSSTRAIT#", $personne))? "1":"2";
					$formname=(preg_match("#LSSTRAIT#", $personne))? "soustraitant[]":"personne[]";
					$liste=(preg_match("#LSSTRAIT#", $personne))? $personne:$this->liste_personne;
					$formulaire=(preg_match("#LSSTRAIT#", $personne))?$this->simple_selecteur("", $liste):$this->selecteur($_SESSION["session_utilisateur"], TRUE, FALSE, FALSE, $liste, TRUE);
// 					$formulaire="selecteur";
					$affiche .= "<td rowspan=8>&nbsp;</td><td class=\"semaine\" rowspan=\"8\"><table><tr><td colspan=$colspan>";
					$affiche .= $this->button("{$this->lang["apropos_pour"]}&nbsp;->", "", "semaine_entete")."</td></tr><tr><td><select multiple name=\"$formname\" id=\"pers\" size=\"6\" class=\"semaine\">".$formulaire."</select>";
/*					$affiche .= $this->input_hidden("type", 1);
					$affiche .= $this->input_hidden("template", 1);*/
					$affiche .= "</td>";
					if(!preg_match("#LSSTRAIT#", $personne)) $affiche .= "<td><select multiple name=\"groups[]\" size=\"6\" class=\"semaine\">".$this->selecteur($_SESSION["session_utilisateur"], TRUE, FALSE, FALSE, $liste, TRUE, $groups, TRUE)."</select></td>";
				}
				$affiche .= "</tr>";
				if($with_select)
				{
					if(!preg_match("#LSSTRAIT#", $personne)) $affiche .= "<tr><td colspan=2>{$this->lang["liste_delais_avec"]}: <input type=\"checkbox\" name=\"faits\" $this->faits_check></td></tr></table></td></tr>";
					else $affiche .= "</table></td></tr>";
				}
				$affiche .= "</form>";
			}else{
				//prparation des donnes pour atteindre le mois prcdent ou le mois suivant
				list($anneeCours, $moisCours) = preg_split("#-#", $_POST["date_cours"]);
				$pYear = $anneeCours;
				$nYear = $anneeCours;
				$pMonth = $moisCours -1;
				$nMonth = $moisCours +1;
				if($moisCours == "12")
				{
					$nMonth = 1;
					$nYear ++;
				}
				if($moisCours == "1")
				{
					$pMonth = 12;
					$pYear --;
				}
				$affiche .= "\n<tr><th width=\"30\">&nbsp;</th><th colspan = \"7\">".$this->table_open("align=\"center\"")."<tr>";
				$affiche .= $this->form("agendanew.php<td>", "-", "", "", "", "date_cours", "$pYear-$pMonth-1");
				$affiche .= "<td>".htmlentities(ucfirst($monthname))."</td>";
				$affiche .= $this->form("agendanew.php<td>", "+", "", "", "", "date_cours", "$nYear-$nMonth-1");
				$affiche .= "</tr>".$this->table_close()."</th></tr>";
			}
			$this->fBegDay=$fday;
			//il faut dterminer si le mois a 5 ou 6 semaines affiches
			//TODO
			$this->fEndDay=$this->univ_strftime("%Y-%m-%d", $this->mtf_date($fday) + 34 * 86400);
			for($d=1; $d<43; $d ++)
			{
				if($this->univ_strftime("%m", $date) != $this->univ_strftime("%m", $this->mtf_date($fday))) $class="horsmois";
				elseif ($this->date_jour == $fday) $class = "dujour";
				else $class = "enmois";
				if($petit)
				{
					if ($this->date_jour == $fday) $class = "today";
					elseif ($fday == $fdate) $class = "semaine_select";
 					else $class="semaine";
				}
				$sem=$this->univ_strftime("%V", $fday);
				if(round(($d -1) / 7) == ($d -1) / 7) 
				{
					$semclass=($petit)? "semaine_entete":"";
					$form=$this->form("{$this->dest}<td>", $this->univ_strftime("%V", $this->mtf_date($fday)), "", "$semclass", "", "date_cours", $fday, "type", "semaine");
					$affiche .= "\n<tr>$form<td>&nbsp;</td>";
				}
// 				if($petit) $affiche .= "<td $rowspan valign=top>";
// 				else $affiche .= "<td $rowspan class=\"$class\" valign=top>";
				if($petit)
				{
					$affiche .= $this->form("{$this->dest}<td $rowspan align=right>", $this->univ_strftime("%d", $this->mtf_date($fday)), "", "$class", "", "date_cours", $fday, "type", "jour");
					
				}
				else
				{
					$affiche .= "<td $rowspan class=\"$class\" valign=top>".$this->display_day($fday, $class, "", $personne)."</td>";
					$this->now[] = microtime().": Appel de display_day pour $fday - ici";
				}
				if(round(($d -7) / 7) == ($d -7) / 7) 
				{
					$val_test=$this->univ_strftime("%m", $date) + 1;
					if($val_test == 13) $val_test = 1;
					$val_ref=$this->univ_strftime("%m", $this->mtf_date($fday));
					if($val_test != $val_ref) $affiche .= "\n</tr>";
					else break;
				}
				$nextday = $this->mtf_date($fday) + 86400;
				$fday=$this->univ_strftime("%Y-%m-%d", $nextday);
			}
			$affiche .= "\n</tr>";
		}
		if($type == "jour")
		{
			$affiche .= "\n<tr><th>".$this->univ_strftime("%x", $date)."</th></tr>";
			$affiche .= "<tr><td>".$this->display_day($this->univ_strftime("%Y-%m-%d", $date), "enmois", "jour", $personne)."</td></tr>";
		}
		if($type == "jourReload")
		{
			$affiche .= "<tr><td>".$this->display_day($this->univ_strftime("%Y-%m-%d", $date), preg_replace("#texte$#", "", $_POST["specCN"]), "", $personne)."</td></tr>";
		}
		if($petit) $affiche .= "<tr><td colspan=9>&nbsp;</td></tr>";
		$affiche .= $this->table_close();
		return $affiche;
	}
	
	
	function get_first($date="", $type="semaine")
	{
		if($date == "") $date = time();
		else $date = $this->mtf_date($date);
//		echo "<br>le jour de la semaine est  l'heure actuelle le ".($this->univ_strftime("%u", $date));
		if($type == "semaine")
		{
			$var["first"] = $this->univ_strftime ("%Y-%m-%d", $date - (($this->univ_strftime("%u", $date) -1) * 86400));
			$soustr=$this->univ_strftime("%u", $date);
			$soustr=7-$soustr;
			$var["last"]=$date + ($soustr * 86400);
			$var["last"]=$this->univ_strftime ("%Y-%m-%d", $var["last"]); 
			return $var;
		}
		elseif($type == "mois") 
		{
			$first = $this->univ_strftime ("%Y-%m-%d", mktime(1, 0, 0, $this->univ_strftime("%m", $date), 1, $this->univ_strftime("%Y", $date)));
			return $first;
		}
	}
	
	function chdate($date, $type, $alone=FALSE, $class="")
	{
		if(!preg_match("#-#", $date)) $date=$this->univ_strftime ("%Y-%m-%d", $date);
		list($year, $month, $day) = preg_split("#-#", $date);
		if($type == "semaine")
		{
			for($n=-6; $n<7; $n++)
			{
				$array[]=$year + $n ."-$month-$day";
			}
		}
		if($type == "annee")
		{
			for($n=-6; $n<7; $n++)
			{
				$array[]=$year + $n ."-$month-$day";
			}
		}
		if($type == "mois")
		{
			for($n=-6; $n<6; $n++)
			{
				$curmonth = $month + $n;
				$curyear = $year;
				if($curmonth < 1)
				{
					$curmonth +=12;
					$curyear -= 1;
					
				}
				if($curmonth > 12)
				{
					$curmonth -=12;
					$curyear += 1;
					
				}
				if($curmonth < 10) $curmonth = "0".$curmonth;
				$array[]="$curyear-$curmonth-$day";
			}
		}
		foreach($array as $datechange)
		{
// 			if($alone)
			if($type == "annee") $display = $this->univ_strftime("%Y", $this->mtf_date($datechange));
			if($type == "mois") $display = $this->univ_strftime("%B", $this->mtf_date($datechange));
			$selected="";
			if($date==$datechange) $selected="selected";
			if($alone) $valdate=$datechange;
			elseif($type == "mois") $valdate = $this->univ_strftime("%m", $this->mtf_date($datechange));
			elseif($type == "annee") $valdate = $this->univ_strftime("%Y", $this->mtf_date($datechange));
			$listselect=$listselect."\n<option value=\"$valdate\" $selected>".htmlentities($display)."</option>";
		}
		
		$name="ch".$type;
		if($alone) $input = "date_cours";
		elseif($type == "mois") $input = "mois_cours";
		elseif($type == "annee") $input = "annee_cours";
		if($alone) $change="onchange=\"$name.submit()\"";
		if($alone) $list="<form action=\"{$this->dest}\" method=\"post\" name=\"$name\" class=\"\">";
		$list.="<th><select name=\"$input\" $change class=\"$class\">";
		$list.=$listselect;
		$list.="</select></th>";
		if($alone) $list.="</form>";
		return $list;
	}
	
	function addtime($time, $interval)
	{
		list($h, $m) = preg_split("#:#", $time);
		list($h2, $m2) = preg_split("#:#", $interval);
		$h += $h2;
		$m += $m2;
//		echo "<br>$h:$m";
		while($m > 60)
		{
			$h +=1;
			$m -= 60;
//			if($x == 20) break;
		}
		$h=($h<10)?"0".$h:$h;
		$m=($m<10)?"0".$m:$m;
		$new_time="$h:$m";
		return $new_time;
	}
	
	function display_dl($periodes="<,=,>", $date_jour="", $personne="", $petit=FALSE)
	{
		if($_POST["faits"] == "on") $where = "";
		else $where = "and fait not like 'on'";
		if($personne == "") $personne2 = array();
		elseif(is_array($personne)) $personne2 = $personne;
		else $personne2=preg_split("#,#", $personne);
		
		$personne = array();				
		$this->liste_utilisateursgroupes_revert();	
		$this->liste_utilisateursgroupes_ex();	
	
		foreach($personne2 as $n) if(trim($n) != "")
		{
			if(!in_array($n, $personne)) $personne[] = $n;
			if(is_array($this->liste_des_utilisateursgroupes_revert["$n"])) foreach($this->liste_des_utilisateursgroupes_revert["$n"] as $grp) if(!in_array("_$grp", $personne)) $personne[] = "_$grp";
			if(substr(trim($n), 0, 1) == "_")
			{
				$grp = substr(trim($n), 1);
				if(is_array($this->liste_des_utilisateursgroupes_ex[$grp])) foreach($this->liste_des_utilisateursgroupes_ex[$grp] as $member) if(!in_array($member, $personne)) $personne[] = $member;
			}
		}

		//construction de la requte
		$who="";
		foreach ($personne as $gugusse)
		{
			if(trim($gugusse) != "")
			{
				if($who != "") $who .= " OR ";
				else $who = " AND (";
				$who .= "dl_pour like '%$gugusse%'";
			}
		}
						
		if($who != "") $who .= ")";
		if($date_jour == "") $date_jour = $this->date_jour;
		$return="";
		$arr_periodes=array();
		if(preg_match("#<#", $periodes)) $arr_periodes["<"] = $this->lang["liste_delais_delais_passes"];
		if(preg_match("#=#", $periodes)) $arr_periodes["="] = preg_replace("#DATEJOUR#", $this->mysql_to_print($date_jour), $this->lang["liste_delais_delais_jour"]);
		if(preg_match("#>#", $periodes)) $arr_periodes[">"] = $this->lang["liste_delais_delais_prochains"];
		foreach($arr_periodes as $where_cond => $titre)
		{
			if($petit != "abrege")
			{
				$return .= "\n<br><br>";
				if($petit == FALSE) $return .= "\n<h2>$titre</h2>";
				else $return .= "\n<h3>$titre</h3>";
			}
			$return .= "\n<table style=background-color:ffffff width=100%>";
			
			$ANDrepeteCond = "";
			$repeteCond = "";
			if($where_cond == "=")
			{
				$ANDrepeteCond = "AND repete not like 'o'";
				$repeteCond = "OR ('$date_jour' between date_debut and date_fin AND repete like 'o')";
// 				echo "<br>$repeteCond";
			}

			
			$requete="select * from delais where ((date_fin $where_cond '$date_jour' $ANDrepeteCond) $repeteCond ) $where $who order by date_fin, priorite";
 			/*echo "<br>$requete";*/
			$exec=mysql_query($requete);
			$numrow=mysql_num_rows($exec);
			if($where_cond == "<") $warning = "<img src=\"./images/warning.png\">";
			else $warning="&nbsp;";
			if($numrow > 0 && $petit != "abrege") $return .= "\n<tr class=menu><th>$warning</th><th>".$this->lang["modifier_delai_pour"]."</th><th>".$this->lang["liste_delais_date_to"]."</th><th colspan=\"2\">".$this->lang["operations_op"]."</th><th>".$this->lang["modifier_delai_priorite"]."</th><th>".$this->lang["liste_delais_termine"]."</th></tr>";
			
			$firstDl=true;
		
			while($row=mysql_fetch_array($exec))
			{
				$nump=0;
				$pstyle=($petit == "abrege")?"class=\"affdl\"":"";
// 				if($petit == "abrege" && $firstDl==true) $return .= "\n<tr><td><hr></td></tr>";
				$firstDl=false;
				$row["libelle"] = $this->smart_html($row["libelle"]);
				if($row["biffe"]) $row["libelle"] = "<del>{$row["libelle"]}</del> <span class=\"attention\">{$this->lang["agenda_pas_faire"]}</span>";
				if($row["fait"] == "on") $row["libelle"] = "<del>{$row["libelle"]}</del>";
				$couls="<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr>";
				$qqn=FALSE;
				foreach(explode(",", $row["dl_pour"]) as $value)
				{
					if(trim($value) != "")
					{
						$nump++;
						$init=substr($value, 0, 2);
						$actColor = $this->liste_des_utilisateurs["$init"]["couleur"];
						if(substr($value, 0, 1) == "_")
						{
							$init= substr($value, 1);
							$actColor = "ff0000";
						}
						if(!$actColor) $actColor = "#ffffff";
						$couls .= "<td align=\"center\" style=\"background-color:$actColor\" $pstyle>$init</td>";
						$qqn=TRUE;
						if($nump ==3 && $petit == "abrege")
						{
							$nump=0;
							$couls .= "</tr><tr>";
						}
					}
				}
				if($qqn==FALSE)
				{
					$init="";
					$couls .= "<td align=\"center\">??</td>";
				}
				$couls .= "</tr></table>";
				if($row["fait"]=="on") $fait=$this->lang["general_oui"];
				else $fait=$this->lang["general_non"];
				$onmouseover=$this->qui_fait_quoi($row["np"], $row["nple"], $row["mp"], $row["mple"]);
				$actColor = trim($this->liste_des_utilisateurs["$init"]["couleur"]);
				if(!$actColor) $actColor = "#ffffff";
				$return .= "\n<tr $onmouseover style=\"cursor:pointer\" $pstyle bgdcolor=\"$actColor\">";
				if($petit != "abrege")
				{
					$return .="<td onclick=\"openDl('{$row["id"]}')\">";
				//	$return .= "la couleur vaut ", $this->color_all["$init"];
					if($row["fait"] != "on") $return .= $warning;
					$return .= "&nbsp;</td>";
				}
				$return .="<td onclick=\"openDl('{$row["id"]}')\">$couls</td>";
				if($petit != "abrege") $return .= "<td onclick=\"openDl('{$row["id"]}')\">".$this->mysql_to_print($row["date_fin"], "%d.%m.%Y")."</td>";
				$return .= "<td onclick=\"openDl('{$row["id"]}')\">{$row["libelle"]}</td><td style=\"text-align:right;padding-right:10\"><a class=\"duplicate\" name=\"#\" onclick=\"copyDl('{$row["id"]}')\">[+]</a></td>";
				$select=explode("\n", "{$_SESSION["optionGen"]["delais_type"]}");
				$testval=false;
				if($date_jour == $row["date_fin"] || $where_cond != "=")
				{
					foreach($select as $option)
					{
						list($abrev, $nom)=preg_split("#,#", $option);
						if($row["priorite"]==$abrev)
						{
							$testval = true;
							if($abrev == "1" && $petit != "abrege") $class = "class = \"attention_bg\"";
							elseif($abrev == "1" && $petit == "abrege") $class = "class = \"attention\"";
							else $class = "";
							$nom = $this->smart_html($nom);
							if($petit == "abrege") $nom = "<i>$nom</i>";
							$return .= "<td $class onclick=\"openDl('{$row["id"]}')\">$nom</td>";
						}
					}
				}
				else
				{
					$nom = "<font color=orange>".$this->mysql_to_print($row["date_fin"], "%d.%m.%Y")."</font>";
					if($petit == "abrege") $nom = "<i>$nom</i>";
					$return .= "<td onclick=\"openDl('{$row["id"]}')\">$nom</td>";
				}
				if(!$testval) $return .= "<td>&nbsp;</td>";
				if($petit != "abrege") $return .="<td onclick=\"openDl('{$row["id"]}')\">$fait</td>";
				$return .="</tr>";
			}
			$return .= "</table>";
		}
		return $return;

	}
	
	function create_dragboxes()
	{
		$string="<script type=\"text/javascript\"><!-- SET_DHTML(";
		$premier=FALSE;
		foreach($this->liste_divs as $val)
		{
			$string .= ($premier == TRUE)? ", \"":"\"";
			$string .= $val;
			$string .= "\"";
			$premier = TRUE;
		}
		$string .= ");//--></script>";
		return $string;

	}
	
	function create_groups()
	{
		$return = "\nvar noms = new Array();";
		$return .= "\nvar inits = new Array();";
		foreach($this->liste_des_utilisateursgroupes() as $line)
		{
			list($groupname, $membres)=preg_split("#;#", $line);
			$groups["$groupname"]=explode(",", $membres);
		}
		foreach($this->liste_des_utilisateurs() as $line => $ar)
		{
			list($name, $init)=preg_split("#,#", $line);
			$init = substr($init, 0, 2);
			$pers["$init"]=$name;
		}
		
		$act_group="";
		$index=0;
		foreach($groups as $groupname => $array)
		{
			if($groupname != $act_group)
			{
				$act_group = $groupname;
				$xindex=0;
				$return .= "\nnoms[$index] = new Array();";
				$return .= "\ninits[$index] = new Array();";
				foreach($groups[$groupname] as $membre)
				{
					$init = trim($membre);
					$nom = $pers[$init];
					$return .= "\ninits[$index][$xindex] = '$init';";
					$return .= "\nnoms[$index][$xindex] = '$nom';";
					$xindex++;
				}
				$index ++;
			}
		}
		$return .= "\n\n\nfunction chgroup(index){\n
 
		var init = inits[index];
		var nom = noms[index];
		if (init != '')
		{
			opt=document.getElementById('pers');
			opt.options.length = init.length;
			for (i=0; i<init.length; i++)
			{
				opt.options[i].value = init[i];
				opt.options[i].text = nom[i];
			}
			document.monFormulaire.choixVille.options.selectedIndex = 0;
		}
		else
		{
			formulaire.choixVille.options.length = 1;
			formulaire.choixVille.options[0].value = 0;
			formulaire.choixVille.options[0].text = '-- choisissez une ville';
		}";
 		$return .= "\n}";
		return $return;
	}

}
?>
